/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize.charcode;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import net.sf.saxon.serialize.charcode.CharacterSet;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.tree.tiny.CharSlice;

public class JavaCharacterSet
implements CharacterSet {
    public static HashMap<Charset, JavaCharacterSet> map;
    private CharsetEncoder a;
    private byte[] b = new byte[65536];

    private JavaCharacterSet(Charset charset) {
        this.a = charset.newEncoder();
    }

    public static synchronized JavaCharacterSet makeCharSet(Charset charset) {
        JavaCharacterSet javaCharacterSet;
        if (map == null) {
            map = new HashMap(10);
        }
        if ((javaCharacterSet = map.get(charset)) == null) {
            javaCharacterSet = new JavaCharacterSet(charset);
            map.put(charset, javaCharacterSet);
        }
        return javaCharacterSet;
    }

    @Override
    public final boolean inCharset(int n2) {
        if (n2 <= 127) {
            return true;
        }
        if (n2 <= 65535) {
            if (this.b[n2] == 1) {
                return true;
            }
            if (this.b[n2] == 2) {
                return false;
            }
            if (this.a.canEncode((char)n2)) {
                this.b[n2] = 1;
                return true;
            }
            this.b[n2] = 2;
            return false;
        }
        char[] cArray = new char[2];
        char[] cArray2 = cArray;
        cArray[0] = UTF16CharacterSet.highSurrogate(n2);
        cArray2[1] = UTF16CharacterSet.lowSurrogate(n2);
        return this.a.canEncode(new CharSlice(cArray2));
    }

    @Override
    public String getCanonicalName() {
        return this.a.charset().name();
    }
}

