/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize.charcode;

import java.util.function.IntPredicate;
import net.sf.saxon.serialize.charcode.CharacterSet;

public class UTF16CharacterSet
implements CharacterSet {
    private static UTF16CharacterSet a = new UTF16CharacterSet();
    public static final int NONBMP_MIN = 65536;
    public static final int NONBMP_MAX = 0x10FFFF;
    public static final char SURROGATE1_MIN = '\ud800';
    public static final char SURROGATE1_MAX = '\udbff';
    public static final char SURROGATE2_MIN = '\udc00';
    public static final char SURROGATE2_MAX = '\udfff';

    private UTF16CharacterSet() {
    }

    public static UTF16CharacterSet getInstance() {
        return a;
    }

    @Override
    public boolean inCharset(int n2) {
        return true;
    }

    @Override
    public String getCanonicalName() {
        return "UTF-16";
    }

    public static int combinePair(char c2, char c3) {
        return (c2 - 55296 << 10) + (c3 - 56320) + 65536;
    }

    public static char highSurrogate(int n2) {
        return (char)((n2 - 65536 >> 10) + 55296);
    }

    public static char lowSurrogate(int n2) {
        return (char)((n2 - 65536 & 0x3FF) + 56320);
    }

    public static boolean isSurrogate(int n2) {
        return (n2 & 0xF800) == 55296;
    }

    public static boolean isHighSurrogate(int n2) {
        return 55296 <= n2 && n2 <= 56319;
    }

    public static boolean isLowSurrogate(int n2) {
        return 56320 <= n2 && n2 <= 57343;
    }

    public static boolean containsSurrogates(CharSequence charSequence) {
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (!UTF16CharacterSet.isSurrogate(charSequence.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static int firstInvalidChar(CharSequence charSequence, IntPredicate intPredicate) {
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            int n2 = charSequence.charAt(i2);
            if (UTF16CharacterSet.isHighSurrogate(n2)) {
                char c2 = charSequence.charAt(i2++);
                n2 = UTF16CharacterSet.combinePair((char)n2, c2);
            }
            if (intPredicate.test(n2)) continue;
            return n2;
        }
        return -1;
    }

    public static void main(String[] stringArray) {
        System.err.println(Integer.toHexString(UTF16CharacterSet.highSurrogate(983039)));
        System.err.println(Integer.toHexString(UTF16CharacterSet.lowSurrogate(983039)));
    }
}

