/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize.charcode;

import net.sf.saxon.serialize.charcode.CharacterSet;

public final class UTF8CharacterSet
implements CharacterSet {
    private static UTF8CharacterSet a = new UTF8CharacterSet();

    private UTF8CharacterSet() {
    }

    public static UTF8CharacterSet getInstance() {
        return a;
    }

    @Override
    public final boolean inCharset(int n2) {
        return true;
    }

    @Override
    public final String getCanonicalName() {
        return "UTF-8";
    }

    public static int getUTF8Encoding(char c2, char c3, byte[] byArray) {
        if (c2 <= '\u007f') {
            byArray[0] = (byte)c2;
            return 1;
        }
        if (c2 <= '\u07ff') {
            byArray[0] = (byte)(0xC0 | c2 >> 6 & 0x1F);
            byArray[1] = (byte)(0x80 | c2 & 0x3F);
            return 2;
        }
        if (c2 >= '\ud800' && c2 <= '\udbff') {
            if (c3 < '\udc00' || c3 > '\udfff') {
                throw new IllegalArgumentException("Malformed Unicode Surrogate Pair (" + c2 + ',' + c3 + ')');
            }
            byte by = (byte)(c3 & 0x3F);
            c3 = (char)((c2 & 3) << 4 | c3 >> 6 & 0xF);
            byte by2 = (byte)(c2 >> 2 & 0xF);
            c2 = (char)((c2 >> 6 & 0xF) + 1);
            byArray[0] = (byte)(0xF0 | c2 >> 2 & 7);
            byArray[1] = (byte)(0x80 | (c2 & 3) << 4 | by2);
            byArray[2] = (byte)(0x80 | c3);
            byArray[3] = (byte)(0x80 | by);
            return 4;
        }
        if (c2 >= '\udc00' && c2 <= '\udfff') {
            return 0;
        }
        byArray[0] = (byte)(0xE0 | c2 >> 12 & 0xF);
        byArray[1] = (byte)(0x80 | c2 >> 6 & 0x3F);
        byArray[2] = (byte)(0x80 | c2 & 0x3F);
        return 3;
    }

    public static int decodeUTF8(byte[] byArray, int n2) {
        int n3 = 0;
        for (int i2 = 1; i2 < n2; ++i2) {
            if ((byArray[i2] & 0xC0) != 128) {
                throw new IllegalArgumentException("Byte " + (i2 + 1) + " in UTF-8 sequence has wrong top bits");
            }
            n3 = (n3 << 6) + (byArray[i2] & 0x3F);
        }
        if ((byArray[0] & 0x80) == 0) {
            if (n2 == 1) {
                return byArray[0];
            }
            throw new IllegalArgumentException("UTF8 single byte expected");
        }
        if ((byArray[0] & 0xE0) == 192) {
            if (n2 != 2) {
                throw new IllegalArgumentException("UTF8 sequence of two bytes expected");
            }
            return ((byArray[0] & 0x1F) << 6) + n3;
        }
        if ((byArray[0] & 0xF0) == 224) {
            if (n2 != 3) {
                throw new IllegalArgumentException("UTF8 sequence of three bytes expected");
            }
            return ((byArray[0] & 0xF) << 12) + n3;
        }
        if ((byArray[0] & 0xF8) == 248) {
            if (n2 != 4) {
                throw new IllegalArgumentException("UTF8 sequence of four bytes expected");
            }
            return ((byArray[0] & 7) << 24) + n3;
        }
        throw new IllegalArgumentException("UTF8 invalid first byte");
    }
}

