/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameParser;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLPackage;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.packages.PackageDetails;
import net.sf.saxon.trans.packages.PackageLibrary;
import net.sf.saxon.trans.packages.UsePack;
import net.sf.saxon.trans.packages.VersionedPackageName;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NestedIntegerValue;

public class Compilation {
    public static final boolean TIMING = false;
    private Configuration a;
    private CompilerInfo b;
    private PrincipalStylesheetModule c;
    private int d = 0;
    private boolean e;
    private QNameParser f;
    private Map<StructuredQName, a> g = new HashMap<StructuredQName, a>();
    private Map<DocumentURI, TreeInfo> h = new HashMap<DocumentURI, TreeInfo>();
    private Stack<DocumentURI> i = new Stack();
    private PackageData j;
    private boolean k = true;
    private boolean l = false;
    private boolean m = false;
    private VersionedPackageName n = null;
    private List<UsePack> o = new ArrayList<UsePack>();
    private List<VersionedPackageName> p = new ArrayList<VersionedPackageName>();
    private GlobalParameterSet q;
    private boolean r = false;

    public Compilation(Configuration configuration, CompilerInfo compilerInfo) {
        this.a = configuration;
        this.b = compilerInfo;
        this.e = compilerInfo.isSchemaAware();
        this.k = compilerInfo.isJustInTimeCompilation();
        this.q = this.b.getParameters();
        this.f = new QNameParser(null);
        this.f.setAcceptEQName(true);
        this.f.setDefaultNamespace("");
        this.f.setErrorOnBadSyntax("XTSE0020");
        this.f.setErrorOnUnresolvedPrefix("XTSE0280");
    }

    public static PreparedStylesheet compileSingletonPackage(Configuration object, CompilerInfo compilerInfo, Source source) {
        try {
            object = new Compilation((Configuration)object, compilerInfo);
            return StylesheetModule.loadStylesheet(source, (Compilation)object);
        }
        catch (XPathException xPathException) {
            object = xPathException;
            if (!xPathException.hasBeenReported()) {
                try {
                    compilerInfo.getErrorListener().fatalError((TransformerException)object);
                }
                catch (TransformerException transformerException) {}
            }
            throw object;
        }
    }

    public void setUsingPackages(List<VersionedPackageName> list) {
        this.p = list;
    }

    public void setPackageData(PackageData packageData) {
        this.j = packageData;
    }

    public void setMinimalPackageData() {
        if (this.getPackageData() == null) {
            PackageData packageData = new PackageData(this.getConfiguration());
            packageData.setHostLanguage(50);
            packageData.setTargetEdition(this.b.getTargetEdition());
            packageData.setSchemaAware(this.e);
            this.j = packageData;
        }
    }

    public void setExpectedNameAndVersion(VersionedPackageName versionedPackageName) {
        this.n = versionedPackageName;
    }

    public void registerPackageDependency(UsePack usePack) {
        this.o.add(usePack);
    }

    public void satisfyPackageDependencies(XSLPackage xSLPackage) {
        Object object = this.b.getPackageLibrary();
        ((PackageLibrary)object).getCompilerInfo().setTargetEdition(this.b.getTargetEdition());
        Object object2 = null;
        for (Object object3 : this.o) {
            PackageDetails packageDetails = ((PackageLibrary)object).findPackage(((UsePack)object3).packageName, ((UsePack)object3).ranges);
            if (packageDetails == null) {
                throw new XPathException("Cannot find package " + ((UsePack)object3).packageName + " (version " + ((UsePack)object3).ranges + ")", "XTSE3000", ((UsePack)object3).location);
            }
            if (packageDetails.loadedPackage != null) {
                object3 = packageDetails.loadedPackage;
                if (this.p.contains(object3 = new VersionedPackageName(((StylesheetPackage)object3).getPackageName(), ((StylesheetPackage)object3).getPackageVersion()))) {
                    object = new FastStringBuffer(1024);
                    for (VersionedPackageName versionedPackageName : this.p) {
                        ((FastStringBuffer)object).append(versionedPackageName.packageName);
                        ((FastStringBuffer)object).append(", ");
                    }
                    ((FastStringBuffer)object).append("and ");
                    ((FastStringBuffer)object).append(xSLPackage.getName());
                    throw new XPathException("There is a cycle of package dependencies involving " + object, "XTSE3005");
                }
            }
            try {
                object3 = new ArrayList<VersionedPackageName>(this.p);
                object3.add((VersionedPackageName)packageDetails.nameAndVersion);
                ((PackageLibrary)object).obtainLoadedPackage(packageDetails, (List<VersionedPackageName>)object3);
            }
            catch (XPathException xPathException) {
                object3 = xPathException;
                if (!xPathException.hasBeenReported()) {
                    this.reportError((XPathException)object3);
                }
                object2 = object3;
            }
        }
        if (object2 != null) {
            throw object2;
        }
    }

    public PrincipalStylesheetModule compilePackage(Source object) {
        NodeInfo nodeInfo;
        this.setMinimalPackageData();
        Object object2 = null;
        if (object instanceof NodeInfo) {
            nodeInfo = (NodeInfo)object;
            if (nodeInfo.getNodeKind() == 9) {
                object2 = nodeInfo;
                object2 = object2.iterateAxis((byte)3, NodeKindTest.ELEMENT).next();
            } else if (nodeInfo.getNodeKind() == 1) {
                nodeInfo.getRoot();
                object2 = nodeInfo;
            }
        }
        if (!(object2 instanceof XSLPackage)) {
            object2 = StylesheetModule.loadStylesheetModule((Source)object, true, this, NestedIntegerValue.TWO);
            object2 = object2.iterateAxis((byte)3, NodeKindTest.ELEMENT).next();
        }
        if (object2 instanceof LiteralResultElement) {
            object2 = ((LiteralResultElement)object2).makeStylesheet(true);
            object2 = object2.iterateAxis((byte)3, NodeKindTest.ELEMENT).next();
        }
        try {
            if (!(object2 instanceof XSLPackage)) {
                throw new XPathException("Outermost element must be xsl:package, xsl:stylesheet, or xsl:transform");
            }
            nodeInfo = (XSLPackage)object2;
        }
        catch (XPathException xPathException) {
            object = xPathException;
            if (!xPathException.hasBeenReported()) {
                try {
                    this.getCompilerInfo().getErrorListener().fatalError((TransformerException)object);
                }
                catch (TransformerException transformerException) {}
            }
            throw object;
        }
        object = this.getCompilerInfo();
        object2 = this.getStyleNodeFactory(true);
        object2 = ((StyleNodeFactory)object2).newPrincipalModule((XSLPackage)nodeInfo);
        Object object3 = ((PrincipalStylesheetModule)object2).getStylesheetPackage();
        ((StylesheetPackage)object3).setVersion(((XSLPackage)nodeInfo).getVersion());
        ((StylesheetPackage)object3).setPackageVersion(((XSLPackage)nodeInfo).getPackageVersion());
        ((StylesheetPackage)object3).setPackageName(((XSLPackage)nodeInfo).getName());
        ((PackageData)object3).setSchemaAware(((CompilerInfo)object).isSchemaAware() || this.isSchemaAware());
        ((StylesheetPackage)object3).createFunctionLibrary();
        if (((CompilerInfo)object).getExtensionFunctionLibrary() != null) {
            ((StylesheetPackage)object3).getFunctionLibrary().addFunctionLibrary(((CompilerInfo)object).getExtensionFunctionLibrary());
        }
        ((PrincipalStylesheetModule)object2).getRuleManager().setRecoveryPolicy(((CompilerInfo)object).getRecoveryPolicy());
        ((PrincipalStylesheetModule)object2).getRuleManager().setCompilerInfo((CompilerInfo)object);
        Object object4 = object2;
        object3 = this;
        this.c = object4;
        this.j = null;
        this.satisfyPackageDependencies((XSLPackage)nodeInfo);
        try {
            ((PrincipalStylesheetModule)object2).preprocess();
        }
        catch (XPathException xPathException) {
            try {
                ((CompilerInfo)object).getErrorListener().fatalError(xPathException);
            }
            catch (TransformerException transformerException) {}
            throw xPathException;
        }
        if (this.getErrorCount() == 0) {
            try {
                ((PrincipalStylesheetModule)object2).fixup();
            }
            catch (XPathException xPathException) {
                this.reportError(xPathException);
            }
        }
        if (this.getErrorCount() == 0) {
            try {
                ((PrincipalStylesheetModule)object2).combineAttributeSets(this);
            }
            catch (XPathException xPathException) {
                this.reportError(xPathException);
            }
        }
        if (this.getErrorCount() == 0) {
            try {
                ((PrincipalStylesheetModule)object2).compile(this);
            }
            catch (XPathException xPathException) {
                this.reportError(xPathException);
            }
        }
        if (this.getErrorCount() == 0) {
            try {
                ((PrincipalStylesheetModule)object2).complete();
            }
            catch (XPathException xPathException) {
                this.reportError(xPathException);
            }
        }
        ((PrincipalStylesheetModule)object2).getStylesheetPackage().setCreatesSecondaryResultDocuments(this.l);
        if (this.isFallbackToNonStreaming()) {
            ((PrincipalStylesheetModule)object2).getStylesheetPackage().setFallbackToNonStreaming();
        }
        return object2;
    }

    public Configuration getConfiguration() {
        return this.a;
    }

    public CompilerInfo getCompilerInfo() {
        return this.b;
    }

    public PackageData getPackageData() {
        if (this.j != null) {
            return this.j;
        }
        if (this.c == null) {
            return null;
        }
        return this.c.getStylesheetPackage();
    }

    public boolean isSchemaAware() {
        return this.e;
    }

    public void setSchemaAware(boolean bl2) {
        this.e = bl2;
        this.getPackageData().setSchemaAware(bl2);
    }

    public StyleNodeFactory getStyleNodeFactory(boolean bl2) {
        StyleNodeFactory styleNodeFactory = this.getConfiguration().makeStyleNodeFactory(this);
        styleNodeFactory.setTopLevelModule(bl2);
        return styleNodeFactory;
    }

    public PrincipalStylesheetModule getPrincipalStylesheetModule() {
        return this.c;
    }

    public void reportError(XPathException xPathException) {
        ErrorListener errorListener = this.b.getErrorListener();
        if (errorListener == null) {
            errorListener = this.getConfiguration().getErrorListener();
        }
        if (!xPathException.hasBeenReported()) {
            ++this.d;
            try {
                errorListener.fatalError(xPathException);
                xPathException.setHasBeenReported(true);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        if (this.d == 0) {
            ++this.d;
        }
    }

    public int getErrorCount() {
        return this.d;
    }

    public void reportWarning(XPathException xPathException) {
        ErrorListener errorListener = this.b.getErrorListener();
        if (errorListener == null) {
            errorListener = this.getConfiguration().getErrorListener();
        }
        if (errorListener != null) {
            try {
                errorListener.warning(xPathException);
                return;
            }
            catch (Exception exception) {}
        }
    }

    public void declareStaticVariable(StructuredQName structuredQName, GroundedValue groundedValue, NestedIntegerValue nestedIntegerValue, boolean bl2) {
        a a2 = this.g.get(structuredQName);
        if (a2 != null) {
            if (a2.b.compareTo(nestedIntegerValue) < 0) {
                if (!this.a(groundedValue, a2.a)) {
                    throw new XPathException("Incompatible values assigned for static variable " + structuredQName.getDisplayName(), "XTSE3450");
                }
                if (a2.c != bl2) {
                    throw new XPathException("Static variable " + structuredQName.getDisplayName() + " cannot be redeclared as a param", "XTSE3450");
                }
            } else {
                return;
            }
        }
        this.g.put(structuredQName, new a(groundedValue, nestedIntegerValue, bl2));
    }

    private boolean a(GroundedValue groundedValue, GroundedValue groundedValue2) {
        if (groundedValue.getLength() != groundedValue2.getLength()) {
            return false;
        }
        if (groundedValue.getLength() == 1) {
            Object t2 = groundedValue.head();
            groundedValue = groundedValue2.head();
            if (t2 instanceof AtomicValue) {
                return groundedValue instanceof AtomicValue && ((AtomicValue)t2).isIdentical((AtomicValue)groundedValue);
            }
            if (t2 instanceof NodeInfo) {
                return groundedValue instanceof NodeInfo && t2.equals(groundedValue);
            }
            return t2 == groundedValue;
        }
        for (int i2 = 0; i2 < groundedValue.getLength(); ++i2) {
            if (this.a((GroundedValue)groundedValue.itemAt(i2), (GroundedValue)groundedValue2.itemAt(i2))) continue;
            return false;
        }
        return true;
    }

    public GroundedValue<?> getStaticVariable(StructuredQName object) {
        if ((object = this.g.get(object)) == null) {
            return null;
        }
        return ((a)object).a;
    }

    public NestedIntegerValue getStaticVariablePrecedence(StructuredQName object) {
        if ((object = this.g.get(object)) == null) {
            return null;
        }
        return ((a)object).b;
    }

    public Map<DocumentURI, TreeInfo> getStylesheetModules() {
        return this.h;
    }

    public Stack<DocumentURI> getImportStack() {
        return this.i;
    }

    public QNameParser getQNameParser() {
        return this.f;
    }

    public boolean isPreScan() {
        return this.k;
    }

    public void setPreScan(boolean bl2) {
        this.k = bl2;
    }

    public boolean isCreatesSecondaryResultDocuments() {
        return this.l;
    }

    public void setCreatesSecondaryResultDocuments(boolean bl2) {
        this.l = bl2;
    }

    public boolean isLibraryPackage() {
        return this.m;
    }

    public void setLibraryPackage(boolean bl2) {
        this.m = bl2;
    }

    public void setParameter(StructuredQName structuredQName, GroundedValue<?> groundedValue) {
        this.q.put(structuredQName, groundedValue);
    }

    public GlobalParameterSet getParameters() {
        return this.q;
    }

    public void clearParameters() {
        this.q = new GlobalParameterSet();
    }

    public boolean isFallbackToNonStreaming() {
        return this.r;
    }

    public void setFallbackToNonStreaming(boolean bl2) {
        this.r = bl2;
    }

    private static final class a {
        public GroundedValue a;
        public NestedIntegerValue b;
        public boolean c;

        public a(GroundedValue groundedValue, NestedIntegerValue nestedIntegerValue, boolean bl2) {
            this.a = groundedValue;
            this.b = nestedIntegerValue;
            this.c = bl2;
        }
    }
}

