/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GlobalVariableReference;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.OptimizerOptions;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.registry.VendorFunctionSetHE;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLGlobalVariable;
import net.sf.saxon.style.XSLOverride;
import net.sf.saxon.style.XSLTStaticContext;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.AttributeLocation;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;

public class ExpressionContext
implements XSLTStaticContext {
    private StyleElement a;
    private StructuredQName b;
    private Location c = null;
    private SavedNamespaceContext d = null;
    private RetainedStaticContext e = null;

    public ExpressionContext(StyleElement styleElement, StructuredQName structuredQName) {
        this.a = styleElement;
        this.b = structuredQName;
    }

    @Override
    public Configuration getConfiguration() {
        return ((NodeImpl)this.a).getConfiguration();
    }

    @Override
    public StylesheetPackage getPackageData() {
        return this.a.getPackageData();
    }

    public boolean isSchemaAware() {
        return this.a.isSchemaAware();
    }

    @Override
    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration());
    }

    @Override
    public RetainedStaticContext makeRetainedStaticContext() {
        if (this.e == null) {
            this.e = this.a.changesRetainedStaticContext() || !(this.a.getParent() instanceof StyleElement) ? new RetainedStaticContext(this) : ((StyleElement)this.a.getParent()).getStaticContext().makeRetainedStaticContext();
        }
        return this.e;
    }

    @Override
    public Location getContainingLocation() {
        if (this.c == null) {
            this.c = this.b == null ? this.a : new AttributeLocation(this.a, this.b);
        }
        return this.c;
    }

    @Override
    public void issueWarning(String string, Location location) {
        this.a.issueWarning(new XPathException(string, "SXWN9000", location));
    }

    @Override
    public String getSystemId() {
        return ((NodeImpl)this.a).getSystemId();
    }

    @Override
    public String getStaticBaseURI() {
        return ((NodeImpl)this.a).getBaseURI();
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        if (this.d == null) {
            this.d = this.a.makeNamespaceContext();
        }
        return this.d;
    }

    @Override
    public ItemType getRequiredContextItemType() {
        return AnyItemType.getInstance();
    }

    @Override
    public DecimalFormatManager getDecimalFormatManager() {
        return this.a.getCompilation().getPrincipalStylesheetModule().getDecimalFormatManager();
    }

    @Override
    public OptimizerOptions getOptimizerOptions() {
        return this.a.getCompilation().getCompilerInfo().getOptimizerOptions();
    }

    @Override
    public Expression bindVariable(StructuredQName structuredQName) {
        Object object = this.a.bindVariable(structuredQName);
        if (object == null) {
            if (structuredQName.hasURI("http://www.w3.org/1999/XSL/Transform") && structuredQName.getLocalPart().equals("original")) {
                this.a.getXslOriginal(206);
                return new GlobalVariableReference(structuredQName);
            }
            Object object2 = new SymbolicName(206, structuredQName);
            Component component = this.a.getCompilation().getPrincipalStylesheetModule().getComponent((SymbolicName)object2);
            if (component != null) {
                this.a.iterateAxis((byte)1).forEachOrFail(nodeInfo -> {
                    if (nodeInfo instanceof XSLGlobalVariable && ((XSLGlobalVariable)nodeInfo).getVariableQName().equals(structuredQName)) {
                        structuredQName = new XPathException("Variable " + ((StructuredQName)structuredQName).getDisplayName() + " cannot be used within its own declaration", "XPST0008");
                        ((XPathException)((Object)structuredQName)).setIsStaticError(true);
                        throw structuredQName;
                    }
                });
                object = (GlobalVariable)component.getActor();
                object2 = new GlobalVariableReference((GlobalVariable)object);
                ((VariableReference)object2).setStaticType(object.getRequiredType(), null, 0);
                return object2;
            }
            if (this.getXPathVersion() >= 30 && structuredQName.hasURI("http://www.w3.org/2005/xqt-errors") && (object2 = (StyleElement)(object = this.a.iterateAxis((byte)1, new NameTest(1, 139, this.a.getNamePool()))).next()) != null) {
                object = StandardNames.errorVariables;
                int n2 = StandardNames.errorVariables.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    StructuredQName structuredQName2 = object[i2];
                    if (!structuredQName2.getLocalPart().equals(structuredQName.getLocalPart())) continue;
                    object = VendorFunctionSetHE.getInstance().makeFunction("dynamic-error-info", 1);
                    return object.makeFunctionCall(new StringLiteral(structuredQName.getLocalPart()));
                }
            }
            object = new XPathException("Variable " + structuredQName.getDisplayName() + " has not been declared (or its declaration is not in scope)", "XPST0008");
            object.setIsStaticError(true);
            throw object;
        }
        if (object.hasProperty(8192)) {
            SuppliedParameterReference suppliedParameterReference = new SuppliedParameterReference(0);
            suppliedParameterReference.setSuppliedType(object.getDeclaredType());
            return suppliedParameterReference;
        }
        if (object.hasProperty(2)) {
            GlobalVariableReference globalVariableReference = new GlobalVariableReference(structuredQName);
            GlobalVariable globalVariable = ((XSLGlobalVariable)object.getSourceElement()).getCompiledVariable();
            if (globalVariable != null && this.a.getCompilation().getCompilerInfo().isJustInTimeCompilation()) {
                globalVariableReference.fixup(globalVariable);
                globalVariableReference.setStaticType(globalVariable.getRequiredType(), object.getConstantValue(), 0);
            } else {
                object.registerReference(globalVariableReference);
            }
            return globalVariableReference;
        }
        LocalVariableReference localVariableReference = new LocalVariableReference(structuredQName);
        object.registerReference(localVariableReference);
        return localVariableReference;
    }

    @Override
    public FunctionLibrary getFunctionLibrary() {
        FunctionLibraryList functionLibraryList = this.a.getContainingPackage().getFunctionLibrary();
        StyleElement styleElement = this.a.findAncestorElement(186);
        if (styleElement != null) {
            FunctionLibraryList functionLibraryList2 = new FunctionLibraryList();
            functionLibraryList2.addFunctionLibrary(functionLibraryList);
            ((XSLOverride)styleElement).addXSLOverrideFunctionLibrary(functionLibraryList2);
            return functionLibraryList2;
        }
        return functionLibraryList;
    }

    @Override
    public boolean isElementAvailable(String stringArray) {
        try {
            stringArray = NameChecker.getQNameParts((CharSequence)stringArray);
            String string = stringArray[0].isEmpty() ? this.getDefaultElementNamespace() : this.a.getURIForPrefix(stringArray[0], false);
            return this.a.getCompilation().getStyleNodeFactory(true).isElementAvailable(string, stringArray[1], true);
        }
        catch (QNameException qNameException) {
            XPathException xPathException = new XPathException("Invalid element name. " + qNameException.getMessage());
            xPathException.setErrorCode("XTDE1440");
            throw xPathException;
        }
    }

    @Override
    public String getDefaultCollationName() {
        return this.a.getDefaultCollationName();
    }

    @Override
    public String getDefaultElementNamespace() {
        return this.a.getDefaultXPathNamespace();
    }

    @Override
    public String getDefaultFunctionNamespace() {
        return "http://www.w3.org/2005/xpath-functions";
    }

    @Override
    public boolean isInBackwardsCompatibleMode() {
        return this.a.xPath10ModeIsEnabled();
    }

    @Override
    public int getXPathVersion() {
        return this.getConfiguration().getConfigurationProperty(Feature.XPATH_VERSION_FOR_XSLT);
    }

    @Override
    public boolean isImportedSchema(String string) {
        return this.a.getPrincipalStylesheetModule().isImportedSchema(string);
    }

    @Override
    public Set<String> getImportedSchemaNamespaces() {
        return this.a.getPrincipalStylesheetModule().getImportedSchemaTable();
    }

    @Override
    public KeyManager getKeyManager() {
        return this.a.getCompilation().getPrincipalStylesheetModule().getKeyManager();
    }

    public StyleElement getStyleElement() {
        return this.a;
    }

    @Override
    public ItemType resolveTypeAlias(StructuredQName structuredQName) {
        return this.getPackageData().obtainTypeAliasManager().getItemType(structuredQName);
    }
}

