/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.trans.XPathException;

public class PackageVersion
implements Comparable<PackageVersion> {
    public List<Integer> parts;
    public String suffix;
    public static PackageVersion ZERO = new PackageVersion(new int[]{0});
    public static PackageVersion ONE = new PackageVersion(new int[]{1});
    public static PackageVersion MAX_VALUE = new PackageVersion(new int[]{Integer.MAX_VALUE});

    public PackageVersion(int[] nArray) {
        this.parts = new ArrayList<Integer>(nArray.length);
        for (int n2 : nArray) {
            this.parts.add(n2);
        }
        this.a();
    }

    private void a() {
        for (int i2 = this.parts.size() - 1; i2 > 0; --i2) {
            if (this.parts.get(i2) != 0) {
                return;
            }
            this.parts.remove(i2);
        }
    }

    public PackageVersion(String string) {
        this.parts = new ArrayList<Integer>();
        String string2 = string;
        if (string.contains("-")) {
            int n2 = string.indexOf(45);
            this.suffix = string.substring(n2 + 1);
            if (!NameChecker.isValidNCName(this.suffix)) {
                throw new XPathException("Illegal NCName as package-version NamePart: " + string2, "XTSE0020");
            }
            string = string.substring(0, n2);
        }
        if (string.equals("")) {
            throw new XPathException("No numeric component of package-version: " + string2, "XTSE0020");
        }
        if (string.startsWith(".")) {
            throw new XPathException("The package-version cannot start with '.'", "XTSE0020");
        }
        if (string.endsWith(".")) {
            throw new XPathException("The package-version cannot end with '.'", "XTSE0020");
        }
        for (String string3 : string.trim().split("\\.")) {
            try {
                this.parts.add(Integer.valueOf(string3));
            }
            catch (NumberFormatException numberFormatException) {
                throw new XPathException("Error in package-version: " + numberFormatException.getMessage(), "XTSE0020");
            }
        }
        this.a();
    }

    public boolean equals(Object object) {
        if (object instanceof PackageVersion) {
            object = (PackageVersion)object;
            if (this.parts.equals(((PackageVersion)object).parts)) {
                if (this.suffix != null) {
                    return this.suffix.equals(((PackageVersion)object).suffix);
                }
                return ((PackageVersion)object).suffix == null;
            }
        }
        return false;
    }

    public boolean equalsIgnoringSuffix(PackageVersion packageVersion) {
        return this.parts.equals(packageVersion.parts);
    }

    @Override
    public int compareTo(PackageVersion packageVersion) {
        List<Integer> list = packageVersion.parts;
        int n2 = this.parts.size() - list.size();
        int n3 = Math.min(this.parts.size(), list.size());
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = this.parts.get(i2).compareTo(list.get(i2));
            if (n4 == 0) continue;
            return n4;
        }
        if (n2 == 0) {
            if (this.suffix != null) {
                if (packageVersion.suffix == null) {
                    return -1;
                }
                return this.suffix.compareTo(packageVersion.suffix);
            }
            if (packageVersion.suffix != null) {
                return 1;
            }
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer n2 : this.parts) {
            stringBuilder.append(".").append(n2);
        }
        if (!this.parts.isEmpty()) {
            stringBuilder = new StringBuilder(stringBuilder.substring(1));
        }
        if (this.suffix != null) {
            stringBuilder.append("-").append(this.suffix);
        }
        return stringBuilder.toString();
    }

    public boolean isPrefix(PackageVersion packageVersion) {
        if (packageVersion.parts.size() >= this.parts.size()) {
            for (int i2 = 0; i2 < this.parts.size(); ++i2) {
                if (this.parts.get(i2).equals(packageVersion.parts.get(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

