/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.om.Action;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLAccept;
import net.sf.saxon.style.XSLApplyTemplates;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLExpose;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLGlobalParam;
import net.sf.saxon.style.XSLGlobalVariable;
import net.sf.saxon.style.XSLImportSchema;
import net.sf.saxon.style.XSLInclude;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.style.XSLMode;
import net.sf.saxon.style.XSLModuleRoot;
import net.sf.saxon.style.XSLNamespaceAlias;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.style.XSLOverride;
import net.sf.saxon.style.XSLPackage;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLUsePackage;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.ComponentTest;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.GlobalVariableManager;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.TypeAliasManager;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.VisibilityProvenance;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.RuleManager;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntHashMap;

public class PrincipalStylesheetModule
extends StylesheetModule
implements GlobalVariableManager {
    private StylesheetPackage a;
    private boolean b;
    private HashMap<StructuredQName, ComponentDeclaration> c = new HashMap(20);
    private HashMap<StructuredQName, ComponentDeclaration> d = new HashMap(20);
    private HashMap<SymbolicName, ComponentDeclaration> e = new HashMap(8);
    private KeyManager f;
    private DecimalFormatManager g;
    private RuleManager h;
    private AccumulatorRegistry i = null;
    private int j = 0;
    private List<ComponentDeclaration> k = new ArrayList<ComponentDeclaration>(5);
    private HashMap<String, NamespaceBinding> l;
    private Set<String> m;
    private Map<StructuredQName, List<ComponentDeclaration>> n = new HashMap<StructuredQName, List<ComponentDeclaration>>();
    private HashMap<DocumentURI, XSLModuleRoot> o = new HashMap(4);
    private TypeAliasManager p;
    private CharacterMapIndex q;
    private List<Action> r = new ArrayList<Action>();
    private boolean s = false;

    public PrincipalStylesheetModule(XSLPackage xSLPackage) {
        super(xSLPackage, 0);
        this.b = ((XSLModuleRoot)xSLPackage).isDeclaredModes();
        this.a = this.getConfiguration().makeStylesheetPackage();
        Object object = xSLPackage.getCompilation().getCompilerInfo();
        this.a.setTargetEdition(((CompilerInfo)object).getTargetEdition());
        this.a.setRelocatable(((CompilerInfo)object).isRelocatable());
        this.a.setJustInTimeCompilation(((CompilerInfo)object).isJustInTimeCompilation());
        this.a.setImplicitPackage(!xSLPackage.getLocalPart().equals("package"));
        this.f = this.a.getKeyManager();
        this.g = this.a.getDecimalFormatManager();
        this.h = new RuleManager(this.a, (CompilerInfo)object);
        this.h.getUnnamedMode().makeDeclaringComponent(Visibility.PRIVATE, this.a);
        this.a.setRuleManager(this.h);
        this.a.setDeclaredModes(this.b);
        object = xSLPackage.getDefaultMode();
        this.a.setDefaultMode(xSLPackage.getDefaultMode());
        if (object != null) {
            this.h.obtainMode((StructuredQName)object, !this.b);
        }
        this.q = new CharacterMapIndex();
        this.a.setCharacterMapIndex(this.q);
        this.p = this.getConfiguration().makeTypeAliasManager();
        this.a.setTypeAliasManager(this.p);
        try {
            this.setInputTypeAnnotations(xSLPackage.getInputTypeAnnotationsAttribute());
            return;
        }
        catch (XPathException xPathException) {
            return;
        }
    }

    public Component getComponent(SymbolicName symbolicName) {
        return this.a.getComponentIndex().get(symbolicName);
    }

    @Override
    public PrincipalStylesheetModule getPrincipalStylesheetModule() {
        return this;
    }

    public StylesheetPackage getStylesheetPackage() {
        return this.a;
    }

    public KeyManager getKeyManager() {
        return this.f;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        return this.g;
    }

    public RuleManager getRuleManager() {
        return this.h;
    }

    public boolean isDeclaredModes() {
        return this.b;
    }

    public void addFixupAction(Action action) {
        this.r.add(action);
    }

    public void setNeedsDynamicOutputProperties(boolean bl2) {
        this.s = bl2;
    }

    public CharacterMapIndex getCharacterMapIndex() {
        return this.q;
    }

    public TypeAliasManager getTypeAliasManager() {
        return this.p;
    }

    public void declareXQueryFunction(XQueryFunction xQueryFunction) {
        XQueryFunctionLibrary xQueryFunctionLibrary = this.getStylesheetPackage().getXQueryFunctionLibrary();
        if (this.getStylesheetPackage().getFunction(xQueryFunction.getUserFunction().getSymbolicName()) != null) {
            throw new XPathException("Duplication declaration of " + xQueryFunction.getUserFunction().getSymbolicName(), "XQST0034");
        }
        xQueryFunctionLibrary.declareFunction(xQueryFunction);
    }

    public void putStylesheetDocument(DocumentURI documentURI, XSLStylesheet xSLStylesheet) {
        this.o.put(documentURI, xSLStylesheet);
    }

    public XSLModuleRoot getStylesheetDocument(DocumentURI object) {
        XSLModuleRoot xSLModuleRoot = this.o.get(object);
        if (xSLModuleRoot != null) {
            object = new XPathException("Stylesheet module " + object + " is included or imported more than once. This is permitted, but may lead to errors or unexpected behavior");
            xSLModuleRoot.issueWarning((XPathException)object);
        }
        return xSLModuleRoot;
    }

    /*
     * WARNING - void declaration
     */
    public void preprocess() {
        Object object;
        void var2_12;
        PrincipalStylesheetModule principalStylesheetModule = this;
        principalStylesheetModule.spliceUsePackages((XSLPackage)principalStylesheetModule.getRootElement(), this.getRootElement().getCompilation());
        this.importSchemata();
        this.getTypeAliasManager().processAllDeclarations(this.topLevel);
        PrincipalStylesheetModule object22 = this;
        int n2 = object22.topLevel.size() - 1;
        while (var2_12 >= 0) {
            ComponentDeclaration componentDeclaration = object22.topLevel.get((int)var2_12);
            componentDeclaration.getSourceElement().index(componentDeclaration, object22);
            --var2_12;
        }
        PrincipalStylesheetModule principalStylesheetModule2 = this;
        Compilation compilation = principalStylesheetModule2.getRootElement().getCompilation();
        if (!compilation.isSchemaAware() && principalStylesheetModule2.getConfiguration().isLicensedFeature(2)) {
            for (ComponentDeclaration componentDeclaration : principalStylesheetModule2.topLevel) {
                object = componentDeclaration.getSourceElement();
                if (!(object instanceof XSLImportSchema)) continue;
                compilation.setSchemaAware(true);
                break;
            }
        }
        this.processAllAttributes();
        PrincipalStylesheetModule principalStylesheetModule3 = this;
        this.l = new HashMap(principalStylesheetModule3.j);
        principalStylesheetModule3.m = new HashSet<String>(principalStylesheetModule3.j);
        HashSet<String> hashSet = new HashSet<String>();
        int n3 = -1;
        for (int i2 = 0; i2 < principalStylesheetModule3.j; ++i2) {
            int n4;
            object = principalStylesheetModule3.k.get(i2);
            XSLNamespaceAlias xSLNamespaceAlias = (XSLNamespaceAlias)((ComponentDeclaration)object).getSourceElement();
            String string = xSLNamespaceAlias.getStylesheetURI();
            NamespaceBinding namespaceBinding = xSLNamespaceAlias.getResultNamespaceBinding();
            int n5 = ((ComponentDeclaration)object).getPrecedence();
            if (n4 != n5) {
                n4 = n5;
                hashSet.clear();
            }
            if (hashSet.contains(string) && !principalStylesheetModule3.l.get(string).getURI().equals(namespaceBinding.getURI())) {
                xSLNamespaceAlias.compileError("More than one alias is defined for the same namespace", "XTSE0810");
            }
            if (principalStylesheetModule3.l.get(string) == null) {
                principalStylesheetModule3.l.put(string, namespaceBinding);
                principalStylesheetModule3.m.add(namespaceBinding.getURI());
            }
            hashSet.add(string);
        }
        principalStylesheetModule3.k = null;
        for (ComponentDeclaration componentDeclaration : this.topLevel) {
            StyleElement styleElement = componentDeclaration.getSourceElement();
            if (styleElement.isActionCompleted(16)) continue;
            styleElement.setActionCompleted(16);
            styleElement.fixupReferences();
        }
        XSLPackage xSLPackage = (XSLPackage)this.getStylesheetElement();
        new ComponentDeclaration(this, xSLPackage);
        if (!xSLPackage.isActionCompleted(1)) {
            xSLPackage.setActionCompleted(1);
            ((StyleElement)xSLPackage).validate(null);
            for (ComponentDeclaration componentDeclaration : this.topLevel) {
                componentDeclaration.getSourceElement().validateSubtree(componentDeclaration, false);
            }
        }
        Properties properties = this.gatherOutputProperties(null);
        properties.setProperty("{http://saxon.sf.net/}stylesheet-version", "" + this.getStylesheetPackage().getVersion());
        this.getStylesheetPackage().setDefaultOutputProperties(properties);
        HashSet<StructuredQName> hashSet2 = new HashSet<StructuredQName>(5);
        for (ComponentDeclaration componentDeclaration : this.topLevel) {
            XSLOutput xSLOutput;
            StructuredQName structuredQName;
            if (!(componentDeclaration.getSourceElement() instanceof XSLOutput) || (structuredQName = (xSLOutput = (XSLOutput)componentDeclaration.getSourceElement()).getFormatQName()) == null) continue;
            hashSet2.add(structuredQName);
        }
        if (hashSet2.isEmpty()) {
            if (this.s) {
                throw new XPathException("The stylesheet contains xsl:result-document instructions that calculate the output format name at run-time, but there are no named xsl:output declarations", "XTDE1460");
            }
        } else {
            for (StructuredQName structuredQName : hashSet2) {
                Properties properties2 = this.gatherOutputProperties(structuredQName);
                this.getStylesheetPackage().setNamedOutputProperties(structuredQName, properties2);
            }
        }
        for (ComponentDeclaration componentDeclaration : this.topLevel) {
            Object object2 = componentDeclaration.getSourceElement();
            if (!(object2 instanceof XSLCharacterMap)) continue;
            XSLCharacterMap xSLCharacterMap = (XSLCharacterMap)object2;
            StructuredQName structuredQName = xSLCharacterMap.getCharacterMapName();
            object2 = new IntHashMap();
            xSLCharacterMap.assemble((IntHashMap<String>)object2);
            this.q.putCharacterMap(xSLCharacterMap.getCharacterMapName(), new CharacterMap(structuredQName, (IntHashMap<String>)object2));
        }
    }

    protected void spliceUsePackages(XSLPackage iterable, Compilation object2) {
        Iterable<NodeInfo> iterable2;
        ArrayList<XSLUsePackage> arrayList = new ArrayList<XSLUsePackage>();
        PrincipalStylesheetModule.a((Compilation)object2, iterable, arrayList);
        iterable = new HashSet();
        for (XSLUsePackage xSLUsePackage : arrayList) {
            Iterable<NodeInfo> iterable3 = iterable;
            Object object = object2;
            iterable2 = xSLUsePackage;
            PrincipalStylesheetModule principalStylesheetModule = this;
            ((XSLUsePackage)iterable2).findUsedPackage(((Compilation)object).getCompilerInfo());
            PrincipalStylesheetModule principalStylesheetModule2 = principalStylesheetModule;
            ((XSLUsePackage)iterable2).gatherNamedOverrides(principalStylesheetModule2, principalStylesheetModule2.topLevel, (Set<SymbolicName>)iterable3);
        }
        StylesheetPackage stylesheetPackage = this.getStylesheetPackage();
        for (XSLUsePackage xSLUsePackage : arrayList) {
            iterable2 = xSLUsePackage.getAcceptors();
            stylesheetPackage.addComponentsFromUsedPackage(((StyleElement)xSLUsePackage).getUsedPackage(), (List<XSLAccept>)iterable2, (Set<SymbolicName>)iterable);
        }
        for (XSLUsePackage xSLUsePackage : arrayList) {
            xSLUsePackage.gatherRuleOverrides(this, (Set<SymbolicName>)iterable);
        }
        this.spliceIncludes();
    }

    private static void a(Compilation compilation, StyleElement styleElement, List<XSLUsePackage> list) {
        styleElement.iterateAxis((byte)3).forEachOrFail(object -> {
            if (object instanceof XSLUsePackage) {
                list.add((XSLUsePackage)object);
                return;
            }
            if (object instanceof XSLInclude) {
                String string = Whitespace.trim(object.getAttributeValue("", "href"));
                URIResolver uRIResolver = compilation.getCompilerInfo().getURIResolver();
                object = DocumentFn.computeDocumentKey(string, object.getBaseURI(), compilation.getPackageData(), uRIResolver, false);
                object = compilation.getStylesheetModules().get(object);
                object = (StyleElement)((DocumentImpl)object.getRootNode()).getDocumentElement();
                PrincipalStylesheetModule.a(compilation, (StyleElement)object, list);
            }
        });
    }

    protected void importSchemata() {
        for (int i2 = this.topLevel.size() - 1; i2 >= 0; --i2) {
            ComponentDeclaration componentDeclaration = this.topLevel.get(i2);
            if (!(componentDeclaration.getSourceElement() instanceof XSLImportSchema)) continue;
            XPathException xPathException = new XPathException("xsl:import-schema requires Saxon-EE");
            xPathException.setErrorCode("XTSE1650");
            xPathException.setLocator(componentDeclaration.getSourceElement());
            throw xPathException;
        }
    }

    public void processAllAttributes() {
        this.getRootElement().processDefaultCollationAttribute();
        this.getRootElement().processDefaultMode();
        this.getRootElement().prepareAttributes();
        for (XSLModuleRoot object : this.o.values()) {
            object.prepareAttributes();
        }
        for (ComponentDeclaration componentDeclaration : this.topLevel) {
            StyleElement styleElement = componentDeclaration.getSourceElement();
            if (styleElement.isActionCompleted(32)) continue;
            styleElement.setActionCompleted(32);
            try {
                styleElement.processAllAttributes();
            }
            catch (XPathException xPathException) {
                componentDeclaration.getSourceElement().compileError(xPathException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void indexFunction(ComponentDeclaration componentDeclaration) {
        HashMap<SymbolicName, Component> hashMap = this.a.getComponentIndex();
        XSLFunction xSLFunction = (XSLFunction)componentDeclaration.getSourceElement();
        Object object = xSLFunction.getCompiledFunction();
        object = ((Actor)object).obtainDeclaringComponent(xSLFunction);
        SymbolicName.F f2 = xSLFunction.getSymbolicName();
        if (f2 == null) return;
        Component component = hashMap.get(f2);
        if (component == null) {
            hashMap.put(f2, (Component)object);
            this.e.put(f2, componentDeclaration);
            return;
        }
        if (component.getDeclaringPackage() == this.getStylesheetPackage()) {
            ComponentDeclaration componentDeclaration2;
            int n2;
            int n3 = componentDeclaration.getPrecedence();
            if (n3 == (n2 = (componentDeclaration2 = this.e.get(f2)).getPrecedence())) {
                xSLFunction.compileError("Duplicate named function (see line " + ((NodeImpl)componentDeclaration2.getSourceElement()).getLineNumber() + " of " + ((NodeImpl)componentDeclaration2.getSourceElement()).getSystemId() + ')', "XTSE0770");
                return;
            }
            if (n3 < n2) return;
            hashMap.put(f2, (Component)object);
            this.e.put(f2, componentDeclaration);
            return;
        }
        if (xSLFunction.findAncestorElement(186) != null) {
            hashMap.put(f2, (Component)object);
            this.e.put(f2, componentDeclaration);
            return;
        }
        xSLFunction.compileError("Function " + ((SymbolicName)f2).getShortName() + " conflicts with a public function in package " + component.getDeclaringPackage().getPackageName(), "XTSE3050");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void indexVariableDeclaration(ComponentDeclaration object) {
        XSLGlobalVariable xSLGlobalVariable = (XSLGlobalVariable)((ComponentDeclaration)object).getSourceElement();
        StructuredQName structuredQName = xSLGlobalVariable.getSourceBinding().getVariableQName();
        Object object2 = (GlobalVariable)xSLGlobalVariable.getActor();
        object2 = ((Actor)object2).obtainDeclaringComponent(xSLGlobalVariable);
        HashMap<SymbolicName, Component> hashMap = this.a.getComponentIndex();
        if (structuredQName == null) return;
        Object object3 = xSLGlobalVariable.getSymbolicName();
        Component component = hashMap.get(object3);
        if (component == null) {
            this.c.put(structuredQName, (ComponentDeclaration)object);
            hashMap.put(new SymbolicName(206, structuredQName), xSLGlobalVariable.getActor().getDeclaringComponent());
            return;
        }
        if (component.getDeclaringPackage() == this.getStylesheetPackage()) {
            int n2;
            int n3 = ((ComponentDeclaration)object).getPrecedence();
            if (n3 == (n2 = ((ComponentDeclaration)(object3 = this.c.get(((SymbolicName)object3).getComponentName()))).getPrecedence())) {
                object = ((ComponentDeclaration)object3).getSourceElement();
                if (object == xSLGlobalVariable) {
                    xSLGlobalVariable.compileError("Global variable or parameter $" + structuredQName.getDisplayName() + " is declared more than once (caused by including the containing module more than once)", "XTSE0630");
                    return;
                }
                xSLGlobalVariable.compileError("Duplicate global variable/parameter declaration (see line " + ((NodeImpl)object).getLineNumber() + " of " + ((NodeImpl)object).getSystemId() + ')', "XTSE0630");
                return;
            }
            if (n3 < n2 && xSLGlobalVariable != ((ComponentDeclaration)object3).getSourceElement()) {
                xSLGlobalVariable.setRedundant(true);
                return;
            }
            if (xSLGlobalVariable == ((ComponentDeclaration)object3).getSourceElement()) return;
            ((XSLGlobalVariable)((ComponentDeclaration)object3).getSourceElement()).setRedundant(true);
            this.c.put(structuredQName, (ComponentDeclaration)object);
            hashMap.put(new SymbolicName(206, structuredQName), xSLGlobalVariable.getActor().getDeclaringComponent());
            return;
        }
        if (xSLGlobalVariable.findAncestorElement(186) != null) {
            hashMap.put((SymbolicName)object3, (Component)object2);
            this.c.put(((SymbolicName)object3).getComponentName(), (ComponentDeclaration)object);
            return;
        }
        object2 = xSLGlobalVariable instanceof XSLGlobalParam ? "parameter" : "variable";
        xSLGlobalVariable.compileError("Global " + (String)object2 + " $" + ((SymbolicName)object3).getComponentName().getDisplayName() + " conflicts with a public variable/parameter in package " + component.getDeclaringPackage().getPackageName(), "XTSE3050");
    }

    public SourceBinding getGlobalVariableBinding(StructuredQName object) {
        if ((object = this.c.get(object)) == null) {
            return null;
        }
        return ((XSLGlobalVariable)((ComponentDeclaration)object).getSourceElement()).getSourceBinding();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void indexNamedTemplate(ComponentDeclaration componentDeclaration) {
        HashMap<SymbolicName, Component> hashMap = this.a.getComponentIndex();
        XSLTemplate xSLTemplate = (XSLTemplate)componentDeclaration.getSourceElement();
        SymbolicName symbolicName = xSLTemplate.getSymbolicName();
        if (symbolicName == null) return;
        Object object = hashMap.get(symbolicName);
        if (object == null) {
            object = ((XSLTemplate)componentDeclaration.getSourceElement()).getCompiledNamedTemplate();
            Component component = ((Actor)object).obtainDeclaringComponent(xSLTemplate);
            hashMap.put(symbolicName, component);
            PrincipalStylesheetModule.a(xSLTemplate, (NamedTemplate)object);
            this.d.put(symbolicName.getComponentName(), componentDeclaration);
            return;
        }
        if (((Component)object).getDeclaringPackage() == this.getStylesheetPackage()) {
            Object object2;
            int n2;
            int n3 = componentDeclaration.getPrecedence();
            if (n3 != (n2 = ((ComponentDeclaration)(object2 = this.d.get(symbolicName.getComponentName()))).getPrecedence())) {
                if (n3 < n2) return;
                NamedTemplate namedTemplate = new NamedTemplate(symbolicName.getComponentName());
                object2 = namedTemplate.obtainDeclaringComponent(xSLTemplate);
                hashMap.put(symbolicName, (Component)object2);
                this.d.put(symbolicName.getComponentName(), componentDeclaration);
                PrincipalStylesheetModule.a(xSLTemplate, namedTemplate);
                return;
            }
            String string = xSLTemplate.getParent() instanceof XSLOverride ? "XTSE3055" : "XTSE0660";
            xSLTemplate.compileError("Duplicate named template (see line " + ((NodeImpl)((ComponentDeclaration)object2).getSourceElement()).getLineNumber() + " of " + ((NodeImpl)((ComponentDeclaration)object2).getSourceElement()).getSystemId() + ')', string);
            return;
        }
        if (xSLTemplate.findAncestorElement(186) != null) {
            object = xSLTemplate.getCompiledNamedTemplate();
            Component component = ((Actor)object).obtainDeclaringComponent(xSLTemplate);
            hashMap.put(symbolicName, component);
            this.d.put(symbolicName.getComponentName(), componentDeclaration);
            return;
        }
        xSLTemplate.compileError("Named template " + symbolicName.getComponentName().getDisplayName() + " conflicts with a public named template in package " + ((Component)object).getDeclaringPackage().getPackageName(), "XTSE3050");
    }

    private static void a(XSLTemplate object, NamedTemplate namedTemplate) {
        object = ((NodeImpl)object).iterateAxis((byte)3, NodeKindTest.ELEMENT);
        ArrayList<NamedTemplate.LocalParamInfo> arrayList = new ArrayList<NamedTemplate.LocalParamInfo>();
        object.forEachOrFail(nodeInfo -> {
            if (nodeInfo instanceof XSLLocalParam) {
                nodeInfo = (XSLLocalParam)nodeInfo;
                ((XSLLocalParam)nodeInfo).prepareTemplateSignatureAttributes();
                NamedTemplate.LocalParamInfo localParamInfo = new NamedTemplate.LocalParamInfo();
                new NamedTemplate.LocalParamInfo().name = ((XSLGeneralVariable)nodeInfo).getVariableQName();
                localParamInfo.requiredType = ((XSLLocalParam)nodeInfo).getRequiredType();
                localParamInfo.isRequired = ((XSLLocalParam)nodeInfo).isRequiredParam();
                localParamInfo.isTunnel = ((XSLLocalParam)nodeInfo).isTunnelParam();
                arrayList.add(localParamInfo);
            }
        });
        namedTemplate.setLocalParamDetails(arrayList);
    }

    public NamedTemplate getNamedTemplate(StructuredQName object) {
        HashMap<SymbolicName, Component> hashMap = this.a.getComponentIndex();
        object = hashMap.get(new SymbolicName(200, (StructuredQName)object));
        if (object == null) {
            return null;
        }
        return (NamedTemplate)((Component)object).getActor();
    }

    protected void indexAttributeSet(ComponentDeclaration componentDeclaration) {
        Object object = (XSLAttributeSet)componentDeclaration.getSourceElement();
        Object object2 = ((XSLAttributeSet)object).getAttributeSetName();
        List<ComponentDeclaration> list = this.n.get(object2);
        if (list == null) {
            list = new ArrayList<ComponentDeclaration>();
            this.n.put((StructuredQName)object2, list);
        } else {
            object = Whitespace.trim(((NodeImpl)object).getAttributeValue("", "visibility"));
            object2 = Whitespace.trim(((NodeImpl)list.get(0).getSourceElement()).getAttributeValue("", "visibility"));
            if (object == null ? object2 != null : !((String)object).equals(object2)) {
                throw new XPathException("Visibility attributes on attribute-sets sharing the same name must all be the same", "XTSE0010");
            }
        }
        list.add(0, componentDeclaration);
    }

    public List<ComponentDeclaration> getAttributeSetDeclarations(StructuredQName structuredQName) {
        return this.n.get(structuredQName);
    }

    public void combineAttributeSets(Compilation compilation) {
        Object object;
        Object object2;
        HashMap<StructuredQName, Object> hashMap = new HashMap<StructuredQName, Object>();
        for (Object object3 : this.n.entrySet()) {
            object2 = new AttributeSet();
            ((AttributeSet)object2).setName(object3.getKey());
            ((Actor)object2).setPackageData(this.a);
            object = object3.getValue().get(0).getSourceElement();
            ((Actor)object2).setSystemId(((NodeImpl)object).getSystemId());
            ((Actor)object2).setLineNumber(((NodeImpl)object).getLineNumber());
            hashMap.put(object3.getKey(), object2);
            Component component = ((Actor)object2).getDeclaringComponent();
            if (component == null) {
                component = ((Actor)object2).makeDeclaringComponent(Visibility.PRIVATE, this.a);
            }
            this.a.addComponent(component);
        }
        for (Object object3 : this.n.entrySet()) {
            Object object4;
            object2 = new ArrayList();
            object = null;
            boolean bl2 = false;
            boolean bl3 = false;
            ArrayList<ComponentDeclaration> arrayList = new ArrayList<ComponentDeclaration>();
            HashSet<XSLAttributeSet> hashSet = new HashSet<XSLAttributeSet>();
            for (int i2 = object3.getValue().size() - 1; i2 >= 0; --i2) {
                ComponentDeclaration componentDeclaration = object3.getValue().get(i2);
                object4 = (XSLAttributeSet)componentDeclaration.getSourceElement();
                if (hashSet.contains(object4)) continue;
                arrayList.add(0, componentDeclaration);
                hashSet.add((XSLAttributeSet)object4);
            }
            for (ComponentDeclaration componentDeclaration : arrayList) {
                object4 = (XSLAttributeSet)componentDeclaration.getSourceElement();
                bl3 |= ((XSLAttributeSet)object4).isDeclaredStreamable();
                ((StyleElement)object4).compileDeclaration(compilation, componentDeclaration);
                object2.addAll(((XSLAttributeSet)object4).getContainedInstructions());
                object = ((StyleElement)object4).getVisibility();
                bl2 = bl2 || ((NodeImpl)object4).getAttributeValue("", "visibility") != null;
            }
            AttributeSet attributeSet = (AttributeSet)hashMap.get(object3.getKey());
            attributeSet.setDeclaredStreamable(bl3);
            Expression object52 = Block.makeBlock((List<Expression>)object2);
            attributeSet.setBody(object52);
            object4 = this.getConfiguration().makeSlotManager();
            ExpressionTool.allocateSlots(object52, 0, (SlotManager)object4);
            ((Actor)attributeSet).setStackFrameMap((SlotManager)object4);
            object3 = bl2 ? VisibilityProvenance.EXPLICIT : VisibilityProvenance.DEFAULTED;
            attributeSet.getDeclaringComponent().setVisibility((Visibility)((Object)object), (VisibilityProvenance)((Object)object3));
            if (!bl3) continue;
            this.checkStreamability(attributeSet);
        }
    }

    protected void checkStreamability(AttributeSet attributeSet) {
    }

    protected void getAttributeSets(StructuredQName structuredQName, List<ComponentDeclaration> list) {
        for (ComponentDeclaration componentDeclaration : this.topLevel) {
            XSLAttributeSet xSLAttributeSet;
            if (!(componentDeclaration.getSourceElement() instanceof XSLAttributeSet) || !(xSLAttributeSet = (XSLAttributeSet)componentDeclaration.getSourceElement()).getAttributeSetName().equals(structuredQName)) continue;
            list.add(componentDeclaration);
        }
    }

    public void indexMode(ComponentDeclaration object) {
        Object object2 = ((StyleElement)(object = (XSLMode)((ComponentDeclaration)object).getSourceElement())).getObjectName();
        if (object2 == null) {
            return;
        }
        SymbolicName symbolicName = new SymbolicName(174, (StructuredQName)object2);
        object2 = this.getStylesheetPackage().getRuleManager().obtainMode((StructuredQName)object2, false);
        if (object2 != null && ((Mode)object2).getDeclaringComponent().getDeclaringPackage() != this.getStylesheetPackage()) {
            ((StyleElement)object).compileError("Mode " + symbolicName.getComponentName().getDisplayName() + " conflicts with a public mode declared in package " + ((Mode)object2).getDeclaringComponent().getDeclaringPackage().getPackageName(), "XTSE3050");
        }
    }

    public boolean checkAcceptableModeForPackage(XSLTemplate xSLTemplate, Mode object) {
        Object object2 = xSLTemplate.getPackageData();
        if (((Mode)object).getDeclaringComponent() == null) {
            return true;
        }
        StylesheetPackage stylesheetPackage = ((Mode)object).getDeclaringComponent().getDeclaringPackage();
        if (object2 != stylesheetPackage) {
            object2 = xSLTemplate.getParent();
            boolean bl2 = false;
            if (!(object2 instanceof XSLOverride)) {
                bl2 = true;
            } else if (!((object2 = object2.getParent()) instanceof XSLUsePackage)) {
                bl2 = true;
            } else {
                object = ((Actor)object).getSymbolicName();
                object = (Component.M)((StyleElement)((XSLUsePackage)object2)).getUsedPackage().getComponent((SymbolicName)object);
                if (object == null) {
                    bl2 = true;
                } else if (((Component)object).getVisibility() == Visibility.FINAL) {
                    bl2 = true;
                }
            }
            if (bl2) {
                xSLTemplate.compileError("A template rule cannot be added to a mode declared in a used package unless the xsl:template declaration appears within an xsl:override child of the appropriate xsl:use-package element", "XTSE3050");
                return false;
            }
        }
        return true;
    }

    public AccumulatorRegistry getAccumulatorManager() {
        return this.i;
    }

    public void setAccumulatorManager(AccumulatorRegistry accumulatorRegistry) {
        this.i = accumulatorRegistry;
        this.a.setAccumulatorRegistry(accumulatorRegistry);
    }

    protected void addNamespaceAlias(ComponentDeclaration componentDeclaration) {
        this.k.add(componentDeclaration);
        ++this.j;
    }

    protected NamespaceBinding getNamespaceAlias(String string) {
        return this.l.get(string);
    }

    protected boolean isAliasResultNamespace(String string) {
        return this.m.contains(string);
    }

    protected boolean hasNamespaceAliases() {
        return this.j > 0;
    }

    public Properties gatherOutputProperties(StructuredQName structuredQName) {
        boolean bl2 = structuredQName == null;
        Object object = this.getConfiguration();
        object = new Properties(((Configuration)object).getDefaultSerializationProperties());
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(10);
        for (int i2 = this.topLevel.size() - 1; i2 >= 0; --i2) {
            ComponentDeclaration componentDeclaration = this.topLevel.get(i2);
            if (!(componentDeclaration.getSourceElement() instanceof XSLOutput)) continue;
            XSLOutput xSLOutput = (XSLOutput)componentDeclaration.getSourceElement();
            if (!(structuredQName == null ? xSLOutput.getFormatQName() == null : structuredQName.equals(xSLOutput.getFormatQName()))) continue;
            bl2 = true;
            xSLOutput.gatherOutputProperties((Properties)object, hashMap, componentDeclaration.getPrecedence());
        }
        if (!bl2) {
            this.compileError("Requested output format " + structuredQName.getDisplayName() + " has not been defined", "XTDE1460");
        }
        return object;
    }

    protected void compile(Compilation compilation) {
        try {
            Object object;
            Object object4 = this.getConfiguration();
            XQueryFunctionLibrary object52 = this.a.getXQueryFunctionLibrary();
            Iterator<XQueryFunction> iterator = object52.getFunctionDefinitions();
            while (iterator.hasNext()) {
                XQueryFunction xQueryFunction = iterator.next();
                xQueryFunction.fixupReferences();
            }
            boolean bl2 = !this.getStylesheetPackage().isDeclaredModes();
            for (ComponentDeclaration componentDeclaration : this.topLevel) {
                object = componentDeclaration.getSourceElement();
                if (object instanceof XSLMode) {
                    this.getRuleManager().obtainMode(((StyleElement)object).getObjectName(), true);
                }
                if (!bl2) continue;
                this.a((StyleElement)object, this.getRuleManager());
            }
            for (ComponentDeclaration componentDeclaration : this.topLevel) {
                object = componentDeclaration.getSourceElement();
                if (!(object instanceof XSLTemplate)) continue;
                ((XSLTemplate)object).register(componentDeclaration);
            }
            this.adjustExposedVisibility();
            for (ComponentDeclaration componentDeclaration : this.topLevel) {
                object = componentDeclaration.getSourceElement();
                if (((StyleElement)object).isActionCompleted(2)) continue;
                ((StyleElement)object).setActionCompleted(2);
                ((StyleElement)object).compileDeclaration(compilation, componentDeclaration);
            }
            for (ComponentDeclaration componentDeclaration : this.e.values()) {
                object = componentDeclaration.getSourceElement();
                if (((StyleElement)object).isActionCompleted(4)) continue;
                ((StyleElement)object).setActionCompleted(4);
                if (((StyleElement)object).getVisibility() == Visibility.ABSTRACT) continue;
                ((XSLFunction)object).getCompiledFunction().typeCheck(((StyleElement)object).makeExpressionVisitor());
            }
            if (compilation.getErrorCount() > 0) {
                return;
            }
            this.optimizeTopLevel();
            for (ComponentDeclaration componentDeclaration : this.e.values()) {
                object = componentDeclaration.getSourceElement();
                if (((StyleElement)object).isActionCompleted(8)) continue;
                ((StyleElement)object).setActionCompleted(8);
                ((StylesheetComponent)object).optimize(componentDeclaration);
            }
            this.getDecimalFormatManager().checkConsistency();
            this.getRuleManager().checkConsistency();
            this.getRuleManager().computeRankings();
            ExecutableFunctionLibrary executableFunctionLibrary = new ExecutableFunctionLibrary((Configuration)object4);
            ExecutableFunctionLibrary executableFunctionLibrary2 = new ExecutableFunctionLibrary((Configuration)object4);
            for (Component component : this.a.getComponentIndex().values()) {
                component.getVisibility();
                if (!(component.getActor() instanceof UserFunction)) continue;
                UserFunction userFunction = (UserFunction)component.getActor();
                if (userFunction.isOverrideExtensionFunction()) {
                    executableFunctionLibrary.addFunction(userFunction);
                    continue;
                }
                executableFunctionLibrary2.addFunction(userFunction);
            }
            this.getStylesheetPackage().setFunctionLibraryDetails(null, executableFunctionLibrary, executableFunctionLibrary2);
            for (ComponentDeclaration componentDeclaration : this.topLevel) {
                NamedTemplate namedTemplate;
                StyleElement styleElement = componentDeclaration.getSourceElement();
                if (!(styleElement instanceof XSLTemplate) || (namedTemplate = ((XSLTemplate)styleElement).getActor()) == null || namedTemplate.getTemplateName() != null) continue;
                namedTemplate.allocateAllBindingSlots(this.a);
            }
            object = this.a.getComponentIndex();
            for (Component component : ((HashMap)object).values()) {
                Actor actor = component.getActor();
                if (actor == null) continue;
                actor.allocateAllBindingSlots(this.a);
            }
            KeyManager keyManager = this.getKeyManager();
            for (KeyDefinitionSet keyDefinitionSet : keyManager.getAllKeyDefinitionSets()) {
                for (KeyDefinition keyDefinition : keyDefinitionSet.getKeyDefinitions()) {
                    keyDefinition.makeDeclaringComponent(Visibility.PRIVATE, this.getStylesheetPackage());
                    ((Actor)keyDefinition).allocateAllBindingSlots(this.a);
                }
            }
            AccumulatorRegistry accumulatorRegistry = this.getAccumulatorManager();
            if (accumulatorRegistry != null) {
                for (Accumulator accumulator : accumulatorRegistry.getAllAccumulators()) {
                    accumulator.allocateAllBindingSlots(this.a);
                }
            }
            if (compilation.getCompilerInfo().isGenerateByteCode() && !((Configuration)object4).isDeferredByteCode(50)) {
                Optimizer optimizer = ((Configuration)object4).obtainOptimizer();
                for (ComponentDeclaration componentDeclaration : this.topLevel) {
                    object4 = componentDeclaration.getSourceElement();
                    if (!(object4 instanceof StylesheetComponent)) continue;
                    ((StylesheetComponent)object4).generateByteCode(optimizer);
                }
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            if (compilation.getErrorCount() == 0) {
                throw runtimeException;
            }
            return;
        }
    }

    private void a(StyleElement styleElement, RuleManager ruleManager) {
        String[] stringArray;
        if ((styleElement instanceof XSLApplyTemplates || styleElement instanceof XSLTemplate) && (stringArray = styleElement.getAttributeValue("mode")) != null) {
            String[] stringArray2;
            stringArray = stringArray2 = Whitespace.trim((CharSequence)stringArray).split("[ \t\n\r]+");
            int n2 = stringArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = stringArray[i2];
                if (((String)object).startsWith("#")) continue;
                try {
                    object = styleElement.makeQName((String)object);
                    Object object2 = new SymbolicName(174, (StructuredQName)object);
                    HashMap<SymbolicName, Component> hashMap = this.getStylesheetPackage().getComponentIndex();
                    object2 = hashMap.get(object2);
                    if (object2 != null && ((Component)object2).getDeclaringPackage() != this.getStylesheetPackage()) {
                        if (!(styleElement instanceof XSLTemplate) || styleElement.getParent() instanceof XSLOverride) continue;
                        styleElement.compileError("A template rule cannot be added to a mode declared in a used package unless the xsl:template declaration appears within an xsl:override child of the appropriate xsl:use-package element", "XTSE3050");
                        continue;
                    }
                    ruleManager.obtainMode((StructuredQName)object, true);
                    continue;
                }
                catch (XPathException xPathException) {}
            }
        }
        AxisIterator axisIterator = styleElement.iterateAxis((byte)3);
        while ((stringArray = axisIterator.next()) != null) {
            if (!(stringArray instanceof StyleElement)) continue;
            this.a((StyleElement)stringArray, ruleManager);
        }
    }

    public void optimizeTopLevel() {
        for (ComponentDeclaration componentDeclaration : this.topLevel) {
            StyleElement styleElement = componentDeclaration.getSourceElement();
            if (styleElement instanceof StylesheetComponent && !(styleElement instanceof XSLFunction) && !styleElement.isActionCompleted(8)) {
                styleElement.setActionCompleted(8);
                ((StylesheetComponent)((Object)styleElement)).optimize(componentDeclaration);
            }
            if (!(styleElement instanceof XSLTemplate)) continue;
            ((XSLTemplate)styleElement).allocatePatternSlotNumbers();
        }
    }

    protected boolean isImportedSchema(String string) {
        return this.a.getSchemaNamespaces().contains(string);
    }

    protected void addImportedSchema(String string) {
        this.a.getSchemaNamespaces().add(string);
    }

    protected Set<String> getImportedSchemaTable() {
        return this.a.getSchemaNamespaces();
    }

    public ComponentDeclaration getCharacterMap(StructuredQName structuredQName) {
        for (int i2 = this.topLevel.size() - 1; i2 >= 0; --i2) {
            XSLCharacterMap xSLCharacterMap;
            ComponentDeclaration componentDeclaration = this.topLevel.get(i2);
            if (!(componentDeclaration.getSourceElement() instanceof XSLCharacterMap) || !(xSLCharacterMap = (XSLCharacterMap)componentDeclaration.getSourceElement()).getCharacterMapName().equals(structuredQName)) continue;
            return componentDeclaration;
        }
        return null;
    }

    public void adjustExposedVisibility() {
        ArrayList<XSLExpose> arrayList = new ArrayList<XSLExpose>();
        for (ComponentDeclaration object2 : this.topLevel) {
            if (!(object2.getSourceElement() instanceof XSLExpose)) continue;
            arrayList.add(0, (XSLExpose)object2.getSourceElement());
        }
        if (arrayList.isEmpty()) {
            return;
        }
        NamePool namePool = this.getConfiguration().getNamePool();
        HashMap<SymbolicName, Component> hashMap = this.a.getComponentIndex();
        block1: for (Component component : hashMap.values()) {
            int n2 = component.getComponentKind();
            ComponentTest componentTest3 = new ComponentTest(n2, new NameTest(1, new FingerprintedQName(component.getActor().getObjectName(), namePool), namePool), -1);
            ComponentTest componentTest2 = null;
            if (n2 == 158) {
                Function function = (Function)((Object)component.getActor());
                componentTest2 = new ComponentTest(n2, new NameTest(1, new FingerprintedQName(function.getFunctionName(), namePool), namePool), function.getArity());
            }
            boolean bl2 = false;
            for (XSLExpose xSLExpose : arrayList) {
                Set<ComponentTest> set = xSLExpose.getExplicitComponentTests();
                if (!set.contains(componentTest3) && (componentTest2 == null || !set.contains(componentTest2))) continue;
                component.setVisibility(((StyleElement)xSLExpose).getVisibility(), VisibilityProvenance.EXPOSED);
                bl2 = true;
                break;
            }
            if (bl2 || component.getVisibilityProvenance() != VisibilityProvenance.DEFAULTED) continue;
            block3: for (XSLExpose xSLExpose : arrayList) {
                for (ComponentTest componentTest3 : xSLExpose.getWildcardComponentTests()) {
                    if (!componentTest3.isPartialWildcard() || !componentTest3.matches(component.getActor())) continue;
                    component.setVisibility(((StyleElement)xSLExpose).getVisibility(), VisibilityProvenance.EXPOSED);
                    bl2 = true;
                    break block3;
                }
            }
            if (bl2) continue;
            for (XSLExpose xSLExpose : arrayList) {
                for (ComponentTest componentTest3 : xSLExpose.getWildcardComponentTests()) {
                    if (!componentTest3.matches(component.getActor())) continue;
                    component.setVisibility(((StyleElement)xSLExpose).getVisibility(), VisibilityProvenance.EXPOSED);
                    continue block1;
                }
            }
        }
    }

    protected void compileError(String object, String string) {
        object = new XPathException((String)object, string);
        this.compileError((XPathException)object);
    }

    protected void compileError(XPathException xPathException) {
        xPathException.setIsStaticError(true);
        this.getRootElement().compileError(xPathException);
    }

    protected void fixup() {
        for (Action action : this.r) {
            action.doAction();
        }
    }

    protected void complete() {
        this.a.complete();
    }

    public SlotManager getSlotManager() {
        return null;
    }

    @Override
    public GlobalVariable getEquivalentVariable(Expression expression) {
        return null;
    }

    @Override
    public void addGlobalVariable(GlobalVariable globalVariable) {
        this.addGlobalVariable(globalVariable, Visibility.PRIVATE);
    }

    public void addGlobalVariable(GlobalVariable globalVariable, Visibility visibility) {
        Component component = globalVariable.makeDeclaringComponent(visibility, this.getStylesheetPackage());
        if (globalVariable.getPackageData() == null) {
            globalVariable.setPackageData(this.a);
        }
        if (visibility == Visibility.HIDDEN) {
            this.a.addHiddenComponent(component);
            return;
        }
        this.a.getComponentIndex().put(new SymbolicName(206, globalVariable.getVariableQName()), component);
    }
}

