/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLGlobalParam;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.AttributeLocation;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class SourceBinding {
    private StyleElement a;
    private StructuredQName b;
    private Expression c = null;
    private SequenceType d = null;
    private SequenceType e = null;
    protected SlotManager slotManager = null;
    private Visibility f;
    private GroundedValue<?> g = null;
    private int h;
    public static final int PRIVATE = 1;
    public static final int GLOBAL = 2;
    public static final int PARAM = 4;
    public static final int TUNNEL = 8;
    public static final int REQUIRED = 16;
    public static final int IMPLICITLY_REQUIRED = 32;
    public static final int ASSIGNABLE = 64;
    public static final int SELECT = 128;
    public static final int AS = 256;
    public static final int DISALLOWS_CONTENT = 512;
    public static final int STATIC = 2048;
    public static final int VISIBILITY = 4096;
    public static final int IMPLICITLY_DECLARED = 8192;
    private List<BindingReference> i = new ArrayList<BindingReference>(10);

    public SourceBinding(StyleElement styleElement) {
        this.a = styleElement;
    }

    public void prepareAttributes(int n2) {
        int n3;
        AttributeCollection attributeCollection = this.a.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        for (n3 = 0; n3 < attributeCollection.getLength(); ++n3) {
            String string9 = attributeCollection.getQName(n3);
            if (string9.equals("name")) {
                if (this.b != null && !this.b.equals(SourceBinding.a())) continue;
                this.a(attributeCollection.getValue(n3));
                continue;
            }
            if (string9.equals("select")) {
                if ((n2 & 0x80) != 0) {
                    string = attributeCollection.getValue(n3);
                    continue;
                }
                this.a.compileErrorInAttribute("The select attribute is not permitted on a function parameter", "XTSE0760", "select");
                continue;
            }
            if (string9.equals("as") && (n2 & 0x100) != 0) {
                string2 = attributeCollection.getValue(n3);
                continue;
            }
            if (string9.equals("required") && (n2 & 0x10) != 0) {
                string4 = Whitespace.trim(attributeCollection.getValue(n3));
                continue;
            }
            if (string9.equals("tunnel")) {
                string5 = Whitespace.trim(attributeCollection.getValue(n3));
                continue;
            }
            if (string9.equals("static") && (n2 & 0x800) != 0) {
                string7 = Whitespace.trim(attributeCollection.getValue(n3));
                continue;
            }
            if (string9.equals("visibility") && (n2 & 0x1000) != 0) {
                string8 = Whitespace.trim(attributeCollection.getValue(n3));
                continue;
            }
            if ("http://saxon.sf.net/".equals(attributeCollection.getURI(n3))) {
                if (attributeCollection.getLocalName(n3).equals("assignable") && (n2 & 0x40) != 0) {
                    string6 = Whitespace.trim(attributeCollection.getValue(n3));
                    continue;
                }
                if (attributeCollection.getLocalName(n3).equals("as")) {
                    string3 = attributeCollection.getValue(n3);
                    continue;
                }
                this.a.checkUnknownAttribute(attributeCollection.getNodeName(n3));
                continue;
            }
            this.a.checkUnknownAttribute(attributeCollection.getNodeName(n3));
        }
        if (this.b == null) {
            this.a.reportAbsence("name");
            this.b = SourceBinding.a();
        }
        if (string != null) {
            this.c = this.a.makeExpression(string, this.a.getAttributeList().getIndex("", "select"));
        }
        if (string4 != null) {
            n3 = this.a.processBooleanAttribute("required", string4) ? 1 : 0;
            this.setProperty(16, n3 != 0);
            if (n3 != 0 && this.c != null) {
                this.a.compileError("xsl:param: cannot supply a default value when required='yes'");
            }
        }
        if (string5 != null) {
            boolean bl2 = this.a.processBooleanAttribute("tunnel", string5);
            n3 = bl2 ? 1 : 0;
            if (bl2 && (n2 & 8) == 0) {
                this.a.compileErrorInAttribute("The only permitted value of the 'tunnel' attribute is 'no'", "XTSE0020", "tunnel");
            }
            this.setProperty(8, n3 != 0);
        }
        if (string6 != null) {
            n3 = this.a.processBooleanAttribute("saxon:assignable", string6);
            this.setProperty(64, n3 != 0);
        }
        if (string7 != null) {
            n3 = this.a.processBooleanAttribute("static", string7) ? 1 : 0;
            this.setProperty(2048, n3 != 0);
            if (n3 != 0) {
                this.setProperty(512, true);
            }
            if (n3 != 0 && !this.hasProperty(2)) {
                this.a.compileErrorInAttribute("Only global declarations can be static", "XTSE0020", "static");
            }
        }
        this.d = this.a(string2, string3);
        if (string8 != null) {
            if (this.hasProperty(4)) {
                this.a.compileErrorInAttribute("The visibility attribute is not allowed on xsl:param", "XTSE0020", "visibility");
            } else {
                this.f = this.a.interpretVisibilityValue(string8, "");
            }
            if (!this.hasProperty(2)) {
                this.a.compileErrorInAttribute("The visibility attribute is allowed only on global declarations", "XTSE0020", "visibility");
            }
        }
        if (this.hasProperty(2048) && this.f != Visibility.PRIVATE && string8 != null) {
            this.a.compileErrorInAttribute("A static variable or parameter must be private", "XTSE0020", "static");
        }
    }

    public void prepareTemplateSignatureAttributes() {
        AttributeCollection attributeCollection = this.a.getAttributeList();
        String string = null;
        String string2 = null;
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string3 = attributeCollection.getQName(i2);
            if (string3.equals("name")) {
                if (this.b != null && !this.b.equals(SourceBinding.a())) continue;
                this.a(attributeCollection.getValue(i2));
                continue;
            }
            if (string3.equals("as")) {
                string = attributeCollection.getValue(i2);
                continue;
            }
            if (string3.equals("required")) {
                string3 = Whitespace.trim(attributeCollection.getValue(i2));
                boolean bl2 = this.a.processBooleanAttribute("required", string3);
                this.setProperty(16, bl2);
                continue;
            }
            if (string3.equals("tunnel")) {
                string3 = Whitespace.trim(attributeCollection.getValue(i2));
                boolean bl3 = this.a.processBooleanAttribute("tunnel", string3);
                this.setProperty(8, bl3);
                continue;
            }
            if (!"http://saxon.sf.net/".equals(attributeCollection.getURI(i2)) || !attributeCollection.getLocalName(i2).equals("as")) continue;
            string2 = attributeCollection.getValue(i2);
        }
        if (this.b == null) {
            this.a.reportAbsence("name");
            this.b = SourceBinding.a();
        }
        this.d = this.a(string, string2);
    }

    private SequenceType a(String string, String string2) {
        SequenceType sequenceType = null;
        if (string != null) {
            try {
                sequenceType = this.a.makeSequenceType(string);
            }
            catch (XPathException xPathException) {
                this.a.compileErrorInAttribute(xPathException.getMessage(), xPathException.getErrorCodeLocalPart(), "as");
            }
        }
        if (string2 != null) {
            SequenceType sequenceType2;
            try {
                sequenceType2 = this.a.makeExtendedSequenceType(string2);
            }
            catch (XPathException xPathException) {
                this.a.compileErrorInAttribute(xPathException.getMessage(), xPathException.getErrorCodeLocalPart(), "saxon:as");
                sequenceType2 = SequenceType.ANY_SEQUENCE;
            }
            if (string != null) {
                int n2 = ((NodeImpl)this.a).getConfiguration().getTypeHierarchy().sequenceTypeRelationship(sequenceType2, sequenceType);
                if (n2 == 0 || n2 == 2) {
                    sequenceType = sequenceType2;
                } else {
                    this.a.compileErrorInAttribute("When both are present, @saxon:as must be a subtype of @as", "SXER7TBA", "as");
                }
            } else {
                sequenceType = sequenceType2;
            }
        }
        return sequenceType;
    }

    public StyleElement getSourceElement() {
        return this.a;
    }

    public void setVariableQName(StructuredQName structuredQName) {
        this.b = structuredQName;
    }

    public void setDeclaredType(SequenceType sequenceType) {
        this.d = sequenceType;
    }

    private void a(String string) {
        try {
            if (string != null) {
                this.b = this.a.makeQName(string);
            }
            return;
        }
        catch (XPathException xPathException) {
            this.b = SourceBinding.a();
            StructuredQName structuredQName = StructuredQName.fromClarkName("name");
            throw new XPathException("Invalid variable name: " + xPathException.getMessage() + (string.startsWith("$") ? " (No '$' sign needed)" : ""), "XTSE0020", new AttributeLocation(this.a, structuredQName));
        }
    }

    private static StructuredQName a() {
        return new StructuredQName("saxon", "http://saxon.sf.net/", "error-variable-name");
    }

    public void validate() {
        if (this.c != null && ((NodeImpl)this.a).hasChildNodes()) {
            this.a.compileError("An " + this.a.getDisplayName() + " element with a select attribute must be empty", "XTSE0620");
        }
        if (this.hasProperty(512) && ((NodeImpl)this.a).hasChildNodes()) {
            if (this.isStatic()) {
                this.a.compileError("A static variable or parameter must have no content", "XTSE0010");
            } else {
                this.a.compileError("Within xsl:function, an xsl:param element must have no content", "XTSE0620");
            }
        }
        if (this.f == Visibility.ABSTRACT && (this.c != null || ((NodeImpl)this.a).hasChildNodes())) {
            this.a.compileError("An abstract variable must have no select attribute and no content", "XTSE0620");
        }
    }

    public void postValidate() {
        SourceBinding sourceBinding = this;
        sourceBinding.checkAgainstRequiredType(sourceBinding.d);
        if (this.c == null && !this.hasProperty(512) && this.f != Visibility.ABSTRACT) {
            Object object = this.a.iterateAxis((byte)3);
            if ((object = object.next()) == null) {
                if (this.d == null) {
                    this.c = new StringLiteral(StringValue.EMPTY_STRING);
                    this.c.setRetainedStaticContext(this.a.makeRetainedStaticContext());
                } else if (this.a instanceof XSLLocalParam || this.a instanceof XSLGlobalParam) {
                    if (!this.hasProperty(16)) {
                        if (Cardinality.allowsZero(this.d.getCardinality())) {
                            this.c = Literal.makeEmptySequence();
                            this.c.setRetainedStaticContext(this.a.makeRetainedStaticContext());
                        } else {
                            this.setProperty(32, true);
                        }
                    }
                } else if (Cardinality.allowsZero(this.d.getCardinality())) {
                    this.c = Literal.makeEmptySequence();
                    this.c.setRetainedStaticContext(this.a.makeRetainedStaticContext());
                } else {
                    this.a.compileError("The implicit value () is not valid for the declared type", "XTTE0570");
                }
            }
        }
        this.c = this.a.typeCheck("select", this.c);
    }

    public boolean isStatic() {
        return this.hasProperty(2048);
    }

    public void checkAgainstRequiredType(SequenceType sequenceType) {
        if (this.f != Visibility.ABSTRACT) {
            try {
                if (sequenceType != null && this.c != null) {
                    int n2 = 3;
                    String string = "XTTE0570";
                    if (this.a instanceof XSLLocalParam) {
                        n2 = 8;
                        string = "XTTE0600";
                    } else if (this.a instanceof XSLWithParam || this.a instanceof XSLGlobalParam) {
                        n2 = 8;
                        string = "XTTE0590";
                    }
                    RoleDiagnostic roleDiagnostic = new RoleDiagnostic(n2, this.b.getDisplayName(), 0);
                    roleDiagnostic.setErrorCode(string);
                    this.c = ((NodeImpl)this.a).getConfiguration().getTypeChecker(false).staticTypeCheck(this.c, sequenceType, roleDiagnostic, this.a.makeExpressionVisitor());
                }
                return;
            }
            catch (XPathException xPathException) {
                XPathException xPathException2 = xPathException;
                xPathException.setLocator(this.a);
                this.a.compileError(xPathException2);
                this.c = new ErrorExpression(xPathException2);
            }
        }
    }

    public StructuredQName getVariableQName() {
        if (this.b == null) {
            try {
                SourceBinding sourceBinding = this;
                sourceBinding.a(((NodeImpl)sourceBinding.a).getAttributeValue("", "name"));
            }
            catch (XPathException xPathException) {
                return SourceBinding.a();
            }
        }
        return this.b;
    }

    public void setProperty(int n2, boolean bl2) {
        if (bl2) {
            this.h |= n2;
            return;
        }
        this.h &= ~n2;
    }

    public boolean hasProperty(int n2) {
        return (this.h & n2) != 0;
    }

    public List<BindingReference> getReferences() {
        return this.i;
    }

    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    public void handleSequenceConstructor(Compilation object, ComponentDeclaration componentDeclaration) {
        if (((NodeImpl)this.a).hasChildNodes()) {
            if (this.d == null) {
                if ((object = this.a.compileSequenceConstructor((Compilation)object, componentDeclaration, true)) == null) {
                    object = Literal.makeEmptySequence();
                }
                boolean bl2 = UType.TEXT.subsumes(((Expression)object).getItemType().getUType());
                String string = null;
                if (bl2 && object instanceof ValueOf && ((ValueOf)object).getSelect() instanceof StringLiteral) {
                    string = ((StringLiteral)((ValueOf)object).getSelect()).getStringValue();
                }
                DocumentInstr documentInstr = new DocumentInstr(bl2, string);
                documentInstr.setContentExpression((Expression)object);
                documentInstr.setRetainedStaticContext(this.a.makeRetainedStaticContext());
                this.c = documentInstr;
                return;
            }
            this.c = this.a.compileSequenceConstructor((Compilation)object, componentDeclaration, true);
            if (this.c == null) {
                this.c = Literal.makeEmptySequence();
            }
            try {
                object = new RoleDiagnostic(3, this.b.getDisplayName(), 0);
                ((RoleDiagnostic)object).setErrorCode("XTTE0570");
                this.c = this.c.simplify();
                this.c = ((NodeImpl)this.a).getConfiguration().getTypeChecker(false).staticTypeCheck(this.c, this.d, (RoleDiagnostic)object, this.a.makeExpressionVisitor());
                return;
            }
            catch (XPathException xPathException) {
                object = xPathException;
                xPathException.setLocator(this.a);
                this.a.compileError((XPathException)object);
                this.c = new ErrorExpression((XPathException)object);
            }
        }
    }

    public SequenceType getDeclaredType() {
        if (this.d == null) {
            String string = ((NodeImpl)this.a).getAttributeValue("", "as");
            if (string == null) {
                return null;
            }
            try {
                this.d = this.a.makeSequenceType(string);
            }
            catch (XPathException xPathException) {}
        }
        return this.d;
    }

    public Expression getSelectExpression() {
        return this.c;
    }

    public SequenceType getInferredType(boolean bl2) {
        if (this.e != null) {
            return this.e;
        }
        Object object = this.a.getVisibility();
        if (this.hasProperty(4) || this.hasProperty(64) || object != Visibility.PRIVATE && object != Visibility.FINAL) {
            SequenceType sequenceType = this.getDeclaredType();
            this.e = sequenceType == null ? SequenceType.ANY_SEQUENCE : sequenceType;
            return this.e;
        }
        if (this.c != null) {
            TypeHierarchy typeHierarchy = ((NodeImpl)this.a).getConfiguration().getTypeHierarchy();
            if (Literal.isEmptySequence(this.c)) {
                this.e = this.d == null ? SequenceType.ANY_SEQUENCE : this.d;
                return this.e;
            }
            object = this.c.getItemType();
            int n2 = this.c.getCardinality();
            if (this.d != null) {
                if (!typeHierarchy.isSubType((ItemType)object, this.d.getPrimaryType())) {
                    object = this.d.getPrimaryType();
                }
                if (!Cardinality.subsumes(this.d.getCardinality(), n2)) {
                    n2 = this.d.getCardinality();
                }
            }
            this.e = SequenceType.makeSequenceType((ItemType)object, n2);
            return this.e;
        }
        if (bl2) {
            if (((NodeImpl)this.a).hasChildNodes()) {
                if (this.d == null) {
                    return SequenceType.makeSequenceType(NodeKindTest.DOCUMENT, 16384);
                }
                return this.d;
            }
            if (this.d == null) {
                return SequenceType.SINGLE_STRING;
            }
            return this.d;
        }
        return this.d;
    }

    public void registerReference(BindingReference bindingReference) {
        this.i.add(bindingReference);
    }

    public GroundedValue<?> getConstantValue() {
        if (this.g == null) {
            int n2;
            SequenceType sequenceType = this.getInferredType(true);
            TypeHierarchy typeHierarchy = ((NodeImpl)this.a).getConfiguration().getTypeHierarchy();
            if (!(this.hasProperty(64) || this.hasProperty(4) || this.f == Visibility.PUBLIC || this.f == Visibility.ABSTRACT || !(this.c instanceof Literal) || (n2 = typeHierarchy.relationship(this.c.getItemType(), sequenceType.getPrimaryType())) != 0 && n2 != 2)) {
                this.g = ((Literal)this.c).getValue();
            }
        }
        return this.g;
    }

    public void fixupReferences(GlobalVariable globalVariable) {
        SequenceType sequenceType = this.getInferredType(true);
        ((NodeImpl)this.a).getConfiguration().getTypeHierarchy();
        int n2 = 0;
        if (!this.hasProperty(64) && !this.hasProperty(4) && this.f != Visibility.PUBLIC && this.f != Visibility.ABSTRACT && this.c != null) {
            n2 = this.c.getSpecialProperties();
        }
        for (BindingReference bindingReference : this.i) {
            if (globalVariable != null) {
                bindingReference.fixup(globalVariable);
            }
            bindingReference.setStaticType(sequenceType, this.getConstantValue(), n2);
        }
    }

    protected void fixupBinding(Binding binding) {
        for (BindingReference bindingReference : this.i) {
            bindingReference.fixup(binding);
        }
    }
}

