/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.ConditionalBlock;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.expr.instruct.SequenceInstr;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.functions.Current;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.QNameParser;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.BasePatternWithPredicate;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternThatSetsCurrent;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.AttributeValueTemplate;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.TextValueTemplateNode;
import net.sf.saxon.style.XSLCallTemplate;
import net.sf.saxon.style.XSLContextItem;
import net.sf.saxon.style.XSLCopy;
import net.sf.saxon.style.XSLDocument;
import net.sf.saxon.style.XSLElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.style.XSLLocalVariable;
import net.sf.saxon.style.XSLModuleRoot;
import net.sf.saxon.style.XSLNextIteration;
import net.sf.saxon.style.XSLOnCompletion;
import net.sf.saxon.style.XSLOnEmpty;
import net.sf.saxon.style.XSLOnNonEmpty;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLSortOrMergeKey;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.AttributeLocation;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.linked.TextImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public abstract class StyleElement
extends ElementImpl {
    protected String[] extensionNamespaces = null;
    private String[] a = null;
    protected int version = -1;
    protected ExpressionContext staticContext = null;
    protected XPathException validationError = null;
    protected int reportingCircumstances = 1;
    protected String defaultXPathNamespace = null;
    protected String defaultCollationName = null;
    protected StructuredQName defaultMode;
    protected boolean expandText = false;
    private StructuredQName b;
    private String c;
    private Compilation d;
    private ExplicitLocation e = null;
    private int f = 0;
    public static final int REPORT_ALWAYS = 1;
    public static final int REPORT_UNLESS_FORWARDS_COMPATIBLE = 2;
    public static final int REPORT_IF_INSTANTIATED = 3;
    public static final int REPORT_STATICALLY_UNLESS_FALLBACK_AVAILABLE = 4;
    public static final int REPORT_DYNAMICALLY_UNLESS_FALLBACK_AVAILABLE = 5;
    public static final int IGNORED_INSTRUCTION = 6;
    protected int actionsCompleted = 0;
    public static final int ACTION_VALIDATE = 1;
    public static final int ACTION_COMPILE = 2;
    public static final int ACTION_TYPECHECK = 4;
    public static final int ACTION_OPTIMIZE = 8;
    public static final int ACTION_FIXUP = 16;
    public static final int ACTION_PROCESS_ATTRIBUTES = 32;
    protected static final String[] YES_NO = new String[]{"0", "1", "false", "no", "true", "yes"};

    public Compilation getCompilation() {
        return this.d;
    }

    public void setCompilation(Compilation compilation) {
        this.d = compilation;
    }

    public StylesheetPackage getPackageData() {
        return this.getPrincipalStylesheetModule().getStylesheetPackage();
    }

    @Override
    public Configuration getConfiguration() {
        return this.d.getConfiguration();
    }

    public ExpressionContext getStaticContext() {
        if (this.staticContext == null) {
            this.staticContext = new ExpressionContext(this, null);
        }
        return this.staticContext;
    }

    public ExpressionContext getStaticContext(StructuredQName structuredQName) {
        return new ExpressionContext(this, structuredQName);
    }

    @Override
    public String getBaseURI() {
        if (this.c == null) {
            this.c = super.getBaseURI();
        }
        return this.c;
    }

    public ExpressionVisitor makeExpressionVisitor() {
        return ExpressionVisitor.make(this.getStaticContext());
    }

    public boolean isSchemaAware() {
        return this.getCompilation().isSchemaAware();
    }

    public void substituteFor(StyleElement styleElement) {
        this.setRawParent(styleElement.getRawParent());
        this.setAttributeList(styleElement.getAttributeList());
        this.setNamespaceList(styleElement.getNamespaceList());
        this.setNodeName(((NodeImpl)styleElement).getNodeName());
        this.setRawSequenceNumber(styleElement.getRawSequenceNumber());
        this.extensionNamespaces = styleElement.extensionNamespaces;
        this.a = styleElement.a;
        this.version = styleElement.version;
        this.staticContext = styleElement.staticContext;
        this.validationError = styleElement.validationError;
        this.reportingCircumstances = styleElement.reportingCircumstances;
        this.d = styleElement.d;
    }

    public void setValidationError(TransformerException transformerException, int n2) {
        this.validationError = XPathException.makeXPathException(transformerException);
        this.reportingCircumstances = n2;
    }

    public void setIgnoreInstruction() {
        this.reportingCircumstances = 6;
    }

    public boolean isInstruction() {
        return false;
    }

    public boolean isDeclaration() {
        return false;
    }

    public Visibility getVisibility() {
        String string = ((NodeImpl)this).getAttributeValue("", "visibility");
        if (string == null) {
            return Visibility.PRIVATE;
        }
        return this.interpretVisibilityValue(string, "");
    }

    public Visibility getDeclaredVisibility() {
        String string = ((NodeImpl)this).getAttributeValue("", "visibility");
        if (string == null) {
            return null;
        }
        return this.interpretVisibilityValue(string, "");
    }

    protected boolean markTailCalls() {
        return false;
    }

    protected boolean mayContainSequenceConstructor() {
        return false;
    }

    protected boolean mayContainFallback() {
        return this.mayContainSequenceConstructor();
    }

    protected boolean mayContainParam() {
        return false;
    }

    public XSLModuleRoot getContainingStylesheet() {
        NodeImpl nodeImpl = this.getParent();
        if (nodeImpl instanceof XSLModuleRoot) {
            return (XSLModuleRoot)nodeImpl;
        }
        if (nodeImpl instanceof StyleElement) {
            return ((StyleElement)nodeImpl).getContainingStylesheet();
        }
        return null;
    }

    public int getDefaultValidation() {
        int n2 = this.f;
        NodeInfo nodeInfo = this;
        while (n2 == 0) {
            if (!((nodeInfo = nodeInfo.getParent()) instanceof StyleElement)) {
                return 4;
            }
            n2 = nodeInfo.f;
        }
        return n2;
    }

    public final StructuredQName makeQName(String object) {
        try {
            object = StructuredQName.fromLexicalQName((CharSequence)object, false, true, this);
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.setIsStaticError(true);
            String string = ((XPathException)object).getErrorCodeLocalPart();
            if ("FONS0004".equals(string)) {
                ((XPathException)object).setErrorCode("XTSE0280");
            } else if ("FOCA0002".equals(string)) {
                ((XPathException)object).setErrorCode("XTSE0020");
            } else if (string == null) {
                ((XPathException)object).setErrorCode("XTSE0020");
            }
            ((TransformerException)object).setLocator(this);
            throw object;
        }
        if (NamespaceConstant.isReserved(((StructuredQName)object).getURI())) {
            if (((StructuredQName)object).hasURI("http://www.w3.org/1999/XSL/Transform")) {
                if (((StructuredQName)object).getLocalPart().equals("initial-template") && (this instanceof XSLTemplate || this instanceof XSLCallTemplate)) {
                    return object;
                }
                if (((StructuredQName)object).getLocalPart().equals("original") && this.findAncestorElement(186) != null) {
                    return object;
                }
            }
            object = new XPathException("Namespace prefix " + ((StructuredQName)object).getPrefix() + " refers to a reserved namespace");
            ((XPathException)object).setIsStaticError(true);
            ((XPathException)object).setErrorCode("XTSE0080");
            throw object;
        }
        return object;
    }

    public StyleElement findAncestorElement(int n2) {
        Optional<NodeInfo> optional = this.iterateAxis((byte)0).firstWith(nodeInfo -> nodeInfo instanceof StyleElement && nodeInfo.getFingerprint() == n2);
        return optional.orElse(null);
    }

    public StylesheetPackage getUsedPackage() {
        return null;
    }

    public Actor getXslOriginal(int n2) {
        StyleElement styleElement = n2 == this.getFingerprint() ? this : this.findAncestorElement(n2);
        if (!(styleElement instanceof StylesheetComponent)) {
            throw new XPathException("A reference to xsl:original appears within the wrong kind of component: in this case, it must be within xsl:" + this.getNamePool().getLocalName(n2), "XTSE0650", this);
        }
        Object object = ((StylesheetComponent)((Object)styleElement)).getSymbolicName();
        if ((styleElement = styleElement.findAncestorElement(186)) == null) {
            throw new XPathException("A reference to xsl:original can be used only within an xsl:override element");
        }
        StyleElement styleElement2 = styleElement.findAncestorElement(204);
        if (styleElement2 == null) {
            throw new XPathException("The parent of xsl:override must be an xsl:use-package element", "XTSE0010", styleElement);
        }
        object = styleElement2.getUsedPackage().getComponent((SymbolicName)object);
        if (object == null) {
            return null;
        }
        return ((Component)object).getActor();
    }

    public Component getOverriddenComponent() {
        if (!(this instanceof StylesheetComponent)) {
            return null;
        }
        SymbolicName symbolicName = ((StylesheetComponent)((Object)this)).getSymbolicName();
        StyleElement styleElement = this.findAncestorElement(186);
        if (styleElement == null) {
            return null;
        }
        if ((styleElement = styleElement.findAncestorElement(204)) == null) {
            return null;
        }
        return styleElement.getUsedPackage().getComponent(symbolicName);
    }

    public SavedNamespaceContext makeNamespaceContext() {
        this.getPackageData();
        return new SavedNamespaceContext(NamespaceIterator.iterateNamespaces(this));
    }

    public RetainedStaticContext makeRetainedStaticContext() {
        return this.getStaticContext().makeRetainedStaticContext();
    }

    public boolean changesRetainedStaticContext() {
        NodeImpl nodeImpl = this.getParent();
        return nodeImpl == null || !ExpressionTool.equalOrNull(((NodeImpl)this).getBaseURI(), nodeImpl.getBaseURI()) || this.defaultCollationName != null || this.defaultXPathNamespace != null || ((NodeImpl)this).getDeclaredNamespaces(NamespaceBinding.EMPTY_ARRAY).length != 0 || !(nodeImpl instanceof StyleElement) || this.getEffectiveVersion() != ((StyleElement)this.getParent()).getEffectiveVersion();
    }

    public NamespaceResolver getNamespaceResolver() {
        return this;
    }

    public void processAllAttributes() {
        this.processDefaultCollationAttribute();
        this.processDefaultMode();
        this.staticContext = new ExpressionContext(this, null);
        this.processAttributes();
        this.iterateAxis((byte)3).forEachOrFail(nodeInfo -> {
            if (nodeInfo instanceof StyleElement) {
                ((StyleElement)nodeInfo).processAllAttributes();
            }
        });
    }

    public void processStandardAttributes(String string) {
        this.processExtensionElementAttribute(string);
        this.processExcludedNamespaces(string);
        this.processVersionAttribute(string);
        this.processDefaultXPathNamespaceAttribute(string);
        this.processDefaultValidationAttribute(string);
        this.processExpandTextAttribute(string);
    }

    public String getAttributeValue(String object) {
        object = FingerprintedQName.fromClarkName((String)object);
        return ((NodeImpl)this).getAttributeValue(object.getURI(), object.getLocalPart());
    }

    protected final void processAttributes() {
        try {
            this.prepareAttributes();
            return;
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return;
        }
    }

    protected void checkUnknownAttribute(NodeName nodeName) {
        String string = nodeName.getURI();
        String string2 = this.getURI();
        String string3 = nodeName.getStructuredQName().getClarkName();
        if (this.forwardsCompatibleModeIsEnabled()) {
            return;
        }
        if (this.isInstruction() && string.equals("http://www.w3.org/1999/XSL/Transform") && !string2.equals("http://www.w3.org/1999/XSL/Transform") && (string3.endsWith("}default-collation") || string3.endsWith("}default-mode") || string3.endsWith("}xpath-default-namespace") || string3.endsWith("}expand-text") || string3.endsWith("}extension-element-prefixes") || string3.endsWith("}exclude-result-prefixes") || string3.endsWith("}version") || string3.endsWith("}default-validation") || string3.endsWith("}use-when"))) {
            return;
        }
        if (string2.equals("http://www.w3.org/1999/XSL/Transform") && (string3.equals("default-collation") || string3.equals("default-mode") || string3.equals("expand-text") || string3.equals("xpath-default-namespace") || string3.equals("extension-element-prefixes") || string3.equals("exclude-result-prefixes") || string3.equals("version") || string3.equals("default-validation") || string3.equals("use-when"))) {
            return;
        }
        if ("".equals(string) || "http://www.w3.org/1999/XSL/Transform".equals(string)) {
            this.compileErrorInAttribute("Attribute " + Err.wrap(nodeName.getDisplayName(), 2) + " is not allowed on element " + Err.wrap(this.getDisplayName(), 1), "XTSE0090", string3);
            return;
        }
        if ("http://saxon.sf.net/".equals(string)) {
            this.compileWarning("Unrecognized attribute in Saxon namespace: " + nodeName.getDisplayName(), "XTSE0090");
        }
    }

    protected abstract void prepareAttributes();

    protected StyleElement getLastChildInstruction() {
        NodeInfo nodeInfo;
        StyleElement styleElement = null;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = axisIterator.next()) != null) {
            if (nodeInfo instanceof StyleElement) {
                styleElement = (StyleElement)nodeInfo;
                continue;
            }
            styleElement = null;
        }
        return styleElement;
    }

    public Expression makeExpression(String string, int n2) {
        try {
            ExpressionContext expressionContext = this.staticContext;
            if (n2 >= 0) {
                StructuredQName structuredQName = this.getAttributeList().getNodeName(n2).getStructuredQName();
                expressionContext = this.getStaticContext(structuredQName);
            }
            return ExpressionTool.make(string, expressionContext, 0, 0, this.getCompilation().getCompilerInfo().getCodeInjector());
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetLocation(this.allocateLocation());
            if (xPathException2.isReportableStatically()) {
                this.compileError(xPathException2);
            }
            ErrorExpression errorExpression = new ErrorExpression(xPathException2);
            errorExpression.setRetainedStaticContext(this.makeRetainedStaticContext());
            errorExpression.setLocation(this.allocateLocation());
            return errorExpression;
        }
    }

    public Pattern makePattern(String object, String object2) {
        try {
            object2 = this.getStaticContext(new StructuredQName("", "", (String)object2));
            object = Pattern.make((String)object, (StaticContext)object2, this.getCompilation().getPackageData());
            ((Expression)object).setLocation(this.allocateLocation());
            return object;
        }
        catch (XPathException xPathException) {
            if ("XPST0003".equals(xPathException.getErrorCodeLocalPart())) {
                xPathException.setErrorCode("XTSE0340");
            }
            this.compileError(xPathException);
            object = new NodeTestPattern(AnyNodeTest.getInstance());
            ((Expression)object).setLocation(this.allocateLocation());
            return object;
        }
    }

    protected Expression makeAttributeValueTemplate(String string, int n2) {
        ExpressionContext expressionContext;
        ExpressionContext expressionContext2;
        if (n2 == -1) {
            expressionContext2 = this.staticContext;
        } else {
            StyleElement styleElement = this;
            expressionContext2 = expressionContext = styleElement.getStaticContext(styleElement.getAttributeList().getNodeName(n2).getStructuredQName());
        }
        if (n2 >= 0) {
            StructuredQName structuredQName = this.getAttributeList().getNodeName(n2).getStructuredQName();
            expressionContext = this.getStaticContext(structuredQName);
        }
        try {
            return AttributeValueTemplate.make(string, expressionContext);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return new StringLiteral(string);
        }
    }

    protected void checkAttributeValue(String string, String charSequence, boolean bl2, String[] stringArray) {
        if (bl2 && ((String)charSequence).contains("{")) {
            return;
        }
        if (Arrays.binarySearch(stringArray, charSequence) < 0) {
            charSequence = new FastStringBuffer(64);
            ((FastStringBuffer)charSequence).append("Invalid value for ");
            ((FastStringBuffer)charSequence).append("@");
            ((FastStringBuffer)charSequence).append(string);
            ((FastStringBuffer)charSequence).append(". Value must be one of (");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                ((FastStringBuffer)charSequence).append(i2 == 0 ? "" : "|");
                ((FastStringBuffer)charSequence).append(stringArray[i2]);
            }
            ((FastStringBuffer)charSequence).append(")");
            this.compileError(((FastStringBuffer)charSequence).toString(), "XTSE0020");
        }
    }

    public boolean processBooleanAttribute(String string, String string2) {
        if (StyleElement.a(string2 = Whitespace.trim(string2))) {
            return true;
        }
        if ("no".equals(string2) || "false".equals(string2) || "0".equals(string2)) {
            return false;
        }
        this.invalidAttribute(string, "yes|no | true|false | 1|0");
        return false;
    }

    static boolean a(String string) {
        return "yes".equals(string) || "true".equals(string) || "1".equals(string);
    }

    final boolean b(String string) {
        boolean bl2 = this.processBooleanAttribute("streamable", string);
        if (bl2) {
            if (!((NodeImpl)this).getConfiguration().isLicensedFeature(2)) {
                this.compileWarning("Request for streaming ignored: this Saxon configuration does not support streaming", "SXST0068");
                return false;
            }
            if ("off".equals(((NodeImpl)this).getConfiguration().getConfigurationProperty(Feature.STREAMABILITY))) {
                this.compileWarning("Request for streaming ignored: streaming is disabled in this Saxon configuration", "SXST0068");
                return false;
            }
        }
        return bl2;
    }

    public SequenceType makeSequenceType(String string) {
        ExpressionContext expressionContext = this.getStaticContext();
        int n2 = expressionContext.getXPathVersion();
        if (n2 == 30) {
            n2 = 305;
        }
        XPathParser xPathParser = ((NodeImpl)this).getConfiguration().newExpressionParser("XP", false, n2);
        QNameParser qNameParser = new QNameParser(this.staticContext.getNamespaceResolver());
        qNameParser.setAcceptEQName(this.staticContext.getXPathVersion() >= 30);
        qNameParser.setDefaultNamespace("");
        qNameParser.setErrorOnBadSyntax("XPST0003");
        qNameParser.setErrorOnUnresolvedPrefix("XPST0081");
        xPathParser.setQNameParser(qNameParser);
        return xPathParser.parseSequenceType(string, this.staticContext);
    }

    public SequenceType makeExtendedSequenceType(String string) {
        this.getStaticContext();
        XPathParser xPathParser = ((NodeImpl)this).getConfiguration().newExpressionParser("XP", false, 31);
        QNameParser qNameParser = new QNameParser(this.staticContext.getNamespaceResolver());
        qNameParser.setAcceptEQName(this.staticContext.getXPathVersion() >= 30);
        qNameParser.setDefaultNamespace("");
        qNameParser.setErrorOnBadSyntax("XPST0003");
        qNameParser.setErrorOnUnresolvedPrefix("XPST0081");
        xPathParser.setQNameParser(qNameParser);
        return xPathParser.parseExtendedSequenceType(string, this.staticContext);
    }

    protected void processExtensionElementAttribute(String object) {
        if ((object = ((NodeImpl)this).getAttributeValue((String)object, "extension-element-prefixes")) != null) {
            int n2 = 0;
            Object object2 = new StringTokenizer((String)object, " \t\n\r", false);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                ((StringTokenizer)object2).nextToken();
                ++n2;
            }
            this.extensionNamespaces = new String[n2];
            n2 = 0;
            object = new StringTokenizer((String)object, " \t\n\r", false);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string;
                object2 = ((StringTokenizer)object).nextToken();
                if ("#default".equals(object2)) {
                    object2 = "";
                }
                if ((string = this.getURIForPrefix((String)object2, false)) == null) {
                    this.compileError("Namespace prefix " + (String)object2 + " is undeclared", "XTSE1430");
                    this.extensionNamespaces[n2++] = "http://saxon.sf.net/";
                    continue;
                }
                if (NamespaceConstant.isReserved(string)) {
                    this.compileError("Namespace " + string + " is reserved: it cannot be used for extension instructions (perhaps exclude-result-prefixes was intended).", "XTSE0085");
                    this.extensionNamespaces[n2++] = "http://saxon.sf.net/";
                    continue;
                }
                this.extensionNamespaces[n2++] = string;
            }
        }
    }

    protected void processExcludedNamespaces(String object) {
        if ((object = ((NodeImpl)this).getAttributeValue((String)object, "exclude-result-prefixes")) != null) {
            if ("#all".equals(Whitespace.trim((CharSequence)object))) {
                Iterator<NamespaceBinding> iterator = NamespaceIterator.iterateNamespaces(this);
                ArrayList<String> arrayList = new ArrayList<String>();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next().getURI());
                }
                this.a = arrayList.toArray(new String[0]);
                return;
            }
            int n2 = 0;
            Object object2 = new StringTokenizer((String)object, " \t\n\r", false);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                ((StringTokenizer)object2).nextToken();
                ++n2;
            }
            this.a = new String[n2];
            n2 = 0;
            object = new StringTokenizer((String)object, " \t\n\r", false);
            while (((StringTokenizer)object).hasMoreTokens()) {
                object2 = ((StringTokenizer)object).nextToken();
                if ("#default".equals(object2)) {
                    object2 = "";
                } else if ("#all".equals(object2)) {
                    this.compileError("In exclude-result-prefixes, cannot mix #all with other values", "XTSE0020");
                }
                String string = this.getURIForPrefix((String)object2, true);
                if (string == null) {
                    this.a = null;
                    this.compileError("Namespace prefix " + (String)object2 + " is not declared", "XTSE0808");
                    return;
                }
                this.a[n2++] = string;
                if (!((String)object2).isEmpty() || !string.isEmpty()) continue;
                this.compileError("Cannot exclude the #default namespace when no default namespace is declared", "XTSE0809");
            }
        }
    }

    protected void processVersionAttribute(String object) {
        if ((object = Whitespace.trim(((NodeImpl)this).getAttributeValue((String)object, "version"))) != null) {
            if ((object = BigDecimalValue.makeDecimalValue((CharSequence)object, true)) instanceof ValidationFailure) {
                this.version = 30;
                this.compileError("The version attribute must be a decimal literal", "XTSE0110");
                return;
            }
            this.version = ((NumericValue)((BigDecimalValue)object)).getDecimalValue().multiply(BigDecimal.TEN).intValue();
            if (this.version < 20 && this.version != 10) {
                this.issueWarning("Unrecognized version " + object + ": treated as 1.0", this);
                this.version = 10;
                return;
            }
            if (this.version > 20 && this.version < 30) {
                this.issueWarning("Unrecognized version " + object + ": treated as 2.0", this);
                this.version = 20;
            }
        }
    }

    public int getEffectiveVersion() {
        if (this.version == -1) {
            NodeImpl nodeImpl = this.getParent();
            if (nodeImpl instanceof StyleElement) {
                this.version = ((StyleElement)nodeImpl).getEffectiveVersion();
            } else {
                return 20;
            }
        }
        return this.version;
    }

    public String getEffectiveVersionAsString() {
        return Double.toString(this.getEffectiveVersion() / 10);
    }

    protected int validateValidationAttribute(String string) {
        int n2 = Validation.getCode(string);
        if (n2 == -1) {
            String string2 = this instanceof LiteralResultElement ? "xsl:" : "";
            this.compileError("Invalid value of " + string2 + "validation attribute: '" + string + "'", "XTSE0020");
            n2 = this.getDefaultValidation();
        }
        if (!this.isSchemaAware()) {
            if (n2 == 1) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
            }
            n2 = 4;
        }
        return n2;
    }

    public boolean forwardsCompatibleModeIsEnabled() {
        return this.getEffectiveVersion() > 30;
    }

    public boolean xPath10ModeIsEnabled() {
        return this.getEffectiveVersion() < 20;
    }

    protected void processDefaultCollationAttribute() {
        String string = this.getURI().equals("http://www.w3.org/1999/XSL/Transform") ? "" : "http://www.w3.org/1999/XSL/Transform";
        Object object = ((NodeImpl)this).getAttributeValue(string, "default-collation");
        StringBuilder stringBuilder = new StringBuilder();
        if (object != null) {
            String string2;
            object = new StringTokenizer((String)object, " \t\n\r", false);
            while (((StringTokenizer)object).hasMoreTokens()) {
                string2 = ((StringTokenizer)object).nextToken();
                if (string2.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
                    this.defaultCollationName = string2;
                    return;
                }
                try {
                    URI uRI = new URI(string2);
                    if (!uRI.isAbsolute()) {
                        URI uRI2 = new URI(((NodeImpl)this).getBaseURI());
                        uRI = uRI2.resolve(uRI);
                        string2 = uRI.toString();
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.compileError("default collation '" + string2 + "' is not a valid URI");
                    string2 = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
                }
                try {
                    if (((NodeImpl)this).getConfiguration().getCollation(string2) != null) {
                        this.defaultCollationName = string2;
                        return;
                    }
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append("; ");
                    }
                    stringBuilder.append("Collation ").append(string2).append(" is not recognized");
                }
                catch (XPathException xPathException) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append("; ");
                    }
                    stringBuilder.append("Collation ").append(string2).append(" is not recognized (").append(xPathException.getMessage()).append(")");
                }
            }
            string2 = "No recognized collation URI found in default-collation attribute";
            if (stringBuilder.length() != 0) {
                string2 = string2 + ". ";
                string2 = string2 + stringBuilder.toString();
            }
            this.compileErrorInAttribute(string2, "XTSE0125", new StructuredQName("", string, "default-collation").getClarkName());
        }
    }

    protected String getDefaultCollationName() {
        NodeImpl nodeImpl = this;
        do {
            if (nodeImpl.defaultCollationName == null) continue;
            return nodeImpl.defaultCollationName;
        } while ((nodeImpl = nodeImpl.getParent()) instanceof StyleElement);
        return ((NodeImpl)this).getConfiguration().getDefaultCollationName();
    }

    public StringCollator findCollation(String string, String string2) {
        return ((NodeImpl)this).getConfiguration().getCollation(string, string2);
    }

    protected void processDefaultMode() {
        Object object = this.getURI().equals("http://www.w3.org/1999/XSL/Transform") ? "" : "http://www.w3.org/1999/XSL/Transform";
        if ((object = ((NodeImpl)this).getAttributeValue((String)object, "default-mode")) != null) {
            this.defaultMode = ((String)object).equals("#unnamed") ? Mode.UNNAMED_MODE_NAME : this.makeQName((String)object);
        }
        object = this.d.getPrincipalStylesheetModule();
        StructuredQName structuredQName = this.defaultMode;
        if (object != null && ((PrincipalStylesheetModule)object).isDeclaredModes()) {
            ((PrincipalStylesheetModule)object).addFixupAction(() -> this.a((PrincipalStylesheetModule)object, structuredQName));
        }
    }

    public StructuredQName getDefaultMode() {
        if (this.defaultMode == null) {
            this.processDefaultMode();
            if (this.defaultMode == null) {
                NodeImpl nodeImpl = this.getParent();
                if (nodeImpl instanceof StyleElement) {
                    this.defaultMode = ((StyleElement)nodeImpl).getDefaultMode();
                    return this.defaultMode;
                }
                this.defaultMode = Mode.UNNAMED_MODE_NAME;
                return this.defaultMode;
            }
        }
        return this.defaultMode;
    }

    protected boolean definesExtensionElement(String string) {
        if (this.extensionNamespaces == null) {
            return false;
        }
        String[] stringArray = this.extensionNamespaces;
        int n2 = this.extensionNamespaces.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isExtensionNamespace(String string) {
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof StyleElement) {
            if (nodeInfo.definesExtensionElement(string)) {
                return true;
            }
            nodeInfo = nodeInfo.getParent();
        }
        return false;
    }

    protected boolean definesExcludedNamespace(String string) {
        if (this.a == null) {
            return false;
        }
        String[] stringArray = this.a;
        int n2 = this.a.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isExcludedNamespace(String string) {
        if (string.equals("http://www.w3.org/1999/XSL/Transform") || string.equals("http://www.w3.org/XML/1998/namespace")) {
            return true;
        }
        if (this.isExtensionNamespace(string)) {
            return true;
        }
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof StyleElement) {
            if (nodeInfo.definesExcludedNamespace(string)) {
                return true;
            }
            nodeInfo = nodeInfo.getParent();
        }
        return false;
    }

    protected void processDefaultXPathNamespaceAttribute(String string) {
        if ((string = ((NodeImpl)this).getAttributeValue(string, "xpath-default-namespace")) != null) {
            this.defaultXPathNamespace = string;
        }
    }

    public String getDefaultXPathNamespace() {
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof StyleElement) {
            String string = nodeInfo.defaultXPathNamespace;
            if (string != null) {
                return string;
            }
            nodeInfo = nodeInfo.getParent();
        }
        return "";
    }

    protected void processExpandTextAttribute(String object) {
        boolean bl2;
        StyleElement styleElement;
        if ((object = ((NodeImpl)this).getAttributeValue((String)object, "expand-text")) != null) {
            StyleElement styleElement2 = this;
            styleElement = styleElement2;
            bl2 = styleElement2.processBooleanAttribute("expand-text", (String)object);
        } else {
            object = this.getParent();
            styleElement = this;
            bl2 = object instanceof StyleElement && ((StyleElement)object).expandText;
        }
        styleElement.expandText = bl2;
    }

    protected void processDefaultValidationAttribute(String string) {
        if ((string = ((NodeImpl)this).getAttributeValue(string, "default-validation")) != null) {
            int n2 = Validation.getCode(string);
            if (n2 == 4 || n2 == 3) {
                this.f = n2;
                return;
            }
            this.compileErrorInAttribute("@default-validation must be preserve|strip", "XTSE0020", "default-validation");
        }
    }

    public boolean isExpandingText() {
        return this.expandText;
    }

    public SchemaType getSchemaType(String string) {
        String string2;
        Object object;
        Object object2;
        block11: {
            try {
                if (string.startsWith("Q{")) {
                    object2 = this.makeQName(string);
                    object = ((StructuredQName)object2).getURI();
                    string2 = ((StructuredQName)object2).getLocalPart();
                } else {
                    object2 = NameChecker.getQNameParts(string);
                    string2 = object2[1];
                    if ("".equals(object2[0])) {
                        object = this.getDefaultXPathNamespace();
                    } else {
                        object = this.getURIForPrefix((String)object2[0], false);
                        if (object == null) {
                            this.compileError("Namespace prefix for type annotation is undeclared", "XTSE1520");
                            return null;
                        }
                    }
                }
                if (!((String)object).equals("http://www.w3.org/2001/XMLSchema")) break block11;
                object2 = BuiltInType.getSchemaTypeByLocalName(string2);
                if (object2 == null) {
                    this.compileError("Unknown built-in type " + string, "XTSE1520");
                    return null;
                }
                return object2;
            }
            catch (QNameException qNameException) {
                this.compileError("Invalid type name. " + qNameException.getMessage(), "XTSE1520");
                return null;
            }
        }
        if (!this.getPrincipalStylesheetModule().isImportedSchema((String)object)) {
            this.compileError("There is no imported schema for the namespace of type " + string, "XTSE1520");
            return null;
        }
        object2 = new StructuredQName("", (String)object, string2);
        object = ((NodeImpl)this).getConfiguration().getSchemaType((StructuredQName)object2);
        if (object == null) {
            this.compileError("There is no type named " + string + " in an imported schema", "XTSE1520");
        }
        return object;
    }

    public SimpleType getTypeAnnotation(SchemaType schemaType) {
        return (SimpleType)schemaType;
    }

    public void validate(ComponentDeclaration componentDeclaration) {
    }

    public void postValidate() {
    }

    public void index(ComponentDeclaration componentDeclaration, PrincipalStylesheetModule principalStylesheetModule) {
    }

    public Expression typeCheck(String object, Expression expression) {
        if (expression == null) {
            return null;
        }
        Object object2 = ((NodeImpl)this).getConfiguration();
        if (((Configuration)object2).getBooleanProperty(Feature.STRICT_STREAMABILITY)) {
            return expression;
        }
        try {
            expression = expression.typeCheck(this.makeExpressionVisitor(), ((Configuration)object2).makeContextItemStaticInfo(Type.ITEM_TYPE, true));
            expression = ExpressionTool.resolveCallsToCurrentFunction(expression);
            object2 = this.getCompilation().getCompilerInfo().getCodeInjector();
            if (object2 != null) {
                return object2.inject(expression, this.getStaticContext(), 2011, new StructuredQName("", "", (String)object));
            }
            return expression;
        }
        catch (XPathException xPathException) {
            object2 = xPathException;
            if (xPathException.isReportableStatically()) {
                ((XPathException)object2).setLocation(new AttributeLocation(this, StructuredQName.fromClarkName((String)object)));
                this.compileError((XPathException)object2);
                return expression;
            }
            object = new ErrorExpression((XPathException)object2);
            ExpressionTool.copyLocationInfo(expression, (Expression)object);
            return object;
        }
    }

    public void allocateLocalSlots(Expression expression) {
        SlotManager slotManager = this.getContainingSlotManager();
        if (slotManager == null) {
            throw new AssertionError((Object)"Slot manager has not been allocated");
        }
        int n2 = slotManager.getNumberOfVariables();
        int n3 = ExpressionTool.allocateSlots(expression, n2, slotManager);
        if (n3 > n2) {
            slotManager.setNumberOfVariables(n3);
        }
    }

    public Pattern typeCheck(String string, Pattern object) {
        if (object == null) {
            return null;
        }
        try {
            Object object2 = Type.ITEM_TYPE;
            object = ((Pattern)object).typeCheck(this.makeExpressionVisitor(), ((NodeImpl)this).getConfiguration().makeContextItemStaticInfo((ItemType)object2, true));
            boolean bl2 = false;
            for (Operand operand : ((Expression)object).operands()) {
                Expression object3 = operand.getChildExpression();
                if (!ExpressionTool.callsFunction(object3, Current.FN_CURRENT, false)) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                object2 = new PatternThatSetsCurrent((Pattern)object);
                ((Pattern)object).bindCurrent(((PatternThatSetsCurrent)object2).getCurrentBinding());
                object = object2;
            }
            return object;
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            if (xPathException.isReportableStatically()) {
                XPathException xPathException3 = new XPathException("Error in " + string + " pattern", xPathException2);
                xPathException3.setLocator(this);
                xPathException3.setErrorCodeQName(xPathException2.getErrorCodeQName());
                throw xPathException3;
            }
            BasePatternWithPredicate basePatternWithPredicate = new BasePatternWithPredicate(new NodeTestPattern(ErrorType.getInstance()), new ErrorExpression(xPathException2));
            basePatternWithPredicate.setLocation(this.allocateLocation());
            return basePatternWithPredicate;
        }
    }

    public void fixupReferences() {
        this.iterateAxis((byte)3).forEachOrFail(nodeInfo -> {
            if (nodeInfo instanceof StyleElement) {
                ((StyleElement)nodeInfo).fixupReferences();
            }
        });
    }

    public SlotManager getContainingSlotManager() {
        NodeImpl nodeImpl = this;
        while (true) {
            NodeImpl nodeImpl2 = nodeImpl.getParent();
            assert (nodeImpl2 != null);
            if (nodeImpl2 instanceof XSLModuleRoot || nodeImpl2.getFingerprint() == 186) {
                if (nodeImpl instanceof StylesheetComponent) {
                    return ((StylesheetComponent)((Object)nodeImpl)).getSlotManager();
                }
                return null;
            }
            nodeImpl = nodeImpl2;
        }
    }

    public void validateSubtree(ComponentDeclaration componentDeclaration, boolean bl2) {
        if (this.isActionCompleted(1)) {
            return;
        }
        this.setActionCompleted(1);
        if (this.validationError != null) {
            if (this.reportingCircumstances == 1) {
                StyleElement styleElement = this;
                styleElement.compileError(styleElement.validationError);
                return;
            }
            if (this.reportingCircumstances == 2 && !this.forwardsCompatibleModeIsEnabled()) {
                StyleElement styleElement = this;
                styleElement.compileError(styleElement.validationError);
                return;
            }
            if (this.reportingCircumstances == 4) {
                NodeInfo nodeInfo2;
                boolean bl3 = false;
                AxisIterator axisIterator = this.iterateAxis((byte)3);
                while ((nodeInfo2 = axisIterator.next()) != null) {
                    if (!(nodeInfo2 instanceof XSLFallback)) continue;
                    bl3 = true;
                    ((XSLFallback)nodeInfo2).validateSubtree(componentDeclaration, false);
                }
                if (!bl3) {
                    StyleElement styleElement = this;
                    styleElement.compileError(styleElement.validationError);
                }
                return;
            }
            if (this.reportingCircumstances == 5) {
                this.iterateAxis((byte)3).forEachOrFail(nodeInfo -> {
                    if (nodeInfo instanceof XSLFallback) {
                        ((XSLFallback)nodeInfo).validateSubtree(componentDeclaration, false);
                    }
                });
                return;
            }
        } else {
            try {
                this.validate(componentDeclaration);
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
            this.validateChildren(componentDeclaration, bl2);
            if (this.getCompilation().getErrorCount() == 0) {
                this.postValidate();
            }
        }
    }

    protected void validateChildren(ComponentDeclaration componentDeclaration, boolean bl2) {
        NodeInfo nodeInfo;
        boolean bl3 = this.mayContainSequenceConstructor();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        StyleElement styleElement = null;
        boolean bl4 = false;
        while ((nodeInfo = axisIterator.next()) != null) {
            boolean bl5;
            if (nodeInfo instanceof StyleElement) {
                if (bl2 && nodeInfo instanceof XSLStylesheet) continue;
                bl4 = false;
                if (bl3 && !((StyleElement)nodeInfo).isInstruction() && !this.isPermittedChild((StyleElement)nodeInfo)) {
                    ((StyleElement)nodeInfo).compileError("An " + this.getDisplayName() + " element must not contain an " + nodeInfo.getDisplayName() + " element", "XTSE0010");
                }
                ((StyleElement)nodeInfo).validateSubtree(componentDeclaration, bl2);
                styleElement = (StyleElement)nodeInfo;
                continue;
            }
            NodeInfo nodeInfo2 = nodeInfo;
            if (nodeInfo2 instanceof TextValueTemplateNode) {
                ((TextValueTemplateNode)nodeInfo2).validate();
                bl5 = !(((TextValueTemplateNode)nodeInfo2).getContentExpression() instanceof Literal);
            } else {
                bl5 = false;
            }
            bl4 = bl5;
        }
        if (styleElement instanceof XSLLocalVariable && !(this instanceof XSLStylesheet) && !bl4) {
            styleElement.compileWarning("A variable with no following sibling instructions has no effect", "SXWN9001");
        }
    }

    protected boolean isPermittedChild(StyleElement styleElement) {
        return false;
    }

    public PrincipalStylesheetModule getPrincipalStylesheetModule() {
        return this.getCompilation().getPrincipalStylesheetModule();
    }

    public StylesheetPackage getContainingPackage() {
        PrincipalStylesheetModule principalStylesheetModule = this.getPrincipalStylesheetModule();
        if (principalStylesheetModule == null) {
            return null;
        }
        return principalStylesheetModule.getStylesheetPackage();
    }

    protected void checkSortComesFirst(boolean bl2) {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        boolean bl3 = false;
        boolean bl4 = false;
        while ((nodeInfo = axisIterator.next()) != null) {
            if (nodeInfo instanceof XSLSort) {
                if (bl4) {
                    ((XSLSort)nodeInfo).compileError("Within " + this.getDisplayName() + ", xsl:sort elements must come before other instructions", "XTSE0010");
                }
                bl3 = true;
                continue;
            }
            if (nodeInfo.getNodeKind() == 3) {
                if (Whitespace.isWhite(nodeInfo.getStringValueCS())) continue;
                bl4 = true;
                continue;
            }
            bl4 = true;
        }
        if (bl2 && !bl3) {
            this.compileError(this.getDisplayName() + " must have at least one xsl:sort child", "XTSE0010");
        }
    }

    public void checkTopLevel(String string, boolean bl2) {
        NodeImpl nodeImpl = this.getParent();
        assert (nodeImpl != null);
        if (nodeImpl.getFingerprint() == 186) {
            if (!bl2) {
                this.compileError("Element " + this.getDisplayName() + " is not allowed as a child of xsl:override");
                return;
            }
        } else if (!this.isTopLevel()) {
            this.compileError("Element " + this.getDisplayName() + " must be top-level (a child of xsl:stylesheet, xsl:transform, or xsl:package)", string);
        }
    }

    public void checkEmpty() {
        if (((NodeImpl)this).hasChildNodes()) {
            this.compileError("Element must be empty", "XTSE0260");
        }
    }

    public void reportAbsence(String string) {
        this.compileError("Element must have an " + Err.wrap(string, 2) + " attribute", "XTSE0010");
    }

    public Expression compile(Compilation compilation, ComponentDeclaration componentDeclaration) {
        return null;
    }

    protected boolean isWithinDeclaredStreamableConstruct() {
        Object object = this.getAttributeValue("streamable");
        if (object != null) {
            return this.b((String)object);
        }
        object = this.getParent();
        return object instanceof StyleElement && ((StyleElement)object).isWithinDeclaredStreamableConstruct();
    }

    protected String generateId() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        ((NodeImpl)this).generateId(fastStringBuffer);
        return fastStringBuffer.toString();
    }

    public void compileDeclaration(Compilation compilation, ComponentDeclaration componentDeclaration) {
    }

    public Expression compileSequenceConstructor(Compilation compilation, ComponentDeclaration componentDeclaration, boolean bl2) {
        Iterable<NodeInfo> iterable;
        boolean bl3 = false;
        Object object = this.iterateAxis((byte)3);
        while ((iterable = object.next()) != null) {
            int n2 = iterable.getFingerprint();
            if (n2 != 183 && n2 != 184) continue;
            bl3 = true;
        }
        if (bl3) {
            iterable = new ArrayList();
            ArrayList arrayList = new ArrayList();
            object = new ArrayList();
            this.iterateAxis((byte)3).forEach(arg_0 -> StyleElement.a((List)iterable, arrayList, (List)object, arg_0));
            iterable.addAll(object);
            iterable.addAll(arrayList);
            return this.compileSequenceConstructor(compilation, componentDeclaration, new ListIterator<NodeInfo>((List<NodeInfo>)iterable), bl2);
        }
        return this.compileSequenceConstructor(compilation, componentDeclaration, this.iterateAxis((byte)3), bl2);
    }

    public Expression compileSequenceConstructor(Compilation compilation, ComponentDeclaration componentDeclaration, SequenceIterator sequenceIterator, boolean bl2) {
        Object object;
        Object object2;
        Location location = this.allocateLocation();
        ArrayList<Expression> arrayList = new ArrayList<Expression>(10);
        boolean bl3 = false;
        while ((object2 = (NodeInfo)sequenceIterator.next()) != null) {
            Object object3;
            Object object4;
            if (object2.getNodeKind() == 3) {
                if (this.isExpandingText()) {
                    this.compileContentValueTemplate((TextImpl)object2, arrayList);
                    continue;
                }
                object = object2.iterateAxis((byte)7);
                NodeInfo nodeInfo = object.next();
                if (nodeInfo instanceof XSLLocalParam || nodeInfo instanceof XSLSort || nodeInfo instanceof XSLContextItem || nodeInfo instanceof XSLOnCompletion) continue;
                object4 = new ValueOf(new StringLiteral(object2.getStringValue()), false, false);
                ((Expression)object4).setLocation(this.allocateLocation());
                object3 = this.getCompilation().getCompilerInfo().getCodeInjector();
                if (object3 != null) {
                    object2 = object3.inject((Expression)object4, this.getStaticContext(), 201, null);
                    ((Expression)object2).setLocation(((Expression)object4).getLocation());
                    object4 = object2;
                }
                arrayList.add((Expression)object4);
                continue;
            }
            if (object2 instanceof XSLLocalVariable) {
                object = (XSLLocalVariable)object2;
                SourceBinding sourceBinding = ((XSLGeneralVariable)object).getSourceBinding();
                ((XSLLocalVariable)object).compileLocalVariable(compilation, componentDeclaration);
                object4 = this.compileSequenceConstructor(compilation, componentDeclaration, sequenceIterator, bl2);
                if (object4 == null || Literal.isEmptySequence((Expression)object4)) continue;
                object3 = new LetExpression();
                ((LetExpression)object3).setInstruction(true);
                ((Assignation)object3).setRequiredType(((XSLLocalVariable)object).getRequiredType());
                ((Assignation)object3).setVariableQName(sourceBinding.getVariableQName());
                ((Assignation)object3).setSequence(sourceBinding.getSelectExpression());
                ((Assignation)object3).setAction((Expression)object4);
                sourceBinding.fixupBinding((Binding)object3);
                location = ((StyleElement)object2).allocateLocation();
                ((Expression)object3).setLocation(location);
                if (this.getCompilation().getCompilerInfo().isCompileWithTracing()) {
                    object2 = new TraceExpression((Expression)object3);
                    ((TraceExpression)object2).setConstructType(2013);
                    ((TraceExpression)object2).setObjectName(((XSLGeneralVariable)object).getSourceBinding().getVariableQName());
                    ((TraceExpression)object2).setNamespaceResolver(this.getNamespaceResolver());
                    arrayList.add((Expression)object2);
                } else {
                    arrayList.add((Expression)object3);
                }
                if (!((StyleElement)object).changesRetainedStaticContext()) continue;
                ((Expression)object3).setRetainedStaticContext(this.makeRetainedStaticContext());
                continue;
            }
            if (!(object2 instanceof StyleElement)) continue;
            object = (StyleElement)object2;
            int n2 = ((NodeImpl)object).getFingerprint();
            if (n2 == 183 || n2 == 184) {
                bl3 = true;
            }
            if (((StyleElement)object).validationError != null && !(object instanceof AbsentExtensionElement)) {
                object4 = ((StyleElement)object).reportingCircumstances == 3 ? new ErrorExpression(((StyleElement)object).validationError) : this.fallbackProcessing(compilation, componentDeclaration, (StyleElement)object);
            } else {
                object4 = ((StyleElement)object).compile(compilation, componentDeclaration);
                if (object4 != null) {
                    if (((StyleElement)object).changesRetainedStaticContext()) {
                        ((Expression)object4).setRetainedStaticContext(((StyleElement)object).makeRetainedStaticContext());
                    }
                    if ((bl2 || !(object2 instanceof XSLLocalParam)) && this.getCompilation().getCompilerInfo().isCompileWithTracing()) {
                        object4 = StyleElement.makeTraceInstruction((StyleElement)object, (Expression)object4);
                    }
                }
            }
            if (object4 == null) continue;
            arrayList.add((Expression)object4);
        }
        if (bl3) {
            return new ConditionalBlock(arrayList);
        }
        object = Block.makeBlock(arrayList);
        if (((Expression)object).getLocation() == null) {
            ((Expression)object).setLocation(location);
        }
        if (((Expression)object).getLocalRetainedStaticContext() == null) {
            ((Expression)object).setRetainedStaticContext(this.makeRetainedStaticContext());
        }
        return object;
    }

    public void compileContentValueTemplate(TextImpl object, List<Expression> list) {
        if (object instanceof TextValueTemplateNode) {
            object = ((TextValueTemplateNode)object).getContentExpression();
            if (((NodeImpl)this).getConfiguration().getBooleanProperty(Feature.STRICT_STREAMABILITY) && !(object instanceof Literal)) {
                object = new SequenceInstr((Expression)object);
            }
            list.add((Expression)object);
            return;
        }
        list.add(new StringLiteral(((TextImpl)object).getStringValue()));
    }

    protected static Expression makeTraceInstruction(StyleElement styleElement, Expression expression) {
        if (expression instanceof TraceExpression && !(styleElement instanceof StylesheetComponent)) {
            return expression;
        }
        if (styleElement instanceof XSLOnEmpty || styleElement instanceof XSLOnNonEmpty) {
            return expression;
        }
        CodeInjector codeInjector = styleElement.getCompilation().getCompilerInfo().getCodeInjector();
        if (codeInjector != null) {
            int n2 = styleElement.getFingerprint();
            if (styleElement instanceof LiteralResultElement) {
                n2 = 2006;
            }
            expression = codeInjector.inject(expression, styleElement.getStaticContext(), n2, styleElement.getObjectName());
            expression.setLocation(styleElement.allocateLocation());
            return expression;
        }
        return expression;
    }

    protected Expression fallbackProcessing(Compilation compilation, ComponentDeclaration componentDeclaration, StyleElement styleElement) {
        Object object;
        Object object2 = null;
        AxisIterator axisIterator = styleElement.iterateAxis((byte)3);
        while ((object = axisIterator.next()) != null) {
            if (!(object instanceof XSLFallback)) continue;
            if ((object = ((XSLFallback)object).compileSequenceConstructor(compilation, componentDeclaration, true)) == null) {
                object = Literal.makeEmptySequence();
            }
            if (object2 == null) {
                object2 = object;
                continue;
            }
            object2 = Block.makeBlock((Expression)object2, (Expression)object);
            ((Expression)object2).setLocation(this.allocateLocation());
        }
        if (object2 != null) {
            return object2;
        }
        return new ErrorExpression(styleElement.validationError);
    }

    protected Location allocateLocation() {
        if (this.e == null) {
            this.e = new ExplicitLocation(this);
        }
        return this.e;
    }

    public SortKeyDefinitionList makeSortKeys(Compilation sortKeyDefinitionArray, ComponentDeclaration componentDeclaration) {
        NodeInfo nodeInfo;
        int n2 = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = axisIterator.next()) != null) {
            if (!(nodeInfo instanceof XSLSortOrMergeKey)) continue;
            ((StyleElement)((XSLSortOrMergeKey)nodeInfo)).compile((Compilation)sortKeyDefinitionArray, componentDeclaration);
            if (nodeInfo instanceof XSLSort && n2 != 0 && ((XSLSort)nodeInfo).getStable() != null) {
                this.compileError("stable attribute may appear only on the first xsl:sort element", "XTSE1017");
            }
            ++n2;
        }
        if (n2 > 0) {
            sortKeyDefinitionArray = new SortKeyDefinition[n2];
            axisIterator = this.iterateAxis((byte)3);
            int n3 = 0;
            while ((nodeInfo = axisIterator.next()) != null) {
                if (!(nodeInfo instanceof XSLSortOrMergeKey)) continue;
                sortKeyDefinitionArray[n3++] = (SortKeyDefinition)((XSLSortOrMergeKey)nodeInfo).getSortKeyDefinition().simplify();
            }
            return new SortKeyDefinitionList(sortKeyDefinitionArray);
        }
        return null;
    }

    protected StructuredQName[] getUsedAttributeSets(String object) {
        ArrayList<Object> arrayList = new ArrayList<Object>(4);
        object = new StringTokenizer((String)object, " \t\n\r", false);
        while (((StringTokenizer)object).hasMoreTokens()) {
            Object object2 = ((StringTokenizer)object).nextToken();
            try {
                object2 = this.makeQName((String)object2);
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException.getMessage(), "XTSE0710");
                object2 = null;
            }
            arrayList.add(object2);
        }
        return arrayList.toArray(new StructuredQName[0]);
    }

    protected Visibility interpretVisibilityValue(String string, String string2) {
        for (Visibility visibility : Visibility.values()) {
            if (!visibility.visibilityStr.equals(string) || !string2.contains("h") && string.equals("hidden") || !string2.contains("a") && string.equals("absent")) continue;
            return visibility;
        }
        this.invalidAttribute("visibility", "public|final|private|abstract" + (string2.contains("h") ? "|hidden" : "") + (string2.contains("a") ? "|absent" : ""));
        return null;
    }

    public WithParam[] getWithParamInstructions(Expression expression, Compilation compilation, ComponentDeclaration componentDeclaration, boolean bl2) {
        WithParam[] withParamArray;
        NodeInfo nodeInfo;
        int n2 = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = axisIterator.next()) != null) {
            if (!(nodeInfo instanceof XSLWithParam) || (withParamArray = (XSLWithParam)nodeInfo).getSourceBinding().hasProperty(8) != bl2) continue;
            ++n2;
        }
        if (n2 == 0) {
            return WithParam.EMPTY_ARRAY;
        }
        withParamArray = new WithParam[n2];
        n2 = 0;
        axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = axisIterator.next()) != null) {
            if (!(nodeInfo instanceof XSLWithParam) || ((XSLGeneralVariable)(nodeInfo = (XSLWithParam)nodeInfo)).getSourceBinding().hasProperty(8) != bl2) continue;
            WithParam withParam = ((XSLWithParam)nodeInfo).compileWithParam(expression, compilation, componentDeclaration);
            if (((NodeImpl)nodeInfo).getParent() instanceof XSLNextIteration && ((NodeImpl)nodeInfo).hasChildNodes()) {
                SequenceType sequenceType = ((XSLNextIteration)((NodeImpl)nodeInfo).getParent()).getDeclaredParamType(((XSLGeneralVariable)nodeInfo).getSourceBinding().getVariableQName());
                ((XSLWithParam)nodeInfo).checkAgainstRequiredType(sequenceType);
                withParam.getSelectOperand().setChildExpression(((XSLGeneralVariable)nodeInfo).sourceBinding.getSelectExpression());
            }
            withParamArray[n2++] = withParam;
        }
        return withParamArray;
    }

    public void compileError(XPathException xPathException) {
        Location location;
        xPathException.setIsStaticError(true);
        if (xPathException.getLocator() == null || (xPathException.getLocator() instanceof ExplicitLocation || xPathException.getLocator() instanceof Expression) && !(this instanceof StylesheetComponent)) {
            xPathException.setLocator(this);
        }
        if (xPathException.getLocator() instanceof AttributeLocation) {
            ((AttributeLocation)xPathException.getLocator()).setElementNode(this);
        }
        if (xPathException.getLocator() instanceof XPathParser.NestedLocation && (location = ((XPathParser.NestedLocation)xPathException.getLocator()).getContainingLocation()) instanceof AttributeLocation) {
            ((AttributeLocation)location).setElementNode(this);
        }
        this.getCompilation().reportError(xPathException);
    }

    public void compileError(String string) {
        this.compileError(string, "XTSE0010");
    }

    public void compileError(String object, StructuredQName structuredQName) {
        object = new XPathException((String)object);
        ((XPathException)object).setErrorCodeQName(structuredQName);
        ((TransformerException)object).setLocator(this);
        this.compileError((XPathException)object);
    }

    public void compileError(String string, String string2) {
        this.compileError(new XPathException(string, string2, this));
    }

    public void compileError(String string, String string2, Location location) {
        this.compileError(new XPathException(string, string2, location));
    }

    public void compileErrorInAttribute(String string, String string2, String object) {
        object = StructuredQName.fromClarkName((String)object);
        object = new AttributeLocation(this, (StructuredQName)object);
        this.compileError(new XPathException(string, string2, (Location)object));
    }

    protected void invalidAttribute(String string, String string2) {
        this.compileErrorInAttribute("Attribute " + this.getDisplayName() + "/@" + string + " must be " + string2, "XTSE0020", string);
    }

    protected void undeclaredNamespaceError(String string, String string2, String string3) {
        if (string2 == null) {
            string2 = "XTSE0280";
        }
        this.compileErrorInAttribute("Undeclared namespace prefix " + Err.wrap(string), string2, string3);
    }

    public void compileWarning(String object, StructuredQName structuredQName) {
        object = new XPathException((String)object);
        ((XPathException)object).setErrorCodeQName(structuredQName);
        ((TransformerException)object).setLocator(this);
        this.getCompilation().reportWarning((XPathException)object);
    }

    public void compileWarning(String object, String string) {
        object = new XPathException((String)object);
        ((XPathException)object).setErrorCode(string);
        ((TransformerException)object).setLocator(this);
        this.getCompilation().reportWarning((XPathException)object);
    }

    protected void issueWarning(XPathException xPathException) {
        if (xPathException.getLocator() == null) {
            xPathException.setLocator(this);
        }
        this.getCompilation().reportWarning(xPathException);
    }

    protected void issueWarning(String object, SourceLocator sourceLocator) {
        object = new XPathException((String)object);
        if (sourceLocator == null) {
            ((TransformerException)object).setLocator(this);
        } else {
            ((TransformerException)object).setLocator(sourceLocator);
        }
        this.issueWarning((XPathException)object);
    }

    public boolean isTopLevel() {
        return this.getParent() instanceof XSLModuleRoot;
    }

    public boolean isConstructingComplexContent() {
        if (!this.isInstruction()) {
            return false;
        }
        NodeInfo nodeInfo = this.getParent();
        while (nodeInfo instanceof StyleElement && ((StyleElement)nodeInfo).isInstruction()) {
            if (nodeInfo instanceof XSLGeneralVariable) {
                return ((XSLGeneralVariable)nodeInfo).getAttributeValue("as") == null;
            }
            if (nodeInfo instanceof XSLElement || nodeInfo instanceof LiteralResultElement || nodeInfo instanceof XSLDocument || nodeInfo instanceof XSLCopy) {
                return true;
            }
            nodeInfo = nodeInfo.getParent();
        }
        return false;
    }

    public SourceBinding getBindingInformation(StructuredQName structuredQName) {
        return null;
    }

    public SourceBinding bindVariable(StructuredQName object) {
        SourceBinding sourceBinding = this.bindLocalVariable((StructuredQName)object);
        if (sourceBinding != null) {
            return sourceBinding;
        }
        object = this.getPrincipalStylesheetModule().getGlobalVariableBinding((StructuredQName)object);
        if (object == null || Navigator.isAncestorOrSelf(((SourceBinding)object).getSourceElement(), this)) {
            return null;
        }
        return object;
    }

    public SourceBinding bindLocalVariable(StructuredQName structuredQName) {
        block7: {
            Object object = this;
            NodeInfo nodeInfo = this;
            SourceBinding sourceBinding = this.hasImplicitBinding(structuredQName);
            if (sourceBinding != null) {
                return sourceBinding;
            }
            if (!this.isTopLevel()) {
                AxisIterator axisIterator = object.iterateAxis((byte)11);
                while (true) {
                    if ((object = axisIterator.next()) == null) {
                        object = nodeInfo.getParent();
                        if (object instanceof StyleElement && (sourceBinding = ((StyleElement)object).hasImplicitBinding(structuredQName)) != null) {
                            return sourceBinding;
                        }
                        while (object instanceof StyleElement && !((StyleElement)object).seesAvuncularVariables()) {
                            object = object.getParent();
                        }
                        nodeInfo = object;
                        if (!(object.getParent() instanceof XSLModuleRoot)) {
                            axisIterator = object.iterateAxis((byte)11);
                            continue;
                        }
                    }
                    if (object.getParent() instanceof XSLModuleRoot) break block7;
                    if (object instanceof XSLGeneralVariable && (object = ((XSLGeneralVariable)object).getBindingInformation(structuredQName)) != null) break;
                }
                return object;
            }
        }
        return null;
    }

    protected boolean seesAvuncularVariables() {
        return true;
    }

    protected SourceBinding hasImplicitBinding(StructuredQName structuredQName) {
        return null;
    }

    public int getConstructType() {
        return this.getFingerprint();
    }

    public StructuredQName getObjectName() {
        return this.b;
    }

    public void setObjectName(StructuredQName structuredQName) {
        this.b = structuredQName;
    }

    public Object getProperty(String string) {
        return ((NodeImpl)this).getAttributeValue("", string);
    }

    public Iterator<String> getProperties() {
        ArrayList arrayList = new ArrayList(10);
        this.iterateAxis((byte)2).forEach((T nodeInfo) -> arrayList.add(NameOfNode.makeName(nodeInfo).getStructuredQName().getClarkName()));
        return arrayList.iterator();
    }

    public boolean isActionCompleted(int n2) {
        return (this.actionsCompleted & n2) != 0;
    }

    public void setActionCompleted(int n2) {
        this.actionsCompleted |= n2;
    }

    private static /* synthetic */ void a(List list, List list2, List list3, NodeInfo nodeInfo) {
        int n2 = nodeInfo.getFingerprint();
        if (n2 == 206 || n2 == 189) {
            list.add(nodeInfo);
            return;
        }
        if (n2 == 183) {
            list2.add(nodeInfo);
            return;
        }
        list3.add(nodeInfo);
    }

    private /* synthetic */ void a(PrincipalStylesheetModule object, StructuredQName structuredQName) {
        if (((PrincipalStylesheetModule)object).getRuleManager().obtainMode(structuredQName, false) == null) {
            object = new XPathException("Mode " + structuredQName.getDisplayName() + " is not declared in an xsl:mode declaration", "XTSE3085");
            ((XPathException)object).setLocation(this);
            throw object;
        }
    }
}

