/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;

public class StylesheetFunctionLibrary
implements FunctionLibrary {
    private StylesheetPackage a;
    private boolean b;

    public StylesheetFunctionLibrary(StylesheetPackage stylesheetPackage, boolean bl2) {
        this.a = stylesheetPackage;
        this.b = bl2;
    }

    public boolean isOverrideExtensionFunction() {
        return this.b;
    }

    public StylesheetPackage getStylesheetPackage() {
        return this.a;
    }

    @Override
    public Expression bind(SymbolicName.F object, Expression[] expressionArray, StaticContext staticContext, List<String> iterable) {
        iterable = this.a.getFunction((SymbolicName.F)object);
        if (iterable == null) {
            return null;
        }
        if (((UserFunction)iterable).isOverrideExtensionFunction() != this.b) {
            return null;
        }
        UserFunctionCall userFunctionCall = new UserFunctionCall();
        userFunctionCall.setFunctionName(((SymbolicName)object).getComponentName());
        userFunctionCall.setArguments(expressionArray);
        userFunctionCall.setFunction((UserFunction)iterable);
        if (staticContext instanceof ExpressionContext) {
            object = ((ExpressionContext)staticContext).getStyleElement().getCompilation().getPrincipalStylesheetModule();
            ExpressionVisitor.make(staticContext);
            ((PrincipalStylesheetModule)object).addFixupAction(() -> StylesheetFunctionLibrary.a(userFunctionCall, (PrincipalStylesheetModule)object));
        }
        return userFunctionCall;
    }

    @Override
    public boolean isAvailable(SymbolicName.F f2) {
        return this.a.getFunction(f2) != null;
    }

    @Override
    public FunctionLibrary copy() {
        return this;
    }

    private static /* synthetic */ void a(UserFunctionCall userFunctionCall, PrincipalStylesheetModule object) {
        if (userFunctionCall.getFunction() == null) {
            object = ((PrincipalStylesheetModule)object).getComponent(userFunctionCall.getSymbolicName());
            if ((object = (UserFunction)((Component)object).getActor()) != null) {
                userFunctionCall.allocateArgumentEvaluators();
                userFunctionCall.setStaticType(((UserFunction)object).getResultType());
                return;
            }
            object = new XPathException("There is no available function named " + userFunctionCall.getDisplayName() + " with " + userFunctionCall.getArity() + " arguments", "XPST0017");
            ((TransformerException)object).setLocator(userFunctionCall.getLocation());
            throw object;
        }
    }
}

