/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.CheckSumFilter;
import net.sf.saxon.event.CommentStripper;
import net.sf.saxon.event.PIGrabber;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.event.Valve;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.StylesheetSpaceStrippingRule;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.UseWhenFilter;
import net.sf.saxon.style.XSLGeneralIncorporate;
import net.sf.saxon.style.XSLModuleRoot;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.value.NestedIntegerValue;
import net.sf.saxon.value.Whitespace;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class StylesheetModule {
    private StyleElement a;
    private int b;
    private int c;
    private StylesheetModule d;
    private boolean e;
    private int f = 0;
    protected List<ComponentDeclaration> topLevel = new ArrayList<ComponentDeclaration>();

    public StylesheetModule(StyleElement styleElement, int n2) {
        this.a = styleElement;
        this.b = n2;
    }

    public static DocumentImpl loadStylesheetModule(Source source, boolean bl2, Compilation compilation, NestedIntegerValue object) {
        Object object2;
        Object object3 = source.getSystemId();
        Object object4 = object2 = object3 == null ? null : new DocumentURI((String)object3);
        if (object3 != null && compilation.getImportStack().contains(object2)) {
            throw new XPathException("The stylesheet module includes/imports itself directly or indirectly", "XTSE0180");
        }
        compilation.getImportStack().push((DocumentURI)object2);
        object3 = compilation.getConfiguration();
        object2 = ((Configuration)object3).makePipelineConfiguration();
        ((PipelineConfiguration)object2).setErrorListener(compilation.getCompilerInfo().getErrorListener());
        LinkedTreeBuilder linkedTreeBuilder = new LinkedTreeBuilder((PipelineConfiguration)object2);
        ((PipelineConfiguration)object2).setURIResolver(compilation.getCompilerInfo().getURIResolver());
        linkedTreeBuilder.setSystemId(source.getSystemId());
        linkedTreeBuilder.setNodeFactory(compilation.getStyleNodeFactory(bl2));
        linkedTreeBuilder.setLineNumbering(true);
        object = new UseWhenFilter(compilation, linkedTreeBuilder, (NestedIntegerValue)object);
        ((SequenceReceiver)object).setSystemId(source.getSystemId());
        StartTagBuffer startTagBuffer = new StartTagBuffer((Receiver)object);
        ((UseWhenFilter)object).setStartTagBuffer(startTagBuffer);
        object = new StylesheetSpaceStrippingRule(((Configuration)object3).getNamePool());
        object = new Stripper((SpaceStrippingRule)object, startTagBuffer);
        object = new CommentStripper((Receiver)object);
        object2 = StylesheetModule.a(source, (PipelineConfiguration)object2);
        try {
            StylesheetModule.a(source, (Configuration)object3, (ProxyReceiver)object, (ParseOptions)object2);
            object = (DocumentImpl)((Builder)linkedTreeBuilder).getCurrentRoot();
            ((Builder)linkedTreeBuilder).reset();
            compilation.getImportStack().pop();
            return object;
        }
        catch (XPathException xPathException) {
            if (bl2 && !xPathException.hasBeenReported()) {
                compilation.reportError(xPathException);
            }
            throw xPathException;
        }
        finally {
            if (((ParseOptions)object2).isPleaseCloseAfterUse()) {
                ParseOptions.close(source);
            }
        }
    }

    public static PreparedStylesheet loadStylesheet(Source source, Compilation compilation) {
        Object object;
        Object object2;
        if (source instanceof SAXSource && compilation.getConfiguration().getBooleanProperty(Feature.IGNORE_SAX_SOURCE_PARSER)) {
            ((SAXSource)source).setXMLReader(null);
        }
        Object object3 = object2 = (object = source.getSystemId()) == null ? null : new DocumentURI((String)object);
        if (object != null && compilation.getImportStack().contains(object2)) {
            throw new XPathException("The stylesheet module includes/imports itself directly or indirectly", "XTSE0180");
        }
        compilation.getImportStack().push((DocumentURI)object2);
        compilation.setMinimalPackageData();
        object = compilation.getConfiguration();
        object2 = ((Configuration)object).makePipelineConfiguration();
        ((PipelineConfiguration)object2).setErrorListener(compilation.getCompilerInfo().getErrorListener());
        Object object4 = new LinkedTreeBuilder((PipelineConfiguration)object2);
        ((PipelineConfiguration)object2).setURIResolver(compilation.getCompilerInfo().getURIResolver());
        ((Builder)object4).setSystemId(source.getSystemId());
        ((LinkedTreeBuilder)object4).setNodeFactory(compilation.getStyleNodeFactory(true));
        ((Builder)object4).setLineNumbering(true);
        Object object5 = new UseWhenFilter(compilation, (Receiver)object4, NestedIntegerValue.TWO);
        ((SequenceReceiver)object5).setSystemId(source.getSystemId());
        Receiver receiver = new StartTagBuffer((Receiver)object5);
        ((UseWhenFilter)object5).setStartTagBuffer((StartTagBuffer)receiver);
        object5 = new StylesheetSpaceStrippingRule(((Configuration)object).getNamePool());
        object5 = new Stripper((SpaceStrippingRule)object5, receiver);
        object5 = new CommentStripper((Receiver)object5);
        receiver = new TinyBuilder((PipelineConfiguration)object2);
        ((Builder)receiver).setSystemId(source.getSystemId());
        CheckSumFilter checkSumFilter = new CheckSumFilter(receiver);
        checkSumFilter.setCheckExistingChecksum(true);
        Valve valve = new Valve("http://ns.saxonica.com/xslt/export", (Receiver)object5, checkSumFilter);
        object5 = valve;
        object2 = StylesheetModule.a(source, (PipelineConfiguration)object2);
        try {
            StylesheetModule.a(source, (Configuration)object, (ProxyReceiver)object5, (ParseOptions)object2);
            if (valve.wasDiverted()) {
                if (!checkSumFilter.isChecksumCorrect()) {
                    throw new XPathException("Compiled package cannot be loaded: incorrect checksum");
                }
                object4 = ((Configuration)object).makePackageLoader();
                object = object4.loadPackageDoc(((Builder)receiver).getCurrentRoot());
                compilation.setPackageData((PackageData)object);
                object4 = new PreparedStylesheet(compilation);
                ((StylesheetPackage)object).checkForAbstractComponents();
                ((StylesheetPackage)object).updatePreparedStylesheet((PreparedStylesheet)object4);
                object = object4;
                return object;
            }
            object = ((Builder)object4).getCurrentRoot();
            ((Builder)object4).reset();
            compilation.getImportStack().pop();
            object4 = new PreparedStylesheet(compilation);
            object = compilation.compilePackage((Source)object);
            if (compilation.getErrorCount() > 0) {
                object4 = new XPathException("Errors were reported during stylesheet compilation");
                ((XPathException)object4).setHasBeenReported(true);
                throw object4;
            }
            ((PrincipalStylesheetModule)object).getStylesheetPackage().checkForAbstractComponents();
            ((PrincipalStylesheetModule)object).getStylesheetPackage().updatePreparedStylesheet((PreparedStylesheet)object4);
            ((Executable)object4).addPackage(compilation.getPackageData());
            return object4;
        }
        catch (XPathException xPathException) {
            object = xPathException;
            if (!xPathException.hasBeenReported()) {
                compilation.reportError((XPathException)object);
            }
            throw object;
        }
        finally {
            if (((ParseOptions)object2).isPleaseCloseAfterUse()) {
                ParseOptions.close(source);
            }
        }
    }

    private static ParseOptions a(Source object, PipelineConfiguration pipelineConfiguration) {
        object = object instanceof AugmentedSource ? ((AugmentedSource)object).getParseOptions() : new ParseOptions();
        ((ParseOptions)object).setSchemaValidationMode(4);
        ((ParseOptions)object).setDTDValidationMode(4);
        ((ParseOptions)object).setLineNumbering(true);
        ((ParseOptions)object).setSpaceStrippingRule(NoElementsSpaceStrippingRule.getInstance());
        ((ParseOptions)object).setErrorListener(pipelineConfiguration.getErrorListener());
        return object;
    }

    private static void a(Source source, Configuration configuration, ProxyReceiver proxyReceiver, ParseOptions parseOptions) {
        boolean bl2 = parseOptions.getXMLReader() != null || parseOptions.getXMLReaderMaker() != null || source instanceof SAXSource && ((SAXSource)source).getXMLReader() != null;
        if (bl2) {
            Sender.send(source, proxyReceiver, parseOptions);
            return;
        }
        XMLReader xMLReader = configuration.getStyleParser();
        parseOptions.setXMLReader(xMLReader);
        Sender.send(source, proxyReceiver, parseOptions);
        configuration.reuseStyleParser(xMLReader);
    }

    public static Source getAssociatedStylesheet(Configuration configuration, URIResolver object, Source object2, String charSequence, String string, String object3) {
        block9: {
            object3 = new PIGrabber(new Sink(configuration.makePipelineConfiguration()));
            ((PIGrabber)object3).setFactory(configuration);
            ((PIGrabber)object3).setCriteria((String)charSequence, string);
            ((PIGrabber)object3).setBaseURI(object2.getSystemId());
            ((PIGrabber)object3).setURIResolver((URIResolver)object);
            try {
                Sender.send((Source)object2, (Receiver)object3, null);
            }
            catch (XPathException xPathException) {
                if (((PIGrabber)object3).isTerminated()) break block9;
                throw new XPathException("Failed while looking for xml-stylesheet PI", xPathException);
            }
        }
        try {
            object = ((PIGrabber)object3).getAssociatedStylesheets();
            if (object == null) {
                throw new XPathException("No matching <?xml-stylesheet?> processing instruction found");
            }
            String string2 = object2.getSystemId();
            object2 = object;
            object = string2;
            if (((Source[])object2).length == 1) {
                return object2[0];
            }
            if (((Source[])object2).length == 0) {
                throw new XPathException("No stylesheets were supplied");
            }
            charSequence = new StringBuilder(250);
            ((StringBuilder)charSequence).append("<xsl:stylesheet version='1.0' ");
            ((StringBuilder)charSequence).append(" xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>");
            for (Source source : object2) {
                ((StringBuilder)charSequence).append("<xsl:import href='").append(source.getSystemId()).append("'/>");
            }
            ((StringBuilder)charSequence).append("</xsl:stylesheet>");
            object2 = new InputSource();
            ((InputSource)object2).setSystemId((String)object);
            ((InputSource)object2).setCharacterStream(new StringReader(((StringBuilder)charSequence).toString()));
            return new SAXSource(configuration.getStyleParser(), (InputSource)object2);
        }
        catch (TransformerException transformerException) {
            object = transformerException;
            if (transformerException instanceof XPathException) {
                throw (XPathException)object;
            }
            throw new XPathException((Throwable)object);
        }
    }

    public void setImporter(StylesheetModule stylesheetModule) {
        this.d = stylesheetModule;
    }

    public StylesheetModule getImporter() {
        return this.d;
    }

    public PrincipalStylesheetModule getPrincipalStylesheetModule() {
        return this.d.getPrincipalStylesheetModule();
    }

    public StyleElement getRootElement() {
        return this.a;
    }

    public XSLModuleRoot getStylesheetElement() {
        return (XSLModuleRoot)this.a;
    }

    public Configuration getConfiguration() {
        return ((NodeImpl)this.a).getConfiguration();
    }

    public int getPrecedence() {
        if (this.e) {
            return this.d.getPrecedence();
        }
        return this.b;
    }

    public void setWasIncluded() {
        this.e = true;
    }

    public void setMinImportPrecedence(int n2) {
        this.c = n2;
    }

    public int getMinImportPrecedence() {
        return this.c;
    }

    public void spliceIncludes() {
        Object object;
        if (this.topLevel == null || this.topLevel.size() == 0) {
            this.topLevel = new ArrayList<ComponentDeclaration>(50);
        }
        this.c = this.b;
        StyleElement styleElement = this.a;
        AxisIterator axisIterator = this.getStylesheetElement().iterateAxis((byte)3);
        while ((object = axisIterator.next()) != null) {
            Object object2;
            if (object.getNodeKind() == 3) {
                if (Whitespace.isWhite(object.getStringValueCS())) continue;
                styleElement.compileError("No character data is allowed between top-level elements", "XTSE0120");
                continue;
            }
            if (object instanceof DataElement) {
                if (!((NodeImpl)((DataElement)object)).getNodeName().getURI().isEmpty()) continue;
                object2 = new ExplicitLocation((SourceLocator)object);
                styleElement.compileError("Top-level elements must be in a namespace: " + ((NodeImpl)((DataElement)object)).getNodeName().getLocalPart() + " is not", "XTSE0130", (Location)object2);
                continue;
            }
            styleElement = (StyleElement)object;
            if (object instanceof XSLGeneralIncorporate) {
                object2 = (XSLGeneralIncorporate)object;
                ((StyleElement)object2).processAttributes();
                ((XSLGeneralIncorporate)object2).isImport();
                ((XSLGeneralIncorporate)object2).validateInstruction();
                int n2 = ((XSLGeneralIncorporate)object).getCompilation().getErrorCount();
                StylesheetModule stylesheetModule = this;
                StylesheetModule stylesheetModule2 = ((XSLGeneralIncorporate)object2).getIncludedStylesheet(stylesheetModule, stylesheetModule.b);
                if (stylesheetModule2 == null) {
                    return;
                }
                n2 = ((XSLGeneralIncorporate)object).getCompilation().getErrorCount() - n2;
                if (n2 > 0) {
                    ((StyleElement)object2).compileError("Reported " + n2 + (n2 == 1 ? " error" : " errors") + " in " + (((XSLGeneralIncorporate)object2).isImport() ? "imported" : "included") + " stylesheet module", "XTSE0165");
                }
                if (((XSLGeneralIncorporate)object2).isImport()) {
                    this.b = stylesheetModule2.getPrecedence() + 1;
                } else {
                    this.b = stylesheetModule2.getPrecedence();
                    stylesheetModule2.setMinImportPrecedence(this.c);
                    stylesheetModule2.setWasIncluded();
                }
                object = stylesheetModule2.topLevel;
                object = object.iterator();
                while (object.hasNext()) {
                    object2 = (ComponentDeclaration)object.next();
                    n2 = this.topLevel.size() - 1;
                    if (n2 < 0 || ((ComponentDeclaration)object2).getPrecedence() >= this.topLevel.get(n2).getPrecedence()) {
                        this.topLevel.add((ComponentDeclaration)object2);
                        continue;
                    }
                    while (n2 >= 0 && ((ComponentDeclaration)object2).getPrecedence() < this.topLevel.get(n2).getPrecedence()) {
                        --n2;
                    }
                    this.topLevel.add(n2 + 1, (ComponentDeclaration)object2);
                }
                continue;
            }
            object2 = new ComponentDeclaration(this, (StyleElement)object);
            this.topLevel.add((ComponentDeclaration)object2);
        }
    }

    public int getInputTypeAnnotations() {
        return this.f;
    }

    public void setInputTypeAnnotations(int n2) {
        this.f |= n2;
        if (this.f == 3) {
            this.getPrincipalStylesheetModule().compileError("One stylesheet module specifies input-type-annotations='strip', another specifies input-type-annotations='preserve'", "XTSE0265");
        }
        if (n2 == 1) {
            this.getPrincipalStylesheetModule().getStylesheetPackage().setStripsTypeAnnotations(true);
        }
    }
}

