/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Collections;
import java.util.Set;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.registry.ConstructorFunctionLibrary;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLTStaticContext;
import net.sf.saxon.sxpath.AbstractStaticContext;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class UseWhenStaticContext
extends AbstractStaticContext
implements XSLTStaticContext {
    private NamespaceResolver a;
    private FunctionLibraryList b;
    private Compilation c;

    public UseWhenStaticContext(Compilation object, NamespaceResolver namespaceResolver) {
        Configuration configuration = ((Compilation)object).getConfiguration();
        this.setConfiguration(configuration);
        this.c = object;
        this.setPackageData(((Compilation)object).getPackageData());
        this.a = namespaceResolver;
        this.setXPathLanguageLevel(31);
        object = new FunctionLibraryList();
        ((FunctionLibraryList)object).addFunctionLibrary(configuration.getUseWhenFunctionSet());
        ((FunctionLibraryList)object).addFunctionLibrary(this.getConfiguration().getBuiltInExtensionLibraryList());
        ((FunctionLibraryList)object).addFunctionLibrary(new ConstructorFunctionLibrary(this.getConfiguration()));
        ((FunctionLibraryList)object).addFunctionLibrary(configuration.getIntegratedFunctionLibrary());
        configuration.addExtensionBinders((FunctionLibraryList)object);
        this.b = object;
    }

    @Override
    public RetainedStaticContext makeRetainedStaticContext() {
        return new RetainedStaticContext(this);
    }

    public Compilation getCompilation() {
        return this.c;
    }

    @Override
    public void issueWarning(String object, Location location) {
        object = new XPathException((String)object);
        ((TransformerException)object).setLocator(location);
        this.getConfiguration().getErrorListener().warning((TransformerException)object);
    }

    @Override
    public String getSystemId() {
        return this.getStaticBaseURI();
    }

    @Override
    public Expression bindVariable(StructuredQName object) {
        GroundedValue<?> groundedValue = this.c.getStaticVariable((StructuredQName)object);
        if (groundedValue != null) {
            return Literal.makeLiteral(groundedValue);
        }
        object = new XPathException("Variables (other than XSLT 3.0 static variables) cannot be used in a static expression: " + ((StructuredQName)object).getDisplayName());
        ((XPathException)object).setErrorCode("XPST0008");
        ((XPathException)object).setIsStaticError(true);
        throw object;
    }

    @Override
    public FunctionLibrary getFunctionLibrary() {
        return this.b;
    }

    @Override
    public String getDefaultCollationName() {
        return "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    }

    @Override
    public String getDefaultFunctionNamespace() {
        return "http://www.w3.org/2005/xpath-functions";
    }

    @Override
    public boolean isInBackwardsCompatibleMode() {
        return false;
    }

    @Override
    public boolean isImportedSchema(String string) {
        return false;
    }

    @Override
    public Set<String> getImportedSchemaNamespaces() {
        return Collections.emptySet();
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        return this.a;
    }

    @Override
    public DecimalFormatManager getDecimalFormatManager() {
        return null;
    }

    @Override
    public boolean isElementAvailable(String stringArray) {
        try {
            stringArray = NameChecker.getQNameParts((CharSequence)stringArray);
            String string = stringArray[0].isEmpty() ? this.getDefaultElementNamespace() : this.a.getURIForPrefix(stringArray[0], false);
            StyleNodeFactory styleNodeFactory = this.getConfiguration().makeStyleNodeFactory(this.c);
            return styleNodeFactory.isElementAvailable(string, stringArray[1], true);
        }
        catch (QNameException qNameException) {
            XPathException xPathException = new XPathException("Invalid element name. " + qNameException.getMessage());
            xPathException.setErrorCode("XTDE1440");
            throw xPathException;
        }
    }

    public int getColumnNumber() {
        return 0;
    }

    public String getPublicId() {
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    @Override
    public ItemType resolveTypeAlias(StructuredQName structuredQName) {
        return null;
    }
}

