/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Component;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLAcceptExpose;
import net.sf.saxon.style.XSLUsePackage;
import net.sf.saxon.trans.ComponentTest;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.VisibilityProvenance;

public class XSLAccept
extends XSLAcceptExpose {
    @Override
    protected void prepareAttributes() {
        super.prepareAttributes();
    }

    @Override
    public void validate(ComponentDeclaration object) {
        object = this.getParent();
        if (!(object instanceof XSLUsePackage)) {
            this.compileError("Parent of xsl:accept must be xsl:use-package");
            return;
        }
        if ((object = ((StyleElement)((XSLUsePackage)object)).getUsedPackage()) != null) {
            for (ComponentTest componentTest : this.getExplicitComponentTests()) {
                QNameTest qNameTest = componentTest.getQNameTest();
                if (!(qNameTest instanceof NameTest)) continue;
                int n2 = componentTest.getComponentKind();
                SymbolicName symbolicName = n2 == 158 ? new SymbolicName.F(((NodeTest)((NameTest)qNameTest)).getMatchingNodeName(), componentTest.getArity()) : new SymbolicName(n2, ((NodeTest)((NameTest)qNameTest)).getMatchingNodeName());
                Component component = ((StylesheetPackage)object).getComponent(symbolicName);
                boolean bl2 = false;
                if (component == null) {
                    if (n2 == 158 && componentTest.getArity() == -1) {
                        for (int i2 = 0; i2 <= ((StylesheetPackage)object).getMaxFunctionArity(); ++i2) {
                            symbolicName = new SymbolicName.F(((NodeTest)((NameTest)qNameTest)).getMatchingNodeName(), i2);
                            component = ((StylesheetPackage)object).getComponent(symbolicName);
                            if (component == null) continue;
                            this.checkCompatibility(symbolicName, component.getVisibility(), ((StyleElement)this).getVisibility());
                            bl2 = true;
                        }
                    }
                } else {
                    this.checkCompatibility(symbolicName, component.getVisibility(), ((StyleElement)this).getVisibility());
                    bl2 = true;
                }
                if (bl2) continue;
                this.compileError("No " + symbolicName.toString() + " exists in the used package", "XTSE3030");
            }
        }
    }

    public void acceptComponent(Component component) {
        for (ComponentTest componentTest : this.getExplicitComponentTests()) {
            if (!componentTest.matches(component.getActor())) continue;
            component.setVisibility(((StyleElement)this).getVisibility(), VisibilityProvenance.ACCEPTED);
            return;
        }
        for (ComponentTest componentTest : this.getWildcardComponentTests()) {
            if (!componentTest.matches(component.getActor()) || !XSLAccept.isCompatible(component.getVisibility(), ((StyleElement)this).getVisibility())) continue;
            component.setVisibility(((StyleElement)this).getVisibility(), VisibilityProvenance.ACCEPTED);
            return;
        }
    }

    protected void checkCompatibility(SymbolicName symbolicName, Visibility visibility, Visibility visibility2) {
        if (!XSLAccept.isCompatible(visibility, visibility2)) {
            String string = "XTSE3040";
            this.compileError("The " + symbolicName + " is declared as " + visibility.show() + " and cannot be accepted as " + visibility2.show(), string);
        }
    }

    public static boolean isCompatible(Visibility visibility, Visibility visibility2) {
        switch (visibility) {
            case PUBLIC: {
                return visibility2 == Visibility.PUBLIC || visibility2 == Visibility.PRIVATE || visibility2 == Visibility.FINAL || visibility2 == Visibility.HIDDEN;
            }
            case ABSTRACT: {
                return visibility2 == Visibility.ABSTRACT || visibility2 == Visibility.HIDDEN;
            }
            case FINAL: {
                return visibility2 == Visibility.PRIVATE || visibility2 == Visibility.FINAL || visibility2 == Visibility.HIDDEN;
            }
        }
        return false;
    }
}

