/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLAccept;
import net.sf.saxon.trans.ComponentTest;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public abstract class XSLAcceptExpose
extends StyleElement {
    private Set<ComponentTest> a = new HashSet<ComponentTest>();
    private Set<ComponentTest> b = new HashSet<ComponentTest>();
    private Visibility c;

    @Override
    public Visibility getVisibility() {
        return this.c;
    }

    public Set<ComponentTest> getExplicitComponentTests() {
        this.prepareAttributes();
        return this.a;
    }

    public Set<ComponentTest> getWildcardComponentTests() {
        this.prepareAttributes();
        return this.b;
    }

    @Override
    protected void prepareAttributes() {
        Object object;
        int n2;
        if (this.c != null) {
            return;
        }
        String string = null;
        Object object2 = null;
        String string2 = null;
        Object object3 = this.getAttributeList();
        for (n2 = 0; n2 < object3.getLength(); ++n2) {
            object = object3.getQName(n2);
            if (((String)object).equals("names")) {
                object2 = Whitespace.trim(object3.getValue(n2));
                continue;
            }
            if (((String)object).equals("component")) {
                string = Whitespace.trim(object3.getValue(n2));
                continue;
            }
            if (((String)object).equals("visibility")) {
                string2 = Whitespace.trim(object3.getValue(n2));
                continue;
            }
            this.checkUnknownAttribute(object3.getNodeName(n2));
        }
        if (string2 == null) {
            this.reportAbsence("visibility");
            this.c = Visibility.PRIVATE;
        } else {
            this.c = this.interpretVisibilityValue(string2, this instanceof XSLAccept ? "ha" : "");
            if (this.c == null) {
                this.c = Visibility.PRIVATE;
            }
        }
        n2 = 158;
        if (string == null) {
            this.reportAbsence("component");
        } else {
            object = Whitespace.trim(string);
            if (((String)object).equals("function")) {
                n2 = 158;
            } else if (((String)object).equals("template")) {
                n2 = 200;
            } else if (((String)object).equals("variable")) {
                n2 = 206;
            } else if (((String)object).equals("attribute-set")) {
                n2 = 136;
            } else if (((String)object).equals("mode")) {
                n2 = 174;
            } else if (((String)object).equals("*")) {
                n2 = -1;
            } else {
                this.compileError("The component type is not one of the allowed names (function, template, variable, attribute-set, or mode)", "XTSE0020");
                return;
            }
        }
        if (object2 == null) {
            this.reportAbsence("names");
            object2 = "";
        }
        object = new StringTokenizer((String)object2, " \t\r\n");
        while (((StringTokenizer)object).hasMoreTokens()) {
            string = ((StringTokenizer)object).nextToken();
            int n3 = string.lastIndexOf(35);
            if (n3 > 0 && string.indexOf(125, n3) < 0) {
                if (n2 == -1) {
                    this.compileError("When component='*' is specified, all names must be wildcards", this instanceof XSLAccept ? "XTSE3032" : "XTSE3022");
                    continue;
                }
                if (n2 == 158) {
                    object2 = this.makeQName(string.substring(0, n3));
                    object2 = new NameTest(1, ((StructuredQName)object2).getURI(), ((StructuredQName)object2).getLocalPart(), this.getNamePool());
                    int n4 = 0;
                    try {
                        n4 = Integer.parseInt(string.substring(n3 + 1));
                    }
                    catch (Exception exception) {
                        this.compileError("Malformed function arity in '" + string + "'");
                    }
                    this.a.add(new ComponentTest(n2, (QNameTest)object2, n4));
                    continue;
                }
                this.compileError("Cannot specify arity for components other than functions", "XTSE3020");
                continue;
            }
            if (string.equals("*")) {
                object2 = AnyNodeTest.getInstance();
                this.a(n2, (QNameTest)object2);
                continue;
            }
            if (string.endsWith(":*")) {
                if (string.length() == 2) {
                    this.compileError("No prefix before ':*'");
                }
                if ((object3 = this.getURIForPrefix((String)(object2 = string.substring(0, string.length() - 2)), false)) == null) {
                    this.compileError("Undeclared prefix " + (String)object2, "XTSE0020");
                    object3 = "http://ns.saxonica.com/anonymous-type";
                }
                object2 = new NamespaceTest(this.getNamePool(), 1, (String)object3);
                this.a(n2, (QNameTest)object2);
                continue;
            }
            if (string.startsWith("Q{") && string.endsWith("}*")) {
                object2 = string.substring(2, string.length() - 2);
                object2 = new NamespaceTest(this.getNamePool(), 1, (String)object2);
                this.b.add(new ComponentTest(n2, (QNameTest)object2, -1));
                continue;
            }
            if (string.startsWith("*:")) {
                if (string.length() == 2) {
                    this.compileError("No local name after '*:'");
                }
                object2 = string.substring(2);
                object2 = new LocalNameTest(this.getNamePool(), 1, (String)object2);
                this.a(n2, (QNameTest)object2);
                continue;
            }
            if (n2 == -1) {
                this.compileError("When component='*' is specified, all names must be wildcards", this instanceof XSLAccept ? "XTSE3032" : "XTSE3022");
                continue;
            }
            if (n2 == 158) {
                this.compileError("When the name identifies a function, the arity must be given (XSLT 3.0 erratum E36)", "XTSE3020");
                continue;
            }
            try {
                object2 = this.makeQName(string);
                object2 = new NameTest(1, ((StructuredQName)object2).getURI(), ((StructuredQName)object2).getLocalPart(), this.getNamePool());
                this.a.add(new ComponentTest(n2, (QNameTest)object2, -1));
            }
            catch (XPathException xPathException) {
                this.compileErrorInAttribute("Invalid QName in names attribute: " + string + " (" + xPathException.getMessage() + ")", xPathException.getErrorCodeLocalPart(), "names");
            }
        }
    }

    private void a(int n2, QNameTest qNameTest) {
        if (n2 == -1) {
            this.b.add(new ComponentTest(158, qNameTest, -1));
            this.b.add(new ComponentTest(200, qNameTest, -1));
            this.b.add(new ComponentTest(206, qNameTest, -1));
            this.b.add(new ComponentTest(136, qNameTest, -1));
            this.b.add(new ComponentTest(174, qNameTest, -1));
            return;
        }
        this.b.add(new ComponentTest(n2, qNameTest, -1));
    }
}

