/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.expr.accum.AccumulatorRule;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.XSLAccumulatorRule;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.RuleTarget;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class XSLAccumulator
extends StyleElement
implements StylesheetComponent {
    private Accumulator a = new Accumulator();
    private boolean b;

    @Override
    public Actor getActor() {
        if (this.a.getDeclaringComponent() == null) {
            this.a.makeDeclaringComponent(Visibility.PRIVATE, this.getContainingPackage());
        }
        return this.a;
    }

    @Override
    public SymbolicName getSymbolicName() {
        StructuredQName structuredQName = this.a.getAccumulatorName();
        if (structuredQName == null) {
            return null;
        }
        return new SymbolicName(129, null);
    }

    @Override
    public void checkCompatibility(Component component) {
    }

    @Override
    public boolean isDeclaration() {
        return true;
    }

    public void prepareSimpleAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string = attributeCollection.getQName(i2);
            if (string.equals("name")) {
                string = Whitespace.trim(attributeCollection.getValue(i2));
                try {
                    this.a.setAccumulatorName(this.makeQName(string));
                }
                catch (XPathException xPathException) {
                    this.compileError("Accumulator name " + Err.wrap(string) + " is not a valid QName", xPathException.getErrorCodeQName());
                    this.a.setAccumulatorName(new StructuredQName("saxon", "http://saxon.sf.net/", "error-name"));
                }
                continue;
            }
            if (string.equals("streamable")) {
                this.a.setDeclaredStreamable(false);
                this.b = this.b(attributeCollection.getValue(i2));
                this.a.setDeclaredStreamable(this.b);
                continue;
            }
            if (!attributeCollection.getURI(i2).equals("http://saxon.sf.net/") || !attributeCollection.getLocalName(i2).equals("trace")) continue;
            this.a.setTracing(this.processBooleanAttribute("saxon:trace", attributeCollection.getValue(i2)));
        }
        if (this.a.getAccumulatorName() == null) {
            this.reportAbsence("name");
        }
    }

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            Object object = attributeCollection.getQName(i2);
            if (((String)object).equals("name") || ((String)object).equals("streamable")) continue;
            if (((String)object).equals("initial-value")) {
                object = attributeCollection.getValue(i2);
                this.a.setInitialValueExpression(this.makeExpression((String)object, i2));
                continue;
            }
            if (((String)object).equals("as")) {
                object = attributeCollection.getValue(i2);
                try {
                    object = this.makeSequenceType((String)object);
                    this.a.setType((SequenceType)object);
                }
                catch (XPathException xPathException) {
                    this.compileErrorInAttribute(xPathException.getMessage(), xPathException.getErrorCodeLocalPart(), "as");
                }
                continue;
            }
            if (attributeCollection.getURI(i2).equals("http://saxon.sf.net/") && attributeCollection.getLocalName(i2).equals("trace")) {
                this.a.setTracing(this.processBooleanAttribute("saxon:trace", attributeCollection.getValue(i2)));
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (this.a.getType() == null) {
            this.a.setType(SequenceType.ANY_SEQUENCE);
        }
        if (this.a.getInitialValueExpression() == null) {
            this.reportAbsence("initial-value");
            StringLiteral stringLiteral = new StringLiteral(StringValue.EMPTY_STRING);
            stringLiteral.setRetainedStaticContext(this.makeRetainedStaticContext());
            this.a.setInitialValueExpression(stringLiteral);
        }
    }

    @Override
    public void compileDeclaration(Compilation compilation, ComponentDeclaration componentDeclaration) {
        Configuration configuration = compilation.getConfiguration();
        this.a.setPackageData(compilation.getPackageData());
        this.a.obtainDeclaringComponent(componentDeclaration.getSourceElement());
        Object object = this.a.getInitialValueExpression();
        Object object2 = ExpressionVisitor.make(this.getStaticContext());
        object = ((Expression)object).typeCheck((ExpressionVisitor)object2, configuration.getDefaultContextItemStaticInfo());
        RoleDiagnostic roleDiagnostic = new RoleDiagnostic(4, "xsl:accumulator-rule/select", 0);
        object = configuration.getTypeChecker(false).staticTypeCheck((Expression)object, this.a.getType(), roleDiagnostic, (ExpressionVisitor)object2);
        object = ((Expression)object).optimize((ExpressionVisitor)object2, configuration.getDefaultContextItemStaticInfo());
        object2 = configuration.makeSlotManager();
        ExpressionTool.allocateSlots((Expression)object, 0, (SlotManager)object2);
        this.a.setSlotManagerForInitialValueExpression((SlotManager)object2);
        this.a.addChildExpression((Expression)object);
        object = this.iterateAxis((byte)3);
        int n2 = 0;
        while ((object2 = object.next()) != null) {
            if (!(object2 instanceof XSLAccumulatorRule)) continue;
            object2 = (XSLAccumulatorRule)object2;
            Pattern pattern = ((XSLAccumulatorRule)object2).getMatch();
            Expression expression = ((XSLAccumulatorRule)object2).getNewValueExpression(compilation, componentDeclaration);
            Object object3 = ExpressionVisitor.make(this.getStaticContext());
            expression = expression.typeCheck((ExpressionVisitor)object3, configuration.makeContextItemStaticInfo(((Expression)pattern).getItemType(), false));
            Object object4 = new RoleDiagnostic(4, "xsl:accumulator-rule/select", 0);
            expression = configuration.getTypeChecker(false).staticTypeCheck(expression, this.a.getType(), (RoleDiagnostic)object4, (ExpressionVisitor)object3);
            expression = expression.optimize((ExpressionVisitor)object3, ((NodeImpl)this).getConfiguration().makeContextItemStaticInfo(((Expression)pattern).getItemType(), false));
            object3 = ((NodeImpl)this).getConfiguration().makeSlotManager();
            ((SlotManager)object3).allocateSlotNumber(new StructuredQName("", "", "value"));
            ExpressionTool.allocateSlots(expression, 1, (SlotManager)object3);
            boolean bl2 = !((XSLAccumulatorRule)object2).isPostDescent();
            object4 = bl2 ? this.a.getPreDescentRules() : this.a.getPostDescentRules();
            object3 = new AccumulatorRule(expression, (SlotManager)object3, ((XSLAccumulatorRule)object2).isPostDescent());
            ((SimpleMode)object4).addRule(pattern, (RuleTarget)object3, componentDeclaration.getModule(), componentDeclaration.getModule().getPrecedence(), 1.0, n2++, 0);
            if (this.a.isDeclaredStreamable() && ((XSLAccumulatorRule)object2).isPostDescent() && ((XSLAccumulatorRule)object2).isCapture()) {
                ((AccumulatorRule)object3).setCapturing(true);
            }
            if ((object3 = ((Expression)pattern).getItemType()) instanceof NodeTest) {
                if (!object3.getUType().overlaps(UType.DOCUMENT.union(UType.CHILD_NODE_KINDS))) {
                    ((StyleElement)object2).compileWarning("An accumulator rule that matches attribute or namespace nodes has no effect", "SXWN9999");
                }
            } else if (object3 instanceof AtomicType) {
                ((StyleElement)object2).compileWarning("An accumulator rule that matches atomic values has no effect", "SXWN9999");
            }
            this.a.addChildExpression(expression);
            this.a.addChildExpression(pattern);
        }
        this.a.getPreDescentRules().allocateAllPatternSlots();
        this.a.getPostDescentRules().allocateAllPatternSlots();
    }

    @Override
    public StructuredQName getObjectName() {
        Object object = super.getObjectName();
        if (object == null) {
            object = Whitespace.trim(((NodeImpl)this).getAttributeValue("", "name"));
            if (object == null) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-accumulator" + this.generateId());
            }
            try {
                object = this.makeQName((String)object);
                this.setObjectName((StructuredQName)object);
            }
            catch (XPathException xPathException) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-accumulator" + this.generateId());
            }
        }
        return object;
    }

    @Override
    public void index(ComponentDeclaration componentDeclaration, PrincipalStylesheetModule principalStylesheetModule) {
        Object object;
        Object object2;
        if (this.a.getAccumulatorName() == null) {
            this.prepareSimpleAttributes();
        }
        this.a.setImportPrecedence(componentDeclaration.getPrecedence());
        if (principalStylesheetModule.getAccumulatorManager() == null) {
            object2 = this.getCompilation().getStyleNodeFactory(true);
            object = ((StyleNodeFactory)object2).makeAccumulatorManager();
            principalStylesheetModule.setAccumulatorManager((AccumulatorRegistry)object);
            this.getCompilation().getPackageData().setAccumulatorRegistry((AccumulatorRegistry)object);
        }
        if ((object = ((AccumulatorRegistry)(object2 = principalStylesheetModule.getAccumulatorManager())).getAccumulator(this.a.getAccumulatorName())) != null) {
            int n2 = ((Accumulator)object).getImportPrecedence();
            if (n2 == componentDeclaration.getPrecedence()) {
                this.compileError("There are two accumulators with the same name (" + this.a.getAccumulatorName().getDisplayName() + ") and the same import precedence", "XTSE3350");
            }
            if (n2 > componentDeclaration.getPrecedence()) {
                return;
            }
        }
        ((AccumulatorRegistry)object2).addAccumulator(this.a);
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        NodeInfo nodeInfo;
        this.checkTopLevel("XTSE0010", true);
        boolean bl2 = false;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = axisIterator.next()) != null) {
            if (nodeInfo instanceof XSLAccumulatorRule) {
                bl2 = true;
                continue;
            }
            this.compileError("Only xsl:accumulator-rule is allowed here", "XTSE0010");
        }
        if (!bl2) {
            this.compileError("xsl:accumulator must contain at least one xsl:accumulator-rule", "XTSE0010");
        }
    }

    @Override
    public SlotManager getSlotManager() {
        return null;
    }

    @Override
    public void optimize(ComponentDeclaration componentDeclaration) {
    }

    public SequenceType getResultType() {
        return this.a.getType();
    }

    @Override
    public int getConstructType() {
        return 129;
    }

    @Override
    public void generateByteCode(Optimizer optimizer) {
    }
}

