/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.AnalyzeString;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLMatchingSubstring;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.NodeImpl;

public class XSLAnalyzeString
extends StyleElement {
    private Expression a;
    private Expression b;
    private Expression c;
    private StyleElement d;
    private StyleElement e;
    private RegularExpression f;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainFallback() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        String string;
        Iterator iterator = null;
        String string2 = null;
        String string3 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            string = attributeCollection.getQName(i2);
            if (string.equals("regex")) {
                string2 = attributeCollection.getValue(i2);
                this.b = this.makeAttributeValueTemplate(string2, i2);
                continue;
            }
            if (string.equals("select")) {
                iterator = attributeCollection.getValue(i2);
                this.a = this.makeExpression((String)((Object)iterator), i2);
                continue;
            }
            if (string.equals("flags")) {
                string3 = attributeCollection.getValue(i2);
                this.c = this.makeAttributeValueTemplate(string3, i2);
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (iterator == null) {
            this.reportAbsence("select");
            this.a = this.makeExpression(".", -1);
        }
        if (string2 == null) {
            this.reportAbsence("regex");
            this.b = this.makeAttributeValueTemplate("xxx", -1);
        }
        if (string3 == null) {
            this.c = this.makeAttributeValueTemplate("", -1);
        }
        if (this.b instanceof StringLiteral && this.c instanceof StringLiteral) {
            try {
                String string4 = ((StringLiteral)this.b).getStringValue();
                string = ((StringLiteral)this.c).getStringValue();
                iterator = new ArrayList();
                this.f = ((NodeImpl)this).getConfiguration().compileRegularExpression(string4, string, this.getEffectiveVersion() >= 30 ? "XP30" : "XP20", (List<String>)((Object)iterator));
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    this.issueWarning(string2, this);
                }
                return;
            }
            catch (XPathException xPathException) {
                if ("FORX0001".equals(xPathException.getErrorCodeLocalPart())) {
                    string2 = "Error in regular expression flags: " + xPathException.getMessage();
                    iterator = this;
                    ((StyleElement)((Object)iterator)).compileErrorInAttribute(string2, "XTDE1145", "flags");
                    ((XSLAnalyzeString)((Object)iterator)).f = ((NodeImpl)((Object)iterator)).getConfiguration().compileRegularExpression("x", "", "XP20", null);
                    return;
                }
                string2 = "Error in regular expression: " + xPathException.getMessage();
                iterator = this;
                ((StyleElement)((Object)iterator)).compileErrorInAttribute(string2, "XTDE1140", "regex");
                ((XSLAnalyzeString)((Object)iterator)).f = ((NodeImpl)((Object)iterator)).getConfiguration().compileRegularExpression("x", "", "XP20", null);
            }
        }
    }

    @Override
    public void validate(ComponentDeclaration object) {
        NodeInfo nodeInfo;
        object = this.iterateAxis((byte)3);
        boolean bl2 = false;
        while ((nodeInfo = object.next()) != null) {
            if (nodeInfo instanceof XSLFallback) {
                bl2 = true;
                continue;
            }
            if (nodeInfo instanceof XSLMatchingSubstring) {
                boolean bl3 = nodeInfo.getLocalPart().equals("matching-substring");
                if (bl3) {
                    if (this.d != null || this.e != null || bl2) {
                        this.compileError("xsl:matching-substring element must come first", "XTSE0010");
                    }
                    this.d = (StyleElement)nodeInfo;
                    continue;
                }
                if (this.e != null || bl2) {
                    this.compileError("xsl:non-matching-substring cannot appear here", "XTSE0010");
                }
                this.e = (StyleElement)nodeInfo;
                continue;
            }
            this.compileError("Only xsl:matching-substring and xsl:non-matching-substring are allowed here", "XTSE0010");
        }
        if (this.d == null && this.e == null) {
            this.compileError("At least one xsl:matching-substring or xsl:non-matching-substring element must be present", "XTSE1130");
        }
        this.a = this.typeCheck("select", this.a);
        this.b = this.typeCheck("regex", this.b);
        this.c = this.typeCheck("flags", this.c);
    }

    @Override
    public Expression compile(Compilation compilation, ComponentDeclaration componentDeclaration) {
        Expression expression = null;
        if (this.d != null) {
            expression = this.d.compileSequenceConstructor(compilation, componentDeclaration, false);
        }
        Expression expression2 = null;
        if (this.e != null) {
            expression2 = this.e.compileSequenceConstructor(compilation, componentDeclaration, false);
        }
        try {
            return new AnalyzeString(this.a, this.b, this.c, expression == null ? null : expression.simplify(), expression2 == null ? null : expression2.simplify(), this.f);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return null;
        }
    }
}

