/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.ApplyImports;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLOverride;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.value.Whitespace;

public class XSLApplyImports
extends StyleElement {
    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
    }

    @Override
    public void validate(ComponentDeclaration object) {
        NodeInfo nodeInfo;
        object = this.iterateAxis((byte)3);
        while ((nodeInfo = object.next()) != null) {
            if (nodeInfo instanceof XSLWithParam) continue;
            if (nodeInfo.getNodeKind() == 3) {
                if (Whitespace.isWhite(nodeInfo.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:apply-imports", "XTSE0010");
                continue;
            }
            this.compileError("Child element " + nodeInfo.getDisplayName() + " is not allowed as a child of xsl:apply-imports", "XTSE0010");
        }
        for (nodeInfo = this.getParent(); nodeInfo != null; nodeInfo = ((NodeImpl)nodeInfo).getParent()) {
            if (!(nodeInfo instanceof XSLOverride)) continue;
            this.compileError("xsl:apply-imports cannot be used in a template rule declared within xsl:override", "XTSE3460");
        }
    }

    @Override
    public Expression compile(Compilation withParamArray, ComponentDeclaration componentDeclaration) {
        ApplyImports applyImports = new ApplyImports();
        WithParam[] withParamArray2 = this.getWithParamInstructions(applyImports, (Compilation)withParamArray, componentDeclaration, false);
        withParamArray = this.getWithParamInstructions(applyImports, (Compilation)withParamArray, componentDeclaration, true);
        applyImports.setActualParams(withParamArray2);
        applyImports.setTunnelParams(withParamArray);
        return applyImports;
    }
}

