/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashMap;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.SimpleStepExpression;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.sort.SortExpression;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.RuleManager;
import net.sf.saxon.value.Whitespace;

public class XSLApplyTemplates
extends StyleElement {
    private Expression a;
    private StructuredQName b;
    private boolean c = false;
    private boolean d = false;
    private boolean e = true;
    private Mode f;
    private String g;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        block20: for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            switch (attributeCollection.getQName(i2)) {
                case "mode": {
                    this.g = Whitespace.trim(attributeCollection.getValue(i2));
                    continue block20;
                }
                case "select": {
                    String string = attributeCollection.getValue(i2);
                    this.a = this.makeExpression(string, i2);
                    this.e = false;
                    continue block20;
                }
                default: {
                    this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
                }
            }
        }
        if (this.g != null) {
            switch (this.g) {
                case "#current": {
                    this.c = true;
                    return;
                }
                case "#unnamed": {
                    this.b = Mode.UNNAMED_MODE_NAME;
                    return;
                }
                case "#default": {
                    return;
                }
            }
            try {
                this.b = this.makeQName(this.g);
                return;
            }
            catch (XPathException xPathException) {
                this.compileError("Mode name " + Err.wrap(this.g) + " is not a valid QName", xPathException.getErrorCodeQName());
                this.b = null;
            }
        }
    }

    @Override
    public void validate(ComponentDeclaration object) {
        HashMap<SymbolicName, Component> hashMap;
        Object object2;
        Object object3;
        if (this.c) {
            if (this.iterateAxis((byte)0, new NameTest(1, 200, this.getNamePool())).next() == null) {
                this.issueWarning("Specifying mode=\"#current\" when not inside an xsl:template serves no useful purpose", this);
            }
        } else {
            object3 = this.getPrincipalStylesheetModule();
            if (this.b == null) {
                this.b = this.getDefaultMode();
                if ((this.b == null || this.b.equals(Mode.UNNAMED_MODE_NAME)) && ((PrincipalStylesheetModule)object3).isDeclaredModes() && !((PrincipalStylesheetModule)object3).getRuleManager().isUnnamedModeExplicit()) {
                    this.compileError("The unnamed mode must be explicitly declared in an xsl:mode declaration", "XTSE3085");
                }
            } else if (this.b.equals(Mode.UNNAMED_MODE_NAME) && ((PrincipalStylesheetModule)object3).isDeclaredModes() && !((PrincipalStylesheetModule)object3).getRuleManager().isUnnamedModeExplicit()) {
                this.compileError("The #unnamed mode must be explicitly declared in an xsl:mode declaration", "XTSE3085");
            }
            object2 = new SymbolicName(174, this.b);
            object = ((ComponentDeclaration)object).getSourceElement().getContainingPackage();
            hashMap = ((StylesheetPackage)object).getComponentIndex();
            if ((object = hashMap.get(object2)) != null) {
                this.f = (Mode)((Component)object).getActor();
            }
            if (this.f == null) {
                if (((PrincipalStylesheetModule)object3).isDeclaredModes()) {
                    this.compileError("Mode name " + this.b.getDisplayName() + " must be explicitly declared in an xsl:mode declaration", "XTSE3085");
                }
                this.f = ((PrincipalStylesheetModule)object3).getRuleManager().obtainMode(this.b, true);
            }
        }
        object3 = this.iterateAxis((byte)3);
        while ((object2 = object3.next()) != null) {
            if (object2.getNodeKind() == 3) {
                if (Whitespace.isWhite(object2.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:apply-templates", "XTSE0010");
                continue;
            }
            if (object2 instanceof XSLSort || object2 instanceof XSLWithParam) continue;
            this.compileError("Invalid element " + Err.wrap(object2.getDisplayName(), 1) + " within xsl:apply-templates", "XTSE0010");
        }
        if (this.a == null) {
            object = new ContextItemExpression();
            hashMap = new RoleDiagnostic(13, "", 0);
            ((RoleDiagnostic)((Object)hashMap)).setErrorCode("XTTE0510");
            object = new ItemChecker((Expression)object, AnyNodeTest.getInstance(), (RoleDiagnostic)((Object)hashMap));
            this.a = new SimpleStepExpression((Expression)object, new AxisExpression(3, null));
            this.a.setLocation(this.allocateLocation());
            this.a.setRetainedStaticContext(this.makeRetainedStaticContext());
        }
        this.a = this.typeCheck("select", this.a);
    }

    @Override
    public boolean markTailCalls() {
        this.d = true;
        return true;
    }

    @Override
    public Expression compile(Compilation compilation, ComponentDeclaration componentDeclaration) {
        Object object = this.makeSortKeys(compilation, componentDeclaration);
        if (object != null) {
            this.d = false;
        }
        assert (this.a != null);
        Expression expression = this.a;
        if (object != null) {
            expression = new SortExpression(this.a, (SortKeyDefinitionList)object);
        }
        this.compileSequenceConstructor(compilation, componentDeclaration, true);
        object = compilation.getPrincipalStylesheetModule().getRuleManager();
        object = new ApplyTemplates(expression, this.c, this.d, this.e, this.isWithinDeclaredStreamableConstruct(), this.f, (RuleManager)object);
        ((ApplyTemplates)object).setActualParams(this.getWithParamInstructions((Expression)object, compilation, componentDeclaration, false));
        ((ApplyTemplates)object).setTunnelParams(this.getWithParamInstructions((Expression)object, compilation, componentDeclaration, true));
        return object;
    }
}

