/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.AttributeCreator;
import net.sf.saxon.expr.instruct.ComputedAttribute;
import net.sf.saxon.expr.instruct.FixedAttribute;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.XSLLeafNodeConstructor;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public final class XSLAttribute
extends XSLLeafNodeConstructor {
    private Expression a;
    private Expression b;
    private Expression c = null;
    private int d = 3;
    private SimpleType e;

    @Override
    public final void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string7 = attributeCollection.getQName(i2);
            if (string7.equals("name")) {
                string = Whitespace.trim(attributeCollection.getValue(i2));
                this.a = this.makeAttributeValueTemplate(string, i2);
                continue;
            }
            if (string7.equals("namespace")) {
                string2 = Whitespace.trim(attributeCollection.getValue(i2));
                this.c = this.makeAttributeValueTemplate(string2, i2);
                continue;
            }
            if (string7.equals("select")) {
                string3 = attributeCollection.getValue(i2);
                this.select = this.makeExpression(string3, i2);
                continue;
            }
            if (string7.equals("separator")) {
                string4 = attributeCollection.getValue(i2);
                this.b = this.makeAttributeValueTemplate(string4, i2);
                continue;
            }
            if (string7.equals("validation")) {
                string5 = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (string7.equals("type")) {
                string6 = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        if (this.a instanceof StringLiteral) {
            if (!NameChecker.isQName(((StringLiteral)this.a).getStringValue())) {
                this.c("Attribute name " + Err.wrap(string) + " is not a valid QName");
            }
            if (string.equals("xmlns") && this.c == null) {
                this.c("Invalid attribute name: xmlns");
            }
            if (string.startsWith("xmlns:")) {
                if (string2 == null) {
                    this.c("Invalid attribute name: " + Err.wrap(string));
                } else {
                    string = string.substring(6);
                    this.a = new StringLiteral(string);
                }
            }
        }
        if (string2 != null && this.c instanceof StringLiteral && !StandardURIChecker.getInstance().isValidURI(((StringLiteral)this.c).getStringValue())) {
            this.compileError("The value of the namespace attribute must be a valid URI", "XTDE0865");
        }
        if (string4 == null) {
            this.b = string3 == null ? new StringLiteral(StringValue.EMPTY_STRING) : new StringLiteral(StringValue.SINGLE_SPACE);
        }
        this.d = string5 != null ? this.validateValidationAttribute(string5) : this.getDefaultValidation();
        if (string6 != null) {
            if (!this.isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            } else {
                SchemaType schemaType = this.getSchemaType(string6);
                if (schemaType == null) {
                    this.compileError("Unknown attribute type " + string6, "XTSE1520");
                } else if (schemaType.isSimpleType()) {
                    this.e = (SimpleType)schemaType;
                } else {
                    this.compileError("Type annotation for attributes must be a simple type", "XTSE1530");
                }
                this.d = 8;
            }
        }
        if (string6 != null && string5 != null) {
            this.compileError("The validation and type attributes are mutually exclusive", "XTSE1505");
            this.d = this.getDefaultValidation();
            this.e = null;
        }
    }

    private void c(String string) {
        this.compileErrorInAttribute(string, "XTDE0850", "name");
        this.a = new StringLiteral("saxon-error-attribute");
    }

    @Override
    public final void validate(ComponentDeclaration componentDeclaration) {
        if (this.e != null && this.e.isNamespaceSensitive()) {
            this.compileErrorInAttribute("Validation at attribute level must not specify a namespace-sensitive type (xs:QName or xs:NOTATION)", "XTTE1545", "type");
        }
        this.a = this.typeCheck("name", this.a);
        this.c = this.typeCheck("namespace", this.c);
        this.select = this.typeCheck("select", this.select);
        this.b = this.typeCheck("separator", this.b);
        super.validate(componentDeclaration);
    }

    @Override
    protected final String getErrorCodeForSelectPlusContent() {
        return "XTSE0840";
    }

    @Override
    public final Instruction compile(Compilation compilation, ComponentDeclaration componentDeclaration) {
        Object object;
        Object object2 = null;
        if (this.a instanceof StringLiteral) {
            object = Whitespace.trim(((StringLiteral)this.a).getStringValue());
            try {
                object = NameChecker.getQNameParts((CharSequence)object);
            }
            catch (QNameException qNameException) {
                return null;
            }
            if (this.c == null) {
                object2 = "";
                if (!object[0].equals("") && (object2 = this.getURIForPrefix((String)object[0], false)) == null) {
                    this.undeclaredNamespaceError((String)object[0], "XTDE0860", "name");
                    return null;
                }
                FingerprintedQName fingerprintedQName = new FingerprintedQName((String)object[0], (String)object2, (String)object[1]);
                fingerprintedQName.obtainFingerprint(this.getNamePool());
                FixedAttribute fixedAttribute = new FixedAttribute(fingerprintedQName, this.d, this.e);
                fixedAttribute.setInstruction(true);
                fixedAttribute.setLocation(this.allocateLocation());
                this.compileContent(compilation, componentDeclaration, fixedAttribute, this.b);
                return fixedAttribute;
            }
            if (this.c instanceof StringLiteral) {
                Object object3;
                Object object4;
                object2 = ((StringLiteral)this.c).getStringValue();
                if (((String)object2).equals("")) {
                    object[0] = "";
                } else if (((String)object[0]).equals("")) {
                    object4 = this.iterateAxis((byte)8);
                    while ((object3 = object4.next()) != null) {
                        if (!object3.getStringValue().equals(object2)) continue;
                        object[0] = object3.getLocalPart();
                        break;
                    }
                    if (((String)object[0]).equals("") && (object4 = this.getNamePool().suggestPrefixForURI(((StringLiteral)this.c).getStringValue())) != null) {
                        object[0] = object4;
                    }
                    if (((String)object[0]).equals("")) {
                        object[0] = "ns0";
                    }
                }
                object4 = new FingerprintedQName((String)object[0], (String)object2, (String)object[1]);
                object4.obtainFingerprint(this.getNamePool());
                object3 = new FixedAttribute((NodeName)object4, this.d, this.e);
                ((AttributeCreator)object3).setInstruction(true);
                this.compileContent(compilation, componentDeclaration, (SimpleNodeConstructor)object3, this.b);
                return object3;
            }
        } else if (this.c == null) {
            object2 = this.makeNamespaceContext();
        }
        object = new ComputedAttribute(this.a, this.c, (NamespaceResolver)object2, this.d, this.e, false);
        ((AttributeCreator)object).setInstruction(true);
        ((Expression)object).setLocation(this.allocateLocation());
        this.compileContent(compilation, componentDeclaration, (SimpleNodeConstructor)object, this.b);
        return object;
    }
}

