/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UseAttributeSet;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.XSLAttribute;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.AttributeLocation;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.value.Whitespace;

public class XSLAttributeSet
extends StyleElement
implements StylesheetComponent {
    private String a;
    private String b;
    private String c;
    private SlotManager d;
    private List<ComponentDeclaration> e = new ArrayList<ComponentDeclaration>();
    private StructuredQName[] f;
    private List<Expression> g = new ArrayList<Expression>();
    private boolean h = false;
    private Visibility i;
    private boolean j = false;

    @Override
    public AttributeSet getActor() {
        return (AttributeSet)this.getPrincipalStylesheetModule().getStylesheetPackage().getComponent(new SymbolicName(136, ((StyleElement)this).getObjectName())).getActor();
    }

    @Override
    public SymbolicName getSymbolicName() {
        return new SymbolicName(136, ((StyleElement)this).getObjectName());
    }

    @Override
    public void checkCompatibility(Component component) {
        if (((AttributeSet)component.getActor()).isDeclaredStreamable() && !this.isDeclaredStreamable()) {
            this.compileError("The overridden attribute set is declared streamable, so the overriding attribute set must also be declared streamable");
        }
    }

    @Override
    public boolean isDeclaration() {
        return true;
    }

    public StructuredQName getAttributeSetName() {
        return ((StyleElement)this).getObjectName();
    }

    public boolean isDeclaredStreamable() {
        return this.j;
    }

    @Override
    public void prepareAttributes() {
        this.b = null;
        String string = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string2 = attributeCollection.getQName(i2);
            if (string2.equals("name")) {
                this.a = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (string2.equals("use-attribute-sets")) {
                this.b = attributeCollection.getValue(i2);
                continue;
            }
            if (string2.equals("streamable")) {
                string = attributeCollection.getValue(i2);
                continue;
            }
            if (string2.equals("visibility")) {
                this.c = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (this.a == null) {
            this.reportAbsence("name");
            this.setObjectName(new StructuredQName("", "", "attribute-set-error-name"));
            return;
        }
        this.i = this.c == null ? Visibility.PRIVATE : this.interpretVisibilityValue(this.c, "");
        if (string != null) {
            this.j = this.b(string);
        }
        try {
            XSLAttributeSet xSLAttributeSet = this;
            xSLAttributeSet.setObjectName(xSLAttributeSet.makeQName(this.a));
            return;
        }
        catch (XPathException xPathException) {
            this.setObjectName(new StructuredQName("", "", "attribute-set-error-name"));
            xPathException.setLocation(new AttributeLocation(this, StructuredQName.fromClarkName("name")));
            throw xPathException;
        }
    }

    @Override
    public StructuredQName getObjectName() {
        StructuredQName structuredQName = super.getObjectName();
        if (structuredQName == null) {
            try {
                this.prepareAttributes();
                structuredQName = ((StyleElement)this).getObjectName();
            }
            catch (XPathException xPathException) {
                structuredQName = new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-attribute-set");
                this.setObjectName(structuredQName);
            }
        }
        return structuredQName;
    }

    @Override
    public void validate(ComponentDeclaration object) {
        NodeInfo nodeInfo;
        if (this.h) {
            return;
        }
        this.checkTopLevel("XTSE0010", true);
        this.d = ((NodeImpl)this).getConfiguration().makeSlotManager();
        object = this.iterateAxis((byte)3);
        while ((nodeInfo = object.next()) != null) {
            if (nodeInfo instanceof XSLAttribute) {
                if (this.i != Visibility.ABSTRACT) continue;
                this.compileError("An abstract attribute-set must contain no xsl:attribute instructions");
                continue;
            }
            this.compileError("Only xsl:attribute is allowed within xsl:attribute-set", "XTSE0010");
        }
        if (this.b != null) {
            if (this.i == Visibility.ABSTRACT) {
                this.compileError("An abstract attribute-set must have no @use-attribute-sets attribute");
            }
            this.f = this.getUsedAttributeSets(this.b);
        }
        this.h = true;
    }

    public StructuredQName[] getUseAttributeSetNames() {
        return this.f;
    }

    @Override
    public void index(ComponentDeclaration componentDeclaration, PrincipalStylesheetModule principalStylesheetModule) {
        principalStylesheetModule.indexAttributeSet(componentDeclaration);
    }

    public void checkCircularity(XSLAttributeSet xSLAttributeSet) {
        if (this == xSLAttributeSet) {
            this.compileError("The definition of the attribute set is circular", "XTSE0720");
            return;
        }
        if (!this.h) {
            return;
        }
        if (this.e != null) {
            for (ComponentDeclaration componentDeclaration : this.e) {
                XSLAttributeSet object = (XSLAttributeSet)componentDeclaration.getSourceElement();
                object.checkCircularity(xSLAttributeSet);
                if (!this.j || object.j) continue;
                this.compileError("Attribute-set is declared streamable but references a non-streamable attribute set " + object.getAttributeSetName().getDisplayName(), "XTSE3430");
            }
        }
    }

    public List<Expression> getContainedInstructions() {
        return this.g;
    }

    @Override
    public SlotManager getSlotManager() {
        return this.d;
    }

    @Override
    public void compileDeclaration(Compilation compilation, ComponentDeclaration componentDeclaration) {
        Object object;
        Object object2;
        if (this.isActionCompleted(2)) {
            return;
        }
        if (this.b != null) {
            List<UseAttributeSet> list = UseAttributeSet.makeUseAttributeSetInstructions(this.f, this);
            if (!list.isEmpty()) {
                this.g.add(UseAttributeSet.makeCompositeExpression(list));
            }
            object2 = this.f;
            int n2 = this.f.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                StructuredQName structuredQName = object2[i2];
                this.getPrincipalStylesheetModule().getAttributeSets(structuredQName, this.e);
            }
            for (ComponentDeclaration componentDeclaration2 : this.e) {
                ((XSLAttributeSet)componentDeclaration2.getSourceElement()).checkCircularity(this);
            }
            if (this.j) {
                for (ComponentDeclaration componentDeclaration3 : this.e) {
                    if (((XSLAttributeSet)componentDeclaration3.getSourceElement()).j) continue;
                    this.compileError("Attribute set is declared streamable, but references an attribute set that is not declared streamable", "XTSE0730");
                }
            }
        }
        object2 = this.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        while ((object = (XSLAttribute)object2.next()) != null) {
            object = ((XSLAttribute)object).compile(compilation, componentDeclaration);
            ((Expression)object).setRetainedStaticContext(this.makeRetainedStaticContext());
            object = ((Expression)object).simplify();
            if (compilation.getCompilerInfo().isCompileWithTracing()) {
                object = XSLAttributeSet.makeTraceInstruction(this, (Expression)object);
            }
            this.g.add((Expression)object);
        }
        this.setActionCompleted(2);
    }

    @Override
    public void optimize(ComponentDeclaration componentDeclaration) {
    }

    @Override
    public int getConstructType() {
        return 136;
    }

    @Override
    public void generateByteCode(Optimizer optimizer) {
    }
}

