/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.BreakInstr;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.XSLBreakOrContinue;

public class XSLBreak
extends XSLBreakOrContinue {
    private Expression a;

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string = attributeCollection.getQName(i2);
            if (string.equals("select")) {
                string = attributeCollection.getValue(i2);
                this.a = this.makeExpression(string, i2);
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
    }

    @Override
    protected boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        this.validatePosition();
        if (this.xslIterate == null) {
            this.compileError(this.getDisplayName() + " must be a descendant of an xsl:iterate instruction", "XTSE3120");
        }
        if (this.a != null && this.iterateAxis((byte)3).next() != null) {
            this.compileError("An xsl:break element with a select attribute must be empty", "XTSE3125");
        }
        this.a = this.typeCheck("select", this.a);
    }

    @Override
    public Expression compile(Compilation object, ComponentDeclaration componentDeclaration) {
        Expression expression = this.a;
        if (expression == null) {
            expression = this.compileSequenceConstructor((Compilation)object, componentDeclaration, false);
        }
        object = new BreakInstr();
        ((Expression)object).setRetainedStaticContext(this.makeRetainedStaticContext());
        return Block.makeBlock(expression, (Expression)object);
    }
}

