/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.CallTemplate;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLCallTemplate
extends StyleElement {
    private static StructuredQName a = new StructuredQName("saxon", "http://saxon.sf.net/", "error-template");
    private StructuredQName b;
    private NamedTemplate c = null;
    private boolean d = false;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string2 = attributeCollection.getQName(i2);
            if (string2.equals("name")) {
                string = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (string == null) {
            this.b = a;
            this.reportAbsence("name");
            return;
        }
        try {
            this.b = this.makeQName(string);
            return;
        }
        catch (XPathException xPathException) {
            this.b = a;
            this.compileErrorInAttribute(xPathException.getMessage(), xPathException.getErrorCodeLocalPart(), "name");
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void validate(ComponentDeclaration var1_1) {
        block4: {
            var1_1 = this.iterateAxis((byte)3);
            while ((var2_2 = var1_1.next()) != null) {
                if (var2_2 instanceof XSLWithParam || var2_2 instanceof XSLFallback && this.mayContainFallback()) continue;
                if (var2_2.getNodeKind() == 3) {
                    if (Whitespace.isWhite(var2_2.getStringValueCS())) continue;
                    this.compileError("No character data is allowed within xsl:call-template", "XTSE0010");
                    continue;
                }
                this.compileError("Child element " + Err.wrap(var2_2.getDisplayName(), 1) + " is not allowed as a child of xsl:call-template", "XTSE0010");
            }
            if (this.b.equals(XSLCallTemplate.a)) break block4;
            var2_2 = this.b;
            var1_1 = this;
            var3_3 = var1_1.getPrincipalStylesheetModule();
            if ((var3_3 = var3_3.getNamedTemplate((StructuredQName)var2_2)) != null) ** GOTO lbl19
            if (var2_2.hasURI("http://www.w3.org/1999/XSL/Transform") && var2_2.getLocalPart().equals("original")) {
                v0 = (NamedTemplate)var1_1.getXslOriginal(200);
            } else {
                var1_1.compileError("Cannot find a template named " + var1_1.b, "XTSE0650");
lbl19:
                // 2 sources

                v0 = var3_3;
            }
            var1_1.c = v0;
        }
    }

    @Override
    public void postValidate() {
        if (this.c != null) {
            NodeInfo nodeInfo;
            boolean bl2;
            Object object;
            XSLCallTemplate xSLCallTemplate = this;
            List<NamedTemplate.LocalParamInfo> list = xSLCallTemplate.c.getLocalParamDetails();
            for (NamedTemplate.LocalParamInfo object22 : list) {
                Object object2;
                if (!object22.isRequired || object22.isTunnel) continue;
                object = xSLCallTemplate.iterateAxis((byte)3);
                bl2 = false;
                while ((object2 = object.next()) != null) {
                    if (!(object2 instanceof XSLWithParam) || !((XSLWithParam)object2).getVariableQName().equals(object22.name)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                xSLCallTemplate.compileError("No value supplied for required parameter " + Err.wrap(object22.name.getDisplayName(), 5), "XTSE0690");
            }
            AxisIterator axisIterator = xSLCallTemplate.iterateAxis((byte)3);
            while ((nodeInfo = axisIterator.next()) != null) {
                if (!(nodeInfo instanceof XSLWithParam) || ((XSLWithParam)nodeInfo).isTunnelParam()) continue;
                object = (XSLWithParam)nodeInfo;
                bl2 = false;
                for (NamedTemplate.LocalParamInfo localParamInfo : list) {
                    if (!localParamInfo.name.equals(((XSLGeneralVariable)object).getVariableQName()) || localParamInfo.isTunnel) continue;
                    bl2 = true;
                    SequenceType sequenceType = localParamInfo.requiredType;
                    ((XSLWithParam)object).checkAgainstRequiredType(sequenceType);
                    break;
                }
                if (bl2 || xSLCallTemplate.xPath10ModeIsEnabled()) continue;
                xSLCallTemplate.compileError("Parameter " + ((XSLGeneralVariable)object).getVariableQName().getDisplayName() + " is not declared in the called template", "XTSE0680");
            }
            return;
        }
        throw new AssertionError((Object)"Target template not known");
    }

    @Override
    public boolean markTailCalls() {
        this.d = true;
        return true;
    }

    @Override
    public Expression compile(Compilation compilation, ComponentDeclaration componentDeclaration) {
        if (this.c == null) {
            return null;
        }
        CallTemplate callTemplate = new CallTemplate(this.c, this.b, this.d, this.isWithinDeclaredStreamableConstruct());
        callTemplate.setLocation(this.allocateLocation());
        callTemplate.setActualParameters(this.getWithParamInstructions(callTemplate, compilation, componentDeclaration, false), this.getWithParamInstructions(callTemplate, compilation, componentDeclaration, true));
        return callTemplate;
    }
}

