/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.pattern.UnionQNameTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLTry;
import net.sf.saxon.tree.linked.NodeImpl;

public class XSLCatch
extends StyleElement {
    private Expression a;
    private QNameTest b;

    @Override
    public boolean isInstruction() {
        return false;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    protected boolean seesAvuncularVariables() {
        return false;
    }

    @Override
    public void prepareAttributes() {
        String string = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string2 = attributeCollection.getQName(i2);
            if (string2.equals("select")) {
                string2 = attributeCollection.getValue(i2);
                this.a = this.makeExpression(string2, i2);
                continue;
            }
            if (string2.equals("errors")) {
                string = attributeCollection.getValue(i2);
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (string == null) {
            this.b = AnyNodeTest.getInstance();
            return;
        }
        List<QNameTest> list = this.c(string);
        if (list.size() == 0) {
            this.compileError("xsl:catch/@errors must not be empty");
        }
        if (list.size() == 1) {
            this.b = list.get(0);
            return;
        }
        this.b = new UnionQNameTest(list);
    }

    private List<QNameTest> c(String object) {
        ArrayList<QNameTest> arrayList = new ArrayList<QNameTest>();
        object = new StringTokenizer((String)object, " \t\n\r", false);
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string;
            Object object2;
            String string2;
            Object object3 = ((StringTokenizer)object).nextToken();
            if (((String)object3).equals("*")) {
                object3 = AnyNodeTest.getInstance();
                arrayList.add((QNameTest)object3);
                continue;
            }
            if (((String)object3).endsWith(":*")) {
                if (((String)object3).length() == 2) {
                    this.compileError("No prefix before ':*'");
                    arrayList.add(AnyNodeTest.getInstance());
                }
                string2 = ((String)object3).substring(0, ((String)object3).length() - 2);
                string2 = this.getURIForPrefix(string2, false);
                object3 = new NamespaceTest(this.getNamePool(), 1, string2);
                arrayList.add((QNameTest)object3);
                continue;
            }
            if (((String)object3).startsWith("*:")) {
                if (((String)object3).length() == 2) {
                    this.compileErrorInAttribute("No local name after '*:'", "XTSE0010", "errors");
                    arrayList.add(AnyNodeTest.getInstance());
                }
                string2 = ((String)object3).substring(2);
                object3 = new LocalNameTest(this.getNamePool(), 1, string2);
                arrayList.add((QNameTest)object3);
                continue;
            }
            try {
                object2 = NameChecker.getQNameParts((CharSequence)object3);
                string2 = object2[0];
                if (object2[0].equals("")) {
                    string = "";
                } else {
                    string = this.getURIForPrefix(string2, false);
                    if (string == null) {
                        this.undeclaredNamespaceError(string2, "XTSE0280", "errors");
                        arrayList.add(AnyNodeTest.getInstance());
                        break;
                    }
                }
                string2 = object2[1];
            }
            catch (QNameException qNameException) {
                this.compileErrorInAttribute("Error code " + (String)object3 + " is not a valid QName", "XTSE0280", "errors");
                arrayList.add(AnyNodeTest.getInstance());
                break;
            }
            object2 = this.getNamePool();
            int n2 = object2.allocateFingerprint(string, string2);
            object3 = new NameTest(1, n2, this.getNamePool());
            arrayList.add((QNameTest)object3);
        }
        return arrayList;
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        this.a = this.typeCheck("select", this.a);
        if (this.a != null && ((NodeImpl)this).hasChildNodes()) {
            this.compileError("An xsl:catch element with a select attribute must be empty", "XTSE3150");
        }
        if (!(this.getParent() instanceof XSLTry)) {
            this.compileError("xsl:catch may appear only as a child of xsl:try");
        }
    }

    @Override
    public Expression compile(Compilation compilation, ComponentDeclaration componentDeclaration) {
        if (this.a == null) {
            this.a = this.compileSequenceConstructor(compilation, componentDeclaration, true);
        }
        ((XSLTry)this.getParent()).addCatchClause(this.b, this.a);
        return null;
    }
}

