/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLOutputCharacter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntHashMap;

public class XSLCharacterMap
extends StyleElement {
    private String a;
    private List<XSLCharacterMap> b = null;
    private boolean c = false;
    private boolean d = false;

    @Override
    public boolean isDeclaration() {
        return true;
    }

    public StructuredQName getCharacterMapName() {
        StructuredQName structuredQName = this.getObjectName();
        if (structuredQName == null) {
            try {
                XSLCharacterMap xSLCharacterMap = this;
                return xSLCharacterMap.makeQName(((NodeImpl)xSLCharacterMap).getAttributeValue("", "name"));
            }
            catch (Exception exception) {
                return new StructuredQName("", "", "unnamedCharacterMap_" + this.hashCode());
            }
        }
        return structuredQName;
    }

    public boolean isRedundant() {
        return this.d;
    }

    @Override
    public void prepareAttributes() {
        String string = null;
        this.a = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string2 = attributeCollection.getQName(i2);
            if (string2.equals("name")) {
                string = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (string2.equals("use-character-maps")) {
                this.a = attributeCollection.getValue(i2);
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (string == null) {
            this.reportAbsence("name");
            string = "unnamedCharacterMap_" + this.hashCode();
        }
        try {
            XSLCharacterMap xSLCharacterMap = this;
            xSLCharacterMap.setObjectName(xSLCharacterMap.makeQName(string));
            return;
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException.getMessage(), "XTSE0020");
            string = "unnamedCharacterMap_" + this.hashCode();
            this.setObjectName(new StructuredQName("", "", string));
            return;
        }
    }

    @Override
    public void validate(ComponentDeclaration object) {
        if (this.c) {
            return;
        }
        this.checkTopLevel("XTSE0010", false);
        this.iterateAxis((byte)3).forEachOrFail(nodeInfo -> {
            if (!(nodeInfo instanceof XSLOutputCharacter)) {
                this.compileError("Only xsl:output-character is allowed within xsl:character-map", "XTSE0010");
            }
        });
        PrincipalStylesheetModule principalStylesheetModule = this.getPrincipalStylesheetModule();
        Object object2 = principalStylesheetModule.getCharacterMap(this.getObjectName());
        if (object2 != null && ((ComponentDeclaration)object2).getSourceElement() != this) {
            if (((ComponentDeclaration)object).getPrecedence() == ((ComponentDeclaration)object2).getPrecedence()) {
                this.compileError("There are two character-maps with the same name and import precedence", "XTSE1580");
            } else if (((ComponentDeclaration)object).getPrecedence() < ((ComponentDeclaration)object2).getPrecedence()) {
                this.d = true;
            }
        }
        if (this.a != null) {
            this.b = new ArrayList<XSLCharacterMap>(5);
            object = new StringTokenizer(this.a, " \t\n\r", false);
            while (((StringTokenizer)object).hasMoreTokens()) {
                object2 = ((StringTokenizer)object).nextToken();
                try {
                    StructuredQName structuredQName;
                    ComponentDeclaration componentDeclaration;
                    String[] qNameException = NameChecker.getQNameParts(object2);
                    String string = this.getURIForPrefix(qNameException[0], false);
                    if (string == null) {
                        this.compileError("Undeclared namespace prefix " + Err.wrap(qNameException[0]) + " in character map name", "XTSE0280");
                    }
                    if ((componentDeclaration = principalStylesheetModule.getCharacterMap(structuredQName = new StructuredQName(qNameException[0], string, qNameException[1]))) == null) {
                        this.compileError("No character-map named '" + (String)object2 + "' has been defined", "XTSE1590");
                        continue;
                    }
                    object2 = (XSLCharacterMap)componentDeclaration.getSourceElement();
                    this.b.add((XSLCharacterMap)object2);
                }
                catch (QNameException qNameException) {
                    this.compileError("Invalid character-map name. " + qNameException.getMessage(), "XTSE1590");
                }
            }
            for (XSLCharacterMap xSLCharacterMap : this.b) {
                xSLCharacterMap.a(this);
            }
        }
        this.c = true;
    }

    private void a(XSLCharacterMap xSLCharacterMap) {
        if (this == xSLCharacterMap) {
            this.compileError("The definition of the character map is circular", "XTSE1600");
            this.b = null;
            return;
        }
        if (!this.c) {
            return;
        }
        if (this.b != null) {
            for (XSLCharacterMap xSLCharacterMap2 : this.b) {
                xSLCharacterMap2.a(xSLCharacterMap);
            }
        }
    }

    public void assemble(IntHashMap<String> intHashMap) {
        if (this.b != null) {
            for (XSLCharacterMap nodeInfo : this.b) {
                nodeInfo.assemble(intHashMap);
            }
        }
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = axisIterator.next()) != null) {
            XSLOutputCharacter xSLOutputCharacter = (XSLOutputCharacter)nodeInfo;
            intHashMap.put(xSLOutputCharacter.getCodePoint(), xSLOutputCharacter.getReplacementString());
        }
        return;
    }

    @Override
    public void compileDeclaration(Compilation compilation, ComponentDeclaration componentDeclaration) {
    }
}

