/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Arrays;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLOtherwise;
import net.sf.saxon.style.XSLWhen;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.BooleanValue;

public class XSLChoose
extends StyleElement {
    private StyleElement a;
    private int b = 0;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
    }

    @Override
    public void validate(ComponentDeclaration object) {
        NodeInfo nodeInfo;
        object = this.iterateAxis((byte)3);
        while ((nodeInfo = object.next()) != null) {
            if (nodeInfo instanceof XSLWhen) {
                if (this.a != null) {
                    this.a.compileError("xsl:otherwise must come last", "XTSE0010");
                }
                ++this.b;
                continue;
            }
            if (nodeInfo instanceof XSLOtherwise) {
                if (this.a != null) {
                    ((XSLOtherwise)nodeInfo).compileError("Only one xsl:otherwise is allowed in an xsl:choose", "XTSE0010");
                    continue;
                }
                this.a = (StyleElement)nodeInfo;
                continue;
            }
            if (nodeInfo instanceof StyleElement) {
                ((StyleElement)nodeInfo).compileError("Only xsl:when and xsl:otherwise are allowed here", "XTSE0010");
                continue;
            }
            this.compileError("Only xsl:when and xsl:otherwise are allowed within xsl:choose", "XTSE0010");
        }
        if (this.b == 0) {
            this.compileError("xsl:choose must contain at least one xsl:when", "XTSE0010");
        }
    }

    @Override
    public boolean markTailCalls() {
        boolean bl2 = false;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = axisIterator.next()) != null) {
            if (!(nodeInfo instanceof StyleElement)) continue;
            bl2 |= ((StyleElement)nodeInfo).markTailCalls();
        }
        return bl2;
    }

    @Override
    public Expression compile(Compilation compilation, ComponentDeclaration componentDeclaration) {
        Object object;
        int n2 = this.b + (this.a == null ? 0 : 1);
        Expression[] expressionArray = new Expression[n2];
        Expression[] expressionArray2 = new Expression[n2];
        int n3 = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((object = axisIterator.next()) != null) {
            Expression expression;
            if (object instanceof XSLWhen) {
                expressionArray[n3] = ((XSLWhen)object).getCondition();
                expression = ((XSLWhen)object).compileSequenceConstructor(compilation, componentDeclaration, true);
                if (expression == null) {
                    expression = Literal.makeEmptySequence();
                }
                try {
                    expressionArray2[n3] = expression = expression.simplify();
                }
                catch (XPathException xPathException) {
                    this.compileError(xPathException);
                }
                if (this.getCompilation().getCompilerInfo().isCompileWithTracing()) {
                    expressionArray2[n3] = XSLChoose.makeTraceInstruction((XSLWhen)object, expressionArray2[n3]);
                }
                if (expressionArray[n3] instanceof Literal && ((Literal)expressionArray[n3]).getValue() instanceof BooleanValue) {
                    if (((BooleanValue)((Literal)expressionArray[n3]).getValue()).getBooleanValue()) {
                        n2 = n3 + 1;
                        break;
                    }
                    --n3;
                    --n2;
                }
                ++n3;
                continue;
            }
            if (!(object instanceof XSLOtherwise)) continue;
            expression = Literal.makeLiteral(BooleanValue.TRUE);
            expression.setRetainedStaticContext(this.makeRetainedStaticContext());
            expressionArray[n3] = expression;
            expression = ((XSLOtherwise)object).compileSequenceConstructor(compilation, componentDeclaration, true);
            if (expression == null) {
                expression = Literal.makeEmptySequence();
                expression.setRetainedStaticContext(this.makeRetainedStaticContext());
            }
            try {
                expressionArray2[n3] = expression = expression.simplify();
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
            if (this.getCompilation().getCompilerInfo().isCompileWithTracing()) {
                expressionArray2[n3] = XSLChoose.makeTraceInstruction((XSLOtherwise)object, expressionArray2[n3]);
            }
            ++n3;
        }
        if (expressionArray.length != n2) {
            if (n2 == 0) {
                return null;
            }
            if (n2 == 1 && expressionArray[0] instanceof Literal && ((Literal)expressionArray[0]).getValue() instanceof BooleanValue) {
                if (((BooleanValue)((Literal)expressionArray[0]).getValue()).getBooleanValue()) {
                    return expressionArray2[0];
                }
                return null;
            }
            expressionArray = Arrays.copyOf(expressionArray, n2);
            expressionArray2 = Arrays.copyOf(expressionArray2, n2);
        }
        object = new Choose(expressionArray, expressionArray2);
        ((Choose)object).setInstruction(true);
        return object;
    }
}

