/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLContextItem
extends StyleElement {
    private ItemType a = AnyItemType.getInstance();
    private boolean b = true;
    private boolean c = false;

    @Override
    public void prepareAttributes() {
        String string = null;
        String string2 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        block20: for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            switch (attributeCollection.getQName(i2)) {
                case "as": {
                    string = Whitespace.trim(attributeCollection.getValue(i2));
                    continue block20;
                }
                case "use": {
                    string2 = Whitespace.trim(attributeCollection.getValue(i2));
                    continue block20;
                }
                default: {
                    this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
                }
            }
        }
        if (string != null) {
            SequenceType sequenceType;
            try {
                sequenceType = this.makeSequenceType(string);
            }
            catch (XPathException xPathException) {
                sequenceType = SequenceType.SINGLE_ITEM;
                this.compileErrorInAttribute(xPathException.getMessage(), xPathException.getErrorCodeLocalPart(), "as");
            }
            if (sequenceType.getCardinality() != 16384) {
                this.compileError("The xsl:context-item/@use attribute must be an item type (no occurrence indicator allowed)", "XTSE0020");
                return;
            }
            this.a = sequenceType.getPrimaryType();
        }
        if (string2 != null) {
            switch (string2) {
                case "required": {
                    this.b = false;
                    break;
                }
                case "optional": {
                    break;
                }
                case "absent": {
                    this.c = true;
                    break;
                }
                default: {
                    this.invalidAttribute("use", "required|optional|absent");
                }
            }
        }
        if (string != null && this.c) {
            this.compileError("The 'as' attribute must be omitted when use='absent' is specified", "XTSE3089");
        }
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        if (!(this.getParent() instanceof XSLTemplate)) {
            this.compileError("xsl:context-item can appear only as a child of xsl:template");
            return;
        }
        if (this.b && ((XSLTemplate)this.getParent()).getTemplateName() == null) {
            this.compileError("xsl:context-item appearing in an xsl:template declaration with no name attribute must specify use=required", "XTSE0020");
        }
        ((XSLTemplate)this.getParent()).setContextItemRequirements(this.a, this.b, this.c);
        this.iterateAxis((byte)11).forEachOrFail(nodeInfo -> {
            if (nodeInfo.getNodeKind() != 3 || !Whitespace.isWhite(nodeInfo.getStringValueCS())) {
                this.compileError("xsl:context-item must be the first child of xsl:template");
            }
        });
    }

    public ItemType getRequiredContextItemType() {
        return this.a;
    }

    public boolean isMayBeOmitted() {
        return this.b;
    }

    public boolean isAbsentFocus() {
        return this.c;
    }
}

