/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.ComputedElement;
import net.sf.saxon.expr.instruct.ElementCreator;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.expr.instruct.UseAttributeSet;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public class XSLElement
extends StyleElement {
    private Expression a;
    private Expression b = null;
    private String c;
    private StructuredQName[] d = null;
    private int e;
    private SchemaType f = null;
    private boolean g = true;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string6 = attributeCollection.getQName(i2);
            if (string6.equals("name")) {
                string = Whitespace.trim(attributeCollection.getValue(i2));
                this.a = this.makeAttributeValueTemplate(string, i2);
                continue;
            }
            if (string6.equals("namespace")) {
                string2 = attributeCollection.getValue(i2);
                this.b = this.makeAttributeValueTemplate(string2, i2);
                continue;
            }
            if (string6.equals("validation")) {
                string3 = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (string6.equals("type")) {
                string4 = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (string6.equals("inherit-namespaces")) {
                string5 = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (string6.equals("use-attribute-sets")) {
                this.c = attributeCollection.getValue(i2);
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (string == null) {
            this.reportAbsence("name");
        } else if (this.a instanceof StringLiteral && !NameChecker.isQName(((StringLiteral)this.a).getStringValue())) {
            this.compileError("Element name " + Err.wrap(((StringLiteral)this.a).getStringValue()) + " is not a valid QName", "XTDE0820");
            this.a = new StringLiteral("saxon-error-element");
        }
        if (string2 != null && this.b instanceof StringLiteral && !StandardURIChecker.getInstance().isValidURI(((StringLiteral)this.b).getStringValue())) {
            this.compileError("The value of the namespace attribute must be a valid URI", "XTDE0835");
        }
        this.e = string3 != null ? this.validateValidationAttribute(string3) : this.getDefaultValidation();
        if (string4 != null) {
            if (!this.isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.f = this.getSchemaType(string4);
            this.e = 8;
        }
        if (string4 != null && string3 != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
        if (string5 != null) {
            this.g = this.processBooleanAttribute("inherit-namespaces", string5);
        }
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        if (this.c != null) {
            this.d = this.getUsedAttributeSets(this.c);
        }
        this.a = this.typeCheck("name", this.a);
        this.b = this.typeCheck("namespace", this.b);
    }

    @Override
    public Expression compile(Compilation compilation, ComponentDeclaration componentDeclaration) {
        Object object;
        if (this.a instanceof StringLiteral) {
            String[] stringArray;
            object = ((StringLiteral)this.a).getStringValue();
            try {
                stringArray = NameChecker.getQNameParts((CharSequence)object);
            }
            catch (QNameException qNameException) {
                this.compileErrorInAttribute("Invalid element name: " + object, "XTDE0820", "name");
                return null;
            }
            object = null;
            if (this.b instanceof StringLiteral) {
                object = ((StringLiteral)this.b).getStringValue();
                if (((String)object).isEmpty()) {
                    stringArray[0] = "";
                }
            } else if (this.b == null && (object = this.getURIForPrefix(stringArray[0], true)) == null) {
                this.undeclaredNamespaceError(stringArray[0], "XTDE0830", "name");
            }
            if (object != null) {
                object = new FingerprintedQName(stringArray[0], (String)object, stringArray[1]);
                ((FingerprintedQName)object).obtainFingerprint(this.getNamePool());
                object = new FixedElement((NodeName)object, NamespaceBinding.EMPTY_ARRAY, this.g, true, this.f, this.e);
                ((Expression)object).setLocation(this.allocateLocation());
                return this.a(compilation, componentDeclaration, (ElementCreator)object);
            }
        }
        object = new ComputedElement(this.a, this.b, this.f, this.e, this.g, false);
        ((Expression)object).setLocation(this.allocateLocation());
        return this.a(compilation, componentDeclaration, (ElementCreator)object);
    }

    private ElementCreator a(Compilation object, ComponentDeclaration object2, ElementCreator elementCreator) {
        object = this.compileSequenceConstructor((Compilation)object, (ComponentDeclaration)object2, true);
        if (this.d != null) {
            object2 = UseAttributeSet.makeUseAttributeSets(this.d, this);
            if (object == null) {
                object = object2;
            } else {
                object = Block.makeBlock((Expression)object2, (Expression)object);
                ((Expression)object).setLocation(this.allocateLocation());
            }
        }
        if (object == null) {
            object = Literal.makeEmptySequence();
        }
        elementCreator.setContentExpression((Expression)object);
        return elementCreator;
    }
}

