/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLEvaluate
extends StyleElement {
    private Expression a = null;
    private SequenceType b = SequenceType.ANY_SEQUENCE;
    private Expression c = null;
    private Expression d = null;
    private Expression e = null;
    private Expression f = null;
    private Expression g = null;
    private Expression h = null;
    private boolean i;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected boolean isPermittedChild(StyleElement styleElement) {
        return styleElement instanceof XSLLocalParam;
    }

    protected ItemType getReturnedItemType() {
        return AnyItemType.getInstance();
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        block20: for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            switch (attributeCollection.getQName(i2)) {
                case "xpath": {
                    string = attributeCollection.getValue(i2);
                    this.a = this.makeExpression(string, i2);
                    continue block20;
                }
                case "as": {
                    string2 = attributeCollection.getValue(i2);
                    continue block20;
                }
                case "context-item": {
                    string3 = attributeCollection.getValue(i2);
                    this.d = this.makeExpression(string3, i2);
                    continue block20;
                }
                case "base-uri": {
                    String string6 = attributeCollection.getValue(i2);
                    this.e = this.makeAttributeValueTemplate(string6, i2);
                    continue block20;
                }
                case "namespace-context": {
                    String string6 = attributeCollection.getValue(i2);
                    this.c = this.makeExpression(string6, i2);
                    continue block20;
                }
                case "schema-aware": {
                    string4 = Whitespace.trim(attributeCollection.getValue(i2));
                    this.f = this.makeAttributeValueTemplate(string4, i2);
                    continue block20;
                }
                case "with-params": {
                    string5 = attributeCollection.getValue(i2);
                    this.g = this.makeExpression(string5, i2);
                    continue block20;
                }
                default: {
                    if (attributeCollection.getLocalName(i2).equals("options") && attributeCollection.getURI(i2).equals("http://saxon.sf.net/")) {
                        this.h = this.makeExpression(attributeCollection.getValue(i2), i2);
                        continue block20;
                    }
                    this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
                }
            }
        }
        if (string == null) {
            this.reportAbsence("xpath");
        }
        if (string2 != null) {
            this.b = this.makeSequenceType(string2);
            try {
                this.b = this.makeSequenceType(string2);
            }
            catch (XPathException xPathException) {
                this.compileErrorInAttribute(xPathException.getMessage(), xPathException.getErrorCodeLocalPart(), "as");
            }
        }
        if (string3 == null) {
            this.d = Literal.makeEmptySequence();
        }
        if (string4 == null) {
            this.f = new StringLiteral("no");
        } else if (this.f instanceof StringLiteral) {
            this.checkAttributeValue("schema-aware", string4, true, StyleElement.YES_NO);
        }
        if (string5 == null) {
            string5 = "map{}";
            this.g = this.makeExpression(string5, -1);
        }
        if (this.h == null) {
            this.h = this.makeExpression("map{}", -1);
        }
    }

    @Override
    public void validate(ComponentDeclaration object) {
        this.getContainingPackage().setRetainUnusedFunctions();
        if (this.a == null) {
            this.a = new StringLiteral("''");
        }
        this.a = this.typeCheck("xpath", this.a);
        this.e = this.typeCheck("base-uri", this.e);
        this.d = this.typeCheck("context-item", this.d);
        this.c = this.typeCheck("namespace-context", this.c);
        this.f = this.typeCheck("schema-aware", this.f);
        this.g = this.typeCheck("with-params", this.g);
        this.h = this.typeCheck("options", this.h);
        this.iterateAxis((byte)3).forEachOrFail(nodeInfo -> {
            if (!(nodeInfo instanceof XSLWithParam)) {
                if (nodeInfo instanceof XSLFallback) {
                    this.i = true;
                    return;
                }
                if (nodeInfo.getNodeKind() == 3) {
                    if (!Whitespace.isWhite(nodeInfo.getStringValueCS())) {
                        this.compileError("No character data is allowed within xsl:evaluate", "XTSE0010");
                        return;
                    }
                } else {
                    this.compileError("Child element " + Err.wrap(nodeInfo.getDisplayName(), 1) + " is not allowed as a child of xsl:evaluate", "XTSE0010");
                }
            }
        });
        try {
            object = this.makeExpressionVisitor();
            TypeChecker typeChecker = ((NodeImpl)this).getConfiguration().getTypeChecker(false);
            RoleDiagnostic roleDiagnostic = new RoleDiagnostic(4, "xsl:evaluate/xpath", 0);
            this.a = typeChecker.staticTypeCheck(this.a, SequenceType.SINGLE_STRING, roleDiagnostic, (ExpressionVisitor)object);
            roleDiagnostic = new RoleDiagnostic(4, "xsl:evaluate/context-item", 0);
            roleDiagnostic.setErrorCode("XTTE3210");
            this.d = typeChecker.staticTypeCheck(this.d, SequenceType.OPTIONAL_ITEM, roleDiagnostic, (ExpressionVisitor)object);
            roleDiagnostic = new RoleDiagnostic(4, "xsl:evaluate/namespace-context", 0);
            roleDiagnostic.setErrorCode("XTTE3170");
            if (this.c != null) {
                this.c = typeChecker.staticTypeCheck(this.c, SequenceType.SINGLE_NODE, roleDiagnostic, (ExpressionVisitor)object);
            }
            roleDiagnostic = new RoleDiagnostic(4, "xsl:evaluate/with-params", 0);
            roleDiagnostic.setErrorCode("XTTE3170");
            this.g = typeChecker.staticTypeCheck(this.g, SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384), roleDiagnostic, (ExpressionVisitor)object);
            roleDiagnostic = new RoleDiagnostic(4, "xsl:evaluate/saxon:options", 0);
            this.h = typeChecker.staticTypeCheck(this.h, SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384), roleDiagnostic, (ExpressionVisitor)object);
            return;
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return;
        }
    }

    public Expression getTargetExpression() {
        return this.a;
    }

    public Expression getContextItemExpression() {
        return this.d;
    }

    public Expression getBaseUriExpression() {
        return this.e;
    }

    public Expression getNamespaceContextExpression() {
        return this.c;
    }

    public Expression getSchemaAwareExpression() {
        return this.f;
    }

    public Expression getWithParamsExpression() {
        return this.g;
    }

    public Expression getOptionsExpression() {
        return this.h;
    }

    public SequenceType getRequiredType() {
        return this.b;
    }

    @Override
    public Expression compile(Compilation compilation, ComponentDeclaration componentDeclaration) {
        if (((NodeImpl)this).getConfiguration().getBooleanProperty(Feature.DISABLE_XSL_EVALUATE)) {
            this.validationError = new XPathException("xsl:evaluate is not available in this configuration", "XTDE3175");
            return this.fallbackProcessing(compilation, componentDeclaration, this);
        }
        Expression expression = ((NodeImpl)this).getConfiguration().makeEvaluateInstruction(this, componentDeclaration);
        if (expression instanceof ErrorExpression) {
            return expression;
        }
        if (this.i) {
            NodeInfo nodeInfo;
            Expression[] expressionArray = new Expression[2];
            Expression[] expressionArray2 = SystemFunction.makeCall("system-property", this.makeRetainedStaticContext(), new StringLiteral("Q{http://www.w3.org/1999/XSL/Transform}supports-dynamic-evaluation"));
            expressionArray[0] = new ValueComparison((Expression)expressionArray2, 50, new StringLiteral("no"));
            expressionArray[1] = Literal.makeLiteral(BooleanValue.TRUE);
            expressionArray2 = new Expression[2];
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            AxisIterator axisIterator = this.iterateChildren(AnyNodeTest.getInstance());
            while ((nodeInfo = axisIterator.next()) != null) {
                if (!(nodeInfo instanceof XSLFallback)) continue;
                arrayList.add(((XSLFallback)nodeInfo).compileSequenceConstructor(compilation, componentDeclaration, false));
            }
            expressionArray2[0] = new Block(arrayList.toArray(new Expression[0]));
            expressionArray2[1] = expression;
            return new Choose(expressionArray, expressionArray2);
        }
        return expression;
    }
}

