/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.List;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLAcceptExpose;
import net.sf.saxon.style.XSLGlobalParam;
import net.sf.saxon.style.XSLGlobalVariable;
import net.sf.saxon.trans.ComponentTest;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;

public class XSLExpose
extends XSLAcceptExpose {
    protected void checkCompatibility(SymbolicName symbolicName, Visibility visibility, Visibility visibility2) {
        if (!XSLExpose.isCompatible(visibility, visibility2)) {
            String string = "XTSE3010";
            this.compileError("The " + symbolicName + " is declared as " + visibility.show() + " and cannot be exposed as " + visibility2.show(), string);
        }
    }

    public static boolean isCompatible(Visibility visibility, Visibility visibility2) {
        if (visibility == null || visibility == visibility2) {
            return true;
        }
        switch (visibility) {
            case PUBLIC: {
                return visibility2 == Visibility.PUBLIC || visibility2 == Visibility.PRIVATE || visibility2 == Visibility.FINAL || visibility2 == Visibility.HIDDEN;
            }
            case ABSTRACT: {
                return visibility2 == Visibility.ABSTRACT || visibility2 == Visibility.HIDDEN;
            }
            case FINAL: {
                return visibility2 == Visibility.PRIVATE || visibility2 == Visibility.FINAL || visibility2 == Visibility.HIDDEN;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate(ComponentDeclaration object) {
        object = this.getPrincipalStylesheetModule();
        Visibility visibility = ((StyleElement)this).getVisibility();
        for (ComponentTest object2 : this.getExplicitComponentTests()) {
            QNameTest qNameTest = object2.getQNameTest();
            if (!(qNameTest instanceof NameTest)) continue;
            Object object3 = ((NodeTest)((NameTest)qNameTest)).getMatchingNodeName();
            int n2 = object2.getComponentKind();
            SymbolicName symbolicName = n2 == 158 ? new SymbolicName.F(((NodeTest)((NameTest)qNameTest)).getMatchingNodeName(), object2.getArity()) : new SymbolicName(n2, ((NodeTest)((NameTest)qNameTest)).getMatchingNodeName());
            boolean bl2 = false;
            switch (n2) {
                case 200: {
                    NamedTemplate i2 = ((PrincipalStylesheetModule)object).getNamedTemplate((StructuredQName)object3);
                    bl2 = i2 != null;
                    if (!bl2) break;
                    object3 = i2.getDeclaredVisibility();
                    this.checkCompatibility(((Actor)i2).getSymbolicName(), (Visibility)((Object)object3), visibility);
                    break;
                }
                case 206: {
                    SourceBinding sourceBinding = ((PrincipalStylesheetModule)object).getGlobalVariableBinding((StructuredQName)object3);
                    if (sourceBinding != null && !(sourceBinding.getSourceElement() instanceof XSLGlobalParam)) {
                        bl2 = true;
                    }
                    if (!bl2) break;
                    object3 = ((XSLGlobalVariable)sourceBinding.getSourceElement()).getCompiledVariable();
                    Visibility visibility2 = ((Actor)object3).getDeclaredVisibility();
                    this.checkCompatibility(((Actor)object3).getSymbolicName(), visibility2, ((StyleElement)this).getVisibility());
                    break;
                }
                case 136: {
                    List<ComponentDeclaration> list = ((PrincipalStylesheetModule)object).getAttributeSetDeclarations((StructuredQName)object3);
                    bl2 = list != null && !list.isEmpty();
                    if (!bl2) break;
                    object3 = list.get(0).getSourceElement().getDeclaredVisibility();
                    this.checkCompatibility(symbolicName, (Visibility)((Object)object3), ((StyleElement)this).getVisibility());
                    break;
                }
                case 174: {
                    Mode mode = ((PrincipalStylesheetModule)object).getRuleManager().obtainMode((StructuredQName)object3, false);
                    bl2 = mode != null;
                    if (bl2) {
                        this.checkCompatibility(symbolicName, mode.getDeclaredVisibility(), ((StyleElement)this).getVisibility());
                    }
                    if (((StyleElement)this).getVisibility() != Visibility.ABSTRACT) break;
                    this.compileError("The visibility of a mode cannot be abstract");
                    break;
                }
                case 158: {
                    object3 = ((PrincipalStylesheetModule)object).getStylesheetPackage();
                    if (object2.getArity() == -1) {
                        void var4_11;
                        boolean bl3 = false;
                        while (var4_11 <= ((StylesheetPackage)object3).getMaxFunctionArity()) {
                            symbolicName = new SymbolicName.F(((NodeTest)((NameTest)qNameTest)).getMatchingNodeName(), (int)var4_11);
                            Object object4 = ((StylesheetPackage)object3).getComponent(symbolicName);
                            if (object4 != null) {
                                bl2 = true;
                                object4 = (UserFunction)((Component)object4).getActor();
                                this.checkCompatibility(symbolicName, ((Actor)object4).getDeclaredVisibility(), ((StyleElement)this).getVisibility());
                            }
                            ++var4_11;
                        }
                        break;
                    }
                    Component component = ((StylesheetPackage)object3).getComponent(symbolicName);
                    bl2 = component != null;
                    if (!bl2) break;
                    UserFunction userFunction = (UserFunction)component.getActor();
                    this.checkCompatibility(symbolicName, userFunction.getDeclaredVisibility(), ((StyleElement)this).getVisibility());
                }
            }
            if (bl2) continue;
            this.compileError("No " + symbolicName.toString() + " exists in the containing package", "XTSE3020");
        }
    }
}

