/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.sort.SortExpression;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Whitespace;

public class XSLForEach
extends StyleElement {
    private Expression a = null;
    private boolean b = false;
    private Expression c = null;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected boolean isPermittedChild(StyleElement styleElement) {
        return styleElement instanceof XSLSort;
    }

    @Override
    protected boolean markTailCalls() {
        assert (this.a != null);
        if (Cardinality.allowsMany(this.a.getCardinality())) {
            return false;
        }
        StyleElement styleElement = this.getLastChildInstruction();
        this.b = styleElement != null && styleElement.markTailCalls();
        return this.b;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string2 = attributeCollection.getQName(i2);
            if (string2.equals("select")) {
                string = attributeCollection.getValue(i2);
                this.a = this.makeExpression(string, i2);
                continue;
            }
            if (attributeCollection.getLocalName(i2).equals("threads") && attributeCollection.getURI(i2).equals("http://saxon.sf.net/")) {
                string2 = Whitespace.trim(attributeCollection.getValue(i2));
                this.c = this.makeAttributeValueTemplate(string2, i2);
                if (this.getCompilation().getCompilerInfo().isCompileWithTracing()) {
                    this.compileWarning("saxon:threads - no multithreading takes place when compiling with trace enabled", "SXWN9012");
                    this.c = new StringLiteral("0");
                    continue;
                }
                if ("EE".equals(((NodeImpl)this).getConfiguration().getEditionCode())) continue;
                this.compileWarning("saxon:threads - ignored when not running Saxon-EE", "SXWN9013");
                this.c = new StringLiteral("0");
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (string == null) {
            this.reportAbsence("select");
            this.a = Literal.makeEmptySequence();
        }
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        this.checkSortComesFirst(false);
        this.a = this.typeCheck("select", this.a);
        if (!((NodeImpl)this).hasChildNodes()) {
            this.compileWarning("An empty xsl:for-each instruction has no effect", "SXWN9009");
        }
    }

    @Override
    public Expression compile(Compilation object, ComponentDeclaration componentDeclaration) {
        SortKeyDefinitionList sortKeyDefinitionList = this.makeSortKeys((Compilation)object, componentDeclaration);
        Expression expression = this.a;
        if (sortKeyDefinitionList != null) {
            expression = new SortExpression(this.a, sortKeyDefinitionList);
        }
        if ((object = this.compileSequenceConstructor((Compilation)object, componentDeclaration, true)) == null) {
            return Literal.makeEmptySequence();
        }
        try {
            object = new ForEach(expression, ((Expression)object).simplify(), this.b, this.c);
            ((ForEach)object).setInstruction(true);
            ((Expression)object).setLocation(this.allocateLocation());
            return object;
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return null;
        }
    }
}

