/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public final class XSLForEachGroup
extends StyleElement {
    private Expression a = null;
    private Expression b = null;
    private Expression c = null;
    private Pattern d = null;
    private Pattern e = null;
    private Expression f;
    private boolean g = false;

    @Override
    public final boolean isInstruction() {
        return true;
    }

    @Override
    protected final boolean isPermittedChild(StyleElement styleElement) {
        return styleElement instanceof XSLSort;
    }

    @Override
    public final boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public final void prepareAttributes() {
        String string;
        int n2;
        Object object = this.getAttributeList();
        Object object2 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        for (n2 = 0; n2 < object.getLength(); ++n2) {
            string = object.getQName(n2);
            if (string.equals("select")) {
                object2 = object.getValue(n2);
                this.a = this.makeExpression((String)object2, n2);
                continue;
            }
            if (string.equals("group-by")) {
                string2 = object.getValue(n2);
                this.b = this.makeExpression(string2, n2);
                continue;
            }
            if (string.equals("group-adjacent")) {
                string3 = object.getValue(n2);
                this.c = this.makeExpression(string3, n2);
                continue;
            }
            if (string.equals("group-starting-with")) {
                string4 = object.getValue(n2);
                continue;
            }
            if (string.equals("group-ending-with")) {
                string5 = object.getValue(n2);
                continue;
            }
            if (string.equals("collation")) {
                string6 = Whitespace.trim(object.getValue(n2));
                this.f = this.makeAttributeValueTemplate(string6, n2);
                continue;
            }
            if (string.equals("bind-group")) {
                this.compileError("The bind-group attribute has been dropped from the XSLT 3.0 specification", "XTSE0090");
                continue;
            }
            if (string.equals("bind-grouping-key")) {
                this.compileError("The bind-grouping-key attribute has been dropped from the XSLT 3.0 specification", "XTSE0090");
                continue;
            }
            if (string.equals("composite")) {
                this.g = this.processBooleanAttribute("composite", object.getValue(n2));
                continue;
            }
            this.checkUnknownAttribute(object.getNodeName(n2));
        }
        if (object2 == null) {
            this.reportAbsence("select");
            this.a = Literal.makeEmptySequence();
        }
        if ((n2 = (string2 == null ? 0 : 1) + (string3 == null ? 0 : 1) + (string4 == null ? 0 : 1) + (string5 == null ? 0 : 1)) != 1) {
            this.compileError("Exactly one of the attributes group-by, group-adjacent, group-starting-with, and group-ending-with must be specified", "XTSE1080");
        }
        if (string4 != null) {
            this.d = this.makePattern(string4, "group-starting-with");
        }
        if (string5 != null) {
            this.e = this.makePattern(string5, "group-ending-with");
        }
        if (string6 != null) {
            if (this.b == null && this.c == null) {
                this.compileError("A collation may be specified only if group-by or group-adjacent is specified", "XTSE1090");
            } else if (this.f instanceof StringLiteral) {
                string = ((StringLiteral)this.f).getStringValue();
                try {
                    object = new URI(string);
                    if (!((URI)object).isAbsolute()) {
                        object2 = new URI(((NodeImpl)this).getBaseURI());
                        object = ((URI)object2).resolve((URI)object);
                        this.f = new StringLiteral(((URI)object).toString());
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.compileError("Collation name '" + this.f + "' is not a valid URI", "XTDE1110");
                    this.f = new StringLiteral("http://www.w3.org/2005/xpath-functions/collation/codepoint");
                }
            }
        } else {
            string = this.getDefaultCollationName();
            if (string != null) {
                this.f = new StringLiteral(string);
            }
        }
        if (this.g && (this.d != null || this.e != null)) {
            this.compileError("The composite attribute cannot be used with " + (this.d == null ? "grouping-ending-with" : "group-starting-with"), "XTSE1090");
        }
    }

    @Override
    public final void validate(ComponentDeclaration object) {
        RoleDiagnostic roleDiagnostic;
        this.checkSortComesFirst(false);
        object = ((NodeImpl)this).getConfiguration().getTypeChecker(false);
        this.a = this.typeCheck("select", this.a);
        ExpressionVisitor expressionVisitor = this.makeExpressionVisitor();
        if (this.b != null) {
            this.b = this.typeCheck("group-by", this.b);
            try {
                roleDiagnostic = new RoleDiagnostic(4, "xsl:for-each-group/group-by", 0);
                this.b = ((TypeChecker)object).staticTypeCheck(this.b, SequenceType.ATOMIC_SEQUENCE, roleDiagnostic, expressionVisitor);
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        } else if (this.c != null) {
            this.c = this.typeCheck("group-adjacent", this.c);
            try {
                roleDiagnostic = new RoleDiagnostic(4, "xsl:for-each-group/group-adjacent", 0);
                roleDiagnostic.setErrorCode("XTTE1100");
                this.c = ((TypeChecker)object).staticTypeCheck(this.c, this.g ? SequenceType.ATOMIC_SEQUENCE : SequenceType.SINGLE_ATOMIC, roleDiagnostic, expressionVisitor);
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        this.d = this.typeCheck("starting", this.d);
        this.e = this.typeCheck("ending", this.e);
        if ((this.d != null || this.e != null) && expressionVisitor.getStaticContext().getXPathVersion() < 30) {
            try {
                roleDiagnostic = new RoleDiagnostic(4, "xsl:for-each-group/select", 0);
                roleDiagnostic.setErrorCode("XTTE1120");
                this.a = ((TypeChecker)object).staticTypeCheck(this.a, SequenceType.NODE_SEQUENCE, roleDiagnostic, expressionVisitor);
            }
            catch (XPathException xPathException) {
                object = this.d != null ? "With group-starting-with attribute: " : "With group-ending-with attribute: ";
                this.compileError((String)object + xPathException.getMessage(), xPathException.getErrorCodeQName());
            }
        }
        if (!((NodeImpl)this).hasChildNodes()) {
            this.compileWarning("An empty xsl:for-each-group instruction has no effect", "SXWN9009");
        }
    }

    @Override
    public final Expression compile(Compilation object, ComponentDeclaration componentDeclaration) {
        String string;
        StringCollator stringCollator = null;
        if (this.f instanceof StringLiteral && (stringCollator = this.findCollation(string = ((StringLiteral)this.f).getStringValue(), ((NodeImpl)this).getBaseURI())) == null) {
            this.compileError("The collation name '" + this.f + "' has not been defined", "XTDE1110");
        }
        byte by = 0;
        Expression expression = null;
        if (this.b != null) {
            by = 0;
            expression = this.b;
        } else if (this.c != null) {
            by = 1;
            expression = this.c;
        } else if (this.d != null) {
            by = 2;
            expression = this.d;
        } else if (this.e != null) {
            by = 3;
            expression = this.e;
        }
        Expression expression2 = this.compileSequenceConstructor((Compilation)object, componentDeclaration, true);
        if (expression2 == null) {
            return Literal.makeEmptySequence();
        }
        try {
            object = new ForEachGroup(this.a, expression2.simplify(), by, expression, stringCollator, this.f, this.makeSortKeys((Compilation)object, componentDeclaration));
            ((ForEachGroup)object).setIsInFork(this.getParent().getFingerprint() == 156);
            ((ForEachGroup)object).setComposite(this.g);
            return object;
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return null;
        }
    }
}

