/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Fork;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLForEachGroup;
import net.sf.saxon.style.XSLSequence;

public class XSLFork
extends StyleElement {
    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
    }

    @Override
    public void validate(ComponentDeclaration object) {
        NodeInfo nodeInfo;
        object = this.iterateAxis((byte)3);
        int n2 = 0;
        int n3 = 0;
        while ((nodeInfo = object.next()) != null) {
            if (nodeInfo instanceof XSLSequence) {
                ++n3;
                continue;
            }
            if (nodeInfo instanceof XSLForEachGroup) {
                ++n2;
                continue;
            }
            if (nodeInfo instanceof XSLFallback) continue;
            this.compileError(nodeInfo.getDisplayName() + " cannot appear as a child of xsl:fork");
        }
        if (n2 > 1) {
            this.compileError("xsl:fork contains more than one xsl:for-each-group instruction");
        }
        if (n2 > 0 && n3 > 0) {
            this.compileError("Cannot mix xsl:sequence and xsl:for-each-group within xsl:fork");
        }
    }

    @Override
    public Expression compile(Compilation object, ComponentDeclaration componentDeclaration) {
        if ((object = this.compileSequenceConstructor((Compilation)object, componentDeclaration, true)) instanceof Block) {
            return new Fork(((Block)object).getOperanda());
        }
        return object;
    }
}

