/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.ICompilerService;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.OptimizerOptions;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.Annotation;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.trans.FunctionStreamability;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLFunction
extends StyleElement
implements StylesheetComponent {
    private boolean a = false;
    private String b = null;
    private String c = null;
    private String d = null;
    private SequenceType e = SequenceType.ANY_SEQUENCE;
    private SlotManager f;
    private boolean g = false;
    private String h = null;
    private boolean i = true;
    private int j = -1;
    private UserFunction k;
    private Visibility l;
    private FunctionStreamability m;
    private UserFunction.Determinism n = UserFunction.Determinism.PROACTIVE;
    private boolean o;

    @Override
    public UserFunction getActor() {
        return this.k;
    }

    @Override
    public boolean isDeclaration() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        int n2;
        if (this.a) {
            return;
        }
        this.a = true;
        Object object = this.getAttributeList();
        this.h = null;
        FunctionStreamability[] functionStreamabilityArray = null;
        String string = null;
        String string2 = null;
        FunctionStreamability[] functionStreamabilityArray2 = null;
        block26: for (n2 = 0; n2 < object.getLength(); ++n2) {
            Object object2 = object.getURI(n2);
            String object3 = object.getLocalName(n2);
            if ("".equals(object2)) {
                switch (object3) {
                    case "name": {
                        this.b = Whitespace.trim(object.getValue(n2));
                        assert (this.b != null);
                        try {
                            XSLFunction xSLFunction = this;
                            object2 = xSLFunction.makeQName(xSLFunction.b);
                            if (((StructuredQName)object2).hasURI("")) {
                                object2 = new StructuredQName("saxon", "http://saxon.sf.net/", ((StructuredQName)object2).getLocalPart());
                                this.compileError("Function name must be in a namespace", "XTSE0740");
                            }
                            this.setObjectName((StructuredQName)object2);
                        }
                        catch (XPathException xPathException) {
                            this.compileError(xPathException);
                        }
                        break;
                    }
                    case "as": {
                        this.c = object.getValue(n2);
                        break;
                    }
                    case "visibility": {
                        functionStreamabilityArray = Whitespace.trim(object.getValue(n2));
                        break;
                    }
                    case "streamability": {
                        functionStreamabilityArray2 = Whitespace.trim(object.getValue(n2));
                        break;
                    }
                    case "override": {
                        object2 = Whitespace.trim(object.getValue(n2));
                        boolean bl2 = this.processBooleanAttribute("override", (String)object2);
                        if (this.h != null) {
                            if (bl2 != this.i) {
                                this.compileError("Attributes override-extension-function and override are both used, but do not match", "XTSE0020");
                            }
                        } else {
                            this.h = object2;
                            this.i = bl2;
                        }
                        this.compileWarning("The xsl:function/@override attribute is deprecated; use override-extension-function", "SXWN9014");
                        break;
                    }
                    case "override-extension-function": {
                        object2 = Whitespace.trim(object.getValue(n2));
                        int n3 = this.processBooleanAttribute("override-extension-function", (String)object2) ? 1 : 0;
                        if (this.h != null) {
                            if (n3 != this.i) {
                                this.compileError("Attributes override-extension-function and override are both used, but do not match", "XTSE0020");
                            }
                        } else {
                            this.h = object2;
                            this.i = n3;
                        }
                        if (!object3.equals("override")) continue block26;
                        this.compileWarning("The xsl:function/@override attribute is deprecated; use override-extension-function", "SXWN9014");
                        break;
                    }
                    case "cache": {
                        string = Whitespace.trim(object.getValue(n2));
                        break;
                    }
                    case "new-each-time": {
                        string2 = Whitespace.trim(object.getValue(n2));
                        break;
                    }
                    default: {
                        this.checkUnknownAttribute(object.getNodeName(n2));
                        break;
                    }
                }
                continue;
            }
            if (((String)object2).equals("http://saxon.sf.net/")) {
                if (object3.equals("memo-function")) {
                    this.g = this.processBooleanAttribute("saxon:memo-function", object.getValue(n2));
                    continue;
                }
                if (object3.equals("as")) {
                    this.d = object.getValue(n2);
                    continue;
                }
                if (!object3.equals("explain")) continue;
                this.o = XSLFunction.a(Whitespace.trim(object.getValue(n2)));
                continue;
            }
            this.checkUnknownAttribute(object.getNodeName(n2));
        }
        if (this.b == null) {
            this.reportAbsence("name");
            this.b = "xsl:unnamed-function-" + this.generateId();
        }
        if (this.c != null) {
            try {
                this.e = this.makeSequenceType(this.c);
            }
            catch (XPathException xPathException) {
                this.compileErrorInAttribute(xPathException.getMessage(), xPathException.getErrorCodeLocalPart(), "as");
            }
        }
        if (this.d != null) {
            SequenceType sequenceType;
            try {
                XSLFunction xSLFunction = this;
                sequenceType = xSLFunction.makeExtendedSequenceType(xSLFunction.d);
            }
            catch (XPathException xPathException) {
                this.compileErrorInAttribute(xPathException.getMessage(), xPathException.getErrorCodeLocalPart(), "saxon:as");
                sequenceType = this.e;
            }
            if (this.c != null) {
                int n4 = ((NodeImpl)this).getConfiguration().getTypeHierarchy().sequenceTypeRelationship(sequenceType, this.e);
                if (n4 == 0 || n4 == 2) {
                    this.e = sequenceType;
                } else {
                    this.compileErrorInAttribute("When both are present, @saxon:as must be a subtype of @as", "SXER7TBA", "saxon:as");
                }
            } else {
                this.e = sequenceType;
            }
        }
        this.l = functionStreamabilityArray == null ? Visibility.PRIVATE : this.interpretVisibilityValue((String)functionStreamabilityArray, "");
        if (functionStreamabilityArray2 == null) {
            this.m = FunctionStreamability.UNCLASSIFIED;
        } else {
            block59: {
                FunctionStreamability functionStreamability;
                functionStreamabilityArray = functionStreamabilityArray2;
                object = this;
                if (functionStreamabilityArray.contains(":")) {
                    ((StyleElement)object).makeQName((String)functionStreamabilityArray);
                    functionStreamability = FunctionStreamability.UNCLASSIFIED;
                } else {
                    for (FunctionStreamability functionStreamability2 : FunctionStreamability.values()) {
                        if (!functionStreamability2.streamabilityStr.equals(functionStreamabilityArray)) continue;
                        functionStreamability = functionStreamability2;
                        break block59;
                    }
                    ((StyleElement)object).invalidAttribute("visibility", "unclassified|absorbing|inspection|filter|shallow-descent|deep-descent|ascent");
                    functionStreamability = this.m = null;
                }
            }
            if (this.m.isStreaming()) {
                boolean bl2 = this.b("yes");
                n2 = bl2 ? 1 : 0;
                if (!bl2) {
                    this.m = FunctionStreamability.UNCLASSIFIED;
                }
            }
        }
        if (string2 != null) {
            UserFunction.Determinism determinism;
            XSLFunction xSLFunction;
            if ("maybe".equals(string2)) {
                xSLFunction = this;
                determinism = UserFunction.Determinism.ELIDABLE;
            } else {
                n2 = this.processBooleanAttribute("new-each-time", string2) ? 1 : 0;
                xSLFunction = this;
                determinism = n2 != 0 ? UserFunction.Determinism.PROACTIVE : UserFunction.Determinism.DETERMINISTIC;
            }
            xSLFunction.n = determinism;
        }
        n2 = 0;
        if (string != null) {
            n2 = this.processBooleanAttribute("cache", string) ? 1 : 0;
        }
        if (this.n == UserFunction.Determinism.DETERMINISTIC || n2 != 0) {
            this.g = true;
        }
    }

    @Override
    public StructuredQName getObjectName() {
        StructuredQName structuredQName = super.getObjectName();
        if (structuredQName == null) {
            this.b = Whitespace.trim(((NodeImpl)this).getAttributeValue("", "name"));
            if (this.b == null) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-function" + this.generateId());
            }
            try {
                XSLFunction xSLFunction = this;
                structuredQName = xSLFunction.makeQName(xSLFunction.b);
                this.setObjectName(structuredQName);
            }
            catch (XPathException xPathException) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-function" + this.generateId());
            }
        }
        return structuredQName;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    protected boolean mayContainParam() {
        return true;
    }

    @Override
    protected boolean isPermittedChild(StyleElement styleElement) {
        return styleElement instanceof XSLLocalParam;
    }

    @Override
    public Visibility getVisibility() {
        if (this.l == null) {
            String string = ((NodeImpl)this).getAttributeValue("", "visibility");
            if (string == null) {
                return Visibility.PRIVATE;
            }
            return this.interpretVisibilityValue(Whitespace.trim(string), "");
        }
        return this.l;
    }

    @Override
    public SymbolicName.F getSymbolicName() {
        return new SymbolicName.F(((StyleElement)this).getObjectName(), this.getNumberOfArguments());
    }

    @Override
    public void checkCompatibility(Component object) {
        if (this.k == null) {
            this.getCompiledFunction();
        }
        TypeHierarchy typeHierarchy = ((NodeImpl)this).getConfiguration().getTypeHierarchy();
        object = (UserFunction)((Component)object).getActor();
        if (!((SymbolicName)this.k.getSymbolicName()).equals(((UserFunction)object).getSymbolicName())) {
            this.compileError("The overriding xsl:function " + this.b + " does not match the overridden function: the function name/arity does not match", "XTSE3070");
        }
        if (!this.k.getDeclaredResultType().isSameType(((UserFunction)object).getDeclaredResultType(), typeHierarchy)) {
            this.compileError("The overriding xsl:function " + this.b + " does not match the overridden function: the return type does not match", "XTSE3070");
        }
        if (!this.k.getDeclaredStreamability().equals((Object)((UserFunction)object).getDeclaredStreamability())) {
            this.compileError("The overriding xsl:function " + this.b + " does not match the overridden function: the streamability category does not match", "XTSE3070");
        }
        if (!this.k.getDeterminism().equals((Object)((UserFunction)object).getDeterminism())) {
            this.compileError("The overriding xsl:function " + this.b + " does not match the overridden function: the new-each-time attribute does not match", "XTSE3070");
        }
        for (int i2 = 0; i2 < this.getNumberOfArguments(); ++i2) {
            if (this.k.getArgumentType(i2).isSameType(((UserFunction)object).getArgumentType(i2), typeHierarchy)) continue;
            this.compileError("The overriding xsl:function " + this.b + " does not match the overridden function: the type of the " + RoleDiagnostic.ordinal(i2 + 1) + " argument does not match", "XTSE3070");
        }
    }

    public boolean isOverrideExtensionFunction() {
        if (this.h == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException xPathException) {}
        }
        return this.i;
    }

    @Override
    public void index(ComponentDeclaration componentDeclaration, PrincipalStylesheetModule principalStylesheetModule) {
        this.getCompiledFunction();
        principalStylesheetModule.indexFunction(componentDeclaration);
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        this.f = ((NodeImpl)this).getConfiguration().makeSlotManager();
        this.checkTopLevel("XTSE0010", true);
        int n2 = this.getNumberOfArguments();
        if (n2 == 0 && this.m != FunctionStreamability.UNCLASSIFIED) {
            this.compileError("A function with no arguments must have streamability=unclassified", "XTSE3155");
        }
    }

    @Override
    public void compileDeclaration(Compilation object, ComponentDeclaration userFunctionParameterArray) {
        NodeInfo nodeInfo;
        if ((object = this.compileSequenceConstructor((Compilation)object, (ComponentDeclaration)userFunctionParameterArray, false)) == null) {
            object = Literal.makeEmptySequence();
        } else if (!Literal.isEmptySequence((Expression)object)) {
            if (this.l == Visibility.ABSTRACT) {
                this.compileError("A function defined with visibility='abstract' must have no body");
            }
            object = ((Expression)object).simplify();
        }
        userFunctionParameterArray = this.getCompiledFunction();
        userFunctionParameterArray.setBody((Expression)object);
        userFunctionParameterArray.setStackFrameMap(this.f);
        UserFunctionParameter[] userFunctionParameterArray2 = userFunctionParameterArray;
        object = this;
        userFunctionParameterArray2 = userFunctionParameterArray2.getParameterDefinitions();
        int n2 = 0;
        object = ((NodeImpl)object).iterateAxis((byte)3);
        while ((nodeInfo = object.next()) != null) {
            if (!(nodeInfo instanceof XSLLocalParam)) continue;
            UserFunctionParameter userFunctionParameter = userFunctionParameterArray2[n2++];
            userFunctionParameter.setRequiredType(((XSLLocalParam)nodeInfo).getRequiredType());
            userFunctionParameter.setVariableQName(((XSLLocalParam)nodeInfo).getVariableQName());
            userFunctionParameter.setSlotNumber(((XSLLocalParam)nodeInfo).getSlotNumber());
            ((XSLLocalParam)nodeInfo).getSourceBinding().fixupBinding(userFunctionParameter);
        }
        userFunctionParameterArray.setRetainedStaticContext(this.makeRetainedStaticContext());
        userFunctionParameterArray.setOverrideExtensionFunction(this.i);
        if (this.n == UserFunction.Determinism.DETERMINISTIC && !userFunctionParameterArray.isMemoFunction()) {
            this.compileWarning("Deterministic user functions are not available in Saxon-HE: new-each-time attribute ignored", "SXWN9011");
        } else if (this.g && !userFunctionParameterArray.isMemoFunction()) {
            this.compileWarning("Memo functions are not available in Saxon-HE: @cache (or @saxon:memo-function) attribute ignored", "SXWN9011");
        }
        object = this.getOverriddenComponent();
        if (object != null) {
            this.checkCompatibility((Component)object);
        }
    }

    @Override
    public void optimize(ComponentDeclaration object) {
        int n2;
        object = this.k.getBody();
        ExpressionTool.resetPropertiesWithinSubtree((Expression)object);
        ExpressionVisitor expressionVisitor = this.makeExpressionVisitor();
        Expression expression = ((Expression)object).typeCheck(expressionVisitor, ContextItemStaticInfo.ABSENT);
        if (this.m.isStreaming()) {
            expressionVisitor.setOptimizeForStreaming(true);
        }
        expression = ExpressionTool.optimizeComponentBody(expression, this.getCompilation(), expressionVisitor, ContextItemStaticInfo.ABSENT, true);
        expression = XSLFunction.makeTraceInstruction(this, expression);
        this.k.setBody(expression);
        Optimizer optimizer = expressionVisitor.getConfiguration().obtainOptimizer();
        if (this.m.isStreaming()) {
            XSLFunction xSLFunction = this;
            optimizer.assessFunctionStreamability(xSLFunction, xSLFunction.k);
        }
        this.allocateLocalSlots(expression);
        if (expression != object) {
            this.k.setBody(expression);
        }
        if (((OptimizerOptions)(object = this.getCompilation().getCompilerInfo().getOptimizerOptions())).isSet(16384) && !this.m.isStreaming() && (n2 = ExpressionTool.markTailFunctionCalls(expression, ((StyleElement)this).getObjectName(), this.getNumberOfArguments())) != 0) {
            this.k.setTailRecursive(n2 > 0, n2 > 1);
            expression = this.k.getBody();
            this.k.setBody(new TailCallLoop(this.k, expression));
        }
        this.k.computeEvaluationMode();
        if (this.m.isStreaming()) {
            this.k.prepareForStreaming();
        } else if (expressionVisitor.getConfiguration().isDeferredByteCode(50)) {
            this.k.setBody(((NodeImpl)this).getConfiguration().obtainOptimizer().makeByteCodeCandidate(this.k, this.k.getBody(), this.b, 6));
        }
        if (this.o) {
            expression.explain(((NodeImpl)this).getConfiguration().getLogger());
        }
    }

    @Override
    public void generateByteCode(Optimizer object) {
        if (this.getCompilation().getCompilerInfo().isGenerateByteCode() && this.m == FunctionStreamability.UNCLASSIFIED) {
            try {
                ICompilerService iCompilerService = ((NodeImpl)this).getConfiguration().makeCompilerService(50);
                object = ((Optimizer)object).compileToByteCode(iCompilerService, this.k.getBody(), this.b, 6);
                if (object != null) {
                    this.k.setBody((Expression)object);
                }
                return;
            }
            catch (Exception exception) {
                System.err.println("Failed while compiling function " + this.b);
                exception.printStackTrace();
                throw new XPathException(exception);
            }
        }
    }

    @Override
    public SlotManager getSlotManager() {
        return this.f;
    }

    public SequenceType getResultType() {
        String string;
        if (this.e == null && (string = ((NodeImpl)this).getAttributeValue("", "as")) != null) {
            try {
                this.e = this.makeSequenceType(string);
            }
            catch (XPathException xPathException) {}
        }
        if (this.e == null) {
            return SequenceType.ANY_SEQUENCE;
        }
        return this.e;
    }

    public int getNumberOfArguments() {
        if (this.j == -1) {
            NodeInfo nodeInfo;
            this.j = 0;
            AxisIterator axisIterator = this.iterateAxis((byte)3);
            while ((nodeInfo = axisIterator.next()) instanceof XSLLocalParam) {
                ++this.j;
            }
            return this.j;
        }
        return this.j;
    }

    public void setParameterDefinitions(UserFunction userFunction) {
        NodeInfo nodeInfo;
        UserFunctionParameter[] userFunctionParameterArray = new UserFunctionParameter[this.getNumberOfArguments()];
        userFunction.setParameterDefinitions(userFunctionParameterArray);
        int n2 = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = axisIterator.next()) != null && nodeInfo instanceof XSLLocalParam) {
            UserFunctionParameter userFunctionParameter;
            userFunctionParameterArray[n2] = userFunctionParameter = new UserFunctionParameter();
            userFunctionParameter.setRequiredType(((XSLLocalParam)nodeInfo).getRequiredType());
            userFunctionParameter.setVariableQName(((XSLLocalParam)nodeInfo).getVariableQName());
            userFunctionParameter.setSlotNumber(((XSLLocalParam)nodeInfo).getSlotNumber());
            if (n2 == 0 && this.m != FunctionStreamability.UNCLASSIFIED) {
                userFunctionParameter.setFunctionStreamability(this.m);
            }
            ++n2;
        }
    }

    public SequenceType[] getArgumentTypes() {
        NodeInfo nodeInfo;
        SequenceType[] sequenceTypeArray = new SequenceType[this.getNumberOfArguments()];
        int n2 = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = axisIterator.next()) != null) {
            if (!(nodeInfo instanceof XSLLocalParam)) continue;
            sequenceTypeArray[n2++] = ((XSLLocalParam)nodeInfo).getRequiredType();
        }
        return sequenceTypeArray;
    }

    public UserFunction getCompiledFunction() {
        if (this.k == null) {
            try {
                this.prepareAttributes();
                UserFunction userFunction = ((NodeImpl)this).getConfiguration().newUserFunction(this.g, this.m);
                userFunction.setPackageData(this.getCompilation().getPackageData());
                userFunction.setFunctionName(((StyleElement)this).getObjectName());
                this.setParameterDefinitions(userFunction);
                userFunction.setResultType(this.getResultType());
                userFunction.setLineNumber(((NodeImpl)this).getLineNumber());
                userFunction.setSystemId(((NodeImpl)this).getSystemId());
                userFunction.obtainDeclaringComponent(this);
                userFunction.setDeclaredVisibility(this.getDeclaredVisibility());
                userFunction.setDeclaredStreamability(this.m);
                userFunction.setDeterminism(this.n);
                ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
                if (this.g) {
                    arrayList.add(new Annotation(new StructuredQName("saxon", "http://saxon.sf.net/", "memo-function")));
                }
                userFunction.setAnnotations(new AnnotationList(arrayList));
                userFunction.setOverrideExtensionFunction(this.i);
                this.k = userFunction;
            }
            catch (XPathException xPathException) {
                return null;
            }
        }
        return this.k;
    }

    @Override
    public int getConstructType() {
        return 158;
    }
}

