/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.URIResolver;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.XSLImport;
import net.sf.saxon.style.XSLInclude;
import net.sf.saxon.style.XSLModuleRoot;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.value.Whitespace;

public abstract class XSLGeneralIncorporate
extends StyleElement {
    private String a;
    private DocumentImpl b;

    @Override
    public boolean isDeclaration() {
        return true;
    }

    public abstract boolean isImport();

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string = attributeCollection.getQName(i2);
            if (string.equals("href")) {
                this.a = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (this.a == null) {
            this.reportAbsence("href");
        }
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        this.validateInstruction();
    }

    public void validateInstruction() {
        this.checkEmpty();
        XSLGeneralIncorporate xSLGeneralIncorporate = this;
        xSLGeneralIncorporate.checkTopLevel(xSLGeneralIncorporate.isImport() ? "XTSE0190" : "XTSE0170", false);
    }

    public void setTargetDoc(DocumentImpl documentImpl) {
        this.b = documentImpl;
    }

    public StylesheetModule getIncludedStylesheet(StylesheetModule stylesheetModule, int n2) {
        if (this.a == null) {
            return null;
        }
        try {
            StylesheetModule stylesheetModule2;
            Object object = stylesheetModule.getPrincipalStylesheetModule();
            Object object2 = this.getCompilation().getCompilerInfo().getURIResolver();
            ((NodeImpl)this).getConfiguration();
            Object object3 = DocumentFn.computeDocumentKey(this.a, ((NodeImpl)this).getBaseURI(), this.getCompilation().getPackageData(), (URIResolver)object2, false);
            object2 = (XSLStylesheet)((PrincipalStylesheetModule)object).getStylesheetDocument((DocumentURI)object3);
            if (object2 != null) {
                boolean bl2;
                block16: {
                    stylesheetModule2 = new StylesheetModule((StyleElement)object2, n2);
                    stylesheetModule2.setImporter(stylesheetModule);
                    StyleElement styleElement = stylesheetModule2.getRootElement();
                    object3 = stylesheetModule;
                    object = this;
                    if (styleElement.getSystemId() != null) {
                        while (object3 != null) {
                            if (DocumentURI.normalizeURI(styleElement.getSystemId()).equals(DocumentURI.normalizeURI(((NodeImpl)((StylesheetModule)object3).getRootElement()).getSystemId()))) {
                                ((StyleElement)object).compileError("A stylesheet cannot " + ((NodeImpl)object).getLocalPart() + " itself", object instanceof XSLInclude ? "XTSE0180" : "XTSE0210");
                                bl2 = true;
                                break block16;
                            }
                            object3 = ((StylesheetModule)object3).getImporter();
                        }
                    }
                    bl2 = false;
                }
                if (bl2) {
                    return null;
                }
            } else {
                object2 = this.b;
                assert (object2 != null);
                if ((object2 = ((DocumentImpl)object2).getDocumentElement()) instanceof LiteralResultElement) {
                    object2 = ((LiteralResultElement)object2).makeStylesheet(false);
                    object2 = ((DocumentImpl)object2).getDocumentElement();
                }
                if (!(object2 instanceof XSLStylesheet)) {
                    object = this instanceof XSLImport ? "Imported" : "Included";
                    this.compileError((String)object + " document " + this.a + " is not a stylesheet", "XTSE0165");
                    return null;
                }
                object2 = (XSLStylesheet)object2;
                ((PrincipalStylesheetModule)object).putStylesheetDocument((DocumentURI)object3, (XSLStylesheet)object2);
                stylesheetModule2 = new StylesheetModule((StyleElement)object2, n2);
                stylesheetModule2.setImporter(stylesheetModule);
                object = new ComponentDeclaration(stylesheetModule2, (StyleElement)object2);
                ((StyleElement)object2).validate((ComponentDeclaration)object);
                if (((StyleElement)object2).validationError != null) {
                    if (this.reportingCircumstances == 1) {
                        Object object4 = object2;
                        ((StyleElement)object4).compileError(((StyleElement)object4).validationError);
                    } else if (((StyleElement)object2).reportingCircumstances == 2) {
                        Object object5 = object2;
                        ((StyleElement)object5).compileError(((StyleElement)object5).validationError);
                    }
                }
            }
            stylesheetModule2.spliceIncludes();
            stylesheetModule.setInputTypeAnnotations(((XSLModuleRoot)object2).getInputTypeAnnotationsAttribute() | stylesheetModule2.getInputTypeAnnotations());
            return stylesheetModule2;
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.setErrorCode("XTSE0165");
            xPathException2.setIsStaticError(true);
            this.compileError(xPathException2);
            return null;
        }
    }

    @Override
    public void compileDeclaration(Compilation compilation, ComponentDeclaration componentDeclaration) {
    }
}

