/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.XSLGlobalVariable;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.value.SequenceType;

public class XSLGlobalParam
extends XSLGlobalVariable {
    private Expression a = null;

    @Override
    protected int getPermittedAttributes() {
        return 2448;
    }

    public XSLGlobalParam() {
        this.sourceBinding.setProperty(4, true);
    }

    @Override
    public Visibility getVisibility() {
        return Visibility.PUBLIC;
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        if (this.sourceBinding.hasProperty(16)) {
            if (this.sourceBinding.getSelectExpression() != null) {
                this.compileError("The select attribute must be absent when required='yes'", "XTSE0010");
            }
            if (((NodeImpl)this).hasChildNodes()) {
                this.compileError("A parameter specifying required='yes' must have empty content", "XTSE0010");
            }
        }
        super.validate(componentDeclaration);
    }

    @Override
    public void compileDeclaration(Compilation object, ComponentDeclaration object2) {
        if (this.sourceBinding.isStatic()) {
            super.compileDeclaration((Compilation)object, (ComponentDeclaration)object2);
            return;
        }
        if (!this.redundant) {
            this.sourceBinding.handleSequenceConstructor((Compilation)object, (ComponentDeclaration)object2);
            object = (GlobalParam)this.compiledVariable;
            ((Actor)object).setPackageData(this.getCompilation().getPackageData());
            ((Actor)object).obtainDeclaringComponent(this);
            object2 = this.sourceBinding.getSelectExpression();
            ((GlobalVariable)object).setSelectExpression((Expression)object2);
            ((GlobalVariable)object).setVariableQName(this.sourceBinding.getVariableQName());
            this.initializeBinding((GlobalVariable)object);
            ((GlobalVariable)object).setRequiredType(((XSLGlobalVariable)this).getRequiredType());
            ((GlobalVariable)object).setRequiredParam(this.sourceBinding.hasProperty(16));
            ((GlobalParam)object).setImplicitlyRequiredParam(this.sourceBinding.hasProperty(32));
            this.sourceBinding.fixupBinding((Binding)object);
            object = this.getOverriddenComponent();
            if (object != null) {
                this.checkCompatibility((Component)object);
            }
        }
    }

    @Override
    public SequenceType getRequiredType() {
        SequenceType sequenceType = this.sourceBinding.getDeclaredType();
        if (sequenceType != null) {
            return sequenceType;
        }
        return SequenceType.ANY_SEQUENCE;
    }

    public void insertBytecodeCandidate(Optimizer optimizer) {
    }
}

