/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.XSLGlobalParam;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class XSLGlobalVariable
extends StyleElement
implements StylesheetComponent {
    private SlotManager a;
    protected SourceBinding sourceBinding = new SourceBinding(this);
    protected GlobalVariable compiledVariable = null;
    private int b = 0;
    protected boolean redundant = false;

    public SourceBinding getSourceBinding() {
        return this.sourceBinding;
    }

    public StructuredQName getVariableQName() {
        return this.sourceBinding.getVariableQName();
    }

    @Override
    public StructuredQName getObjectName() {
        return this.sourceBinding.getVariableQName();
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public boolean isGlobal() {
        return this.isTopLevel();
    }

    @Override
    public void postValidate() {
        this.sourceBinding.postValidate();
    }

    @Override
    public int getConstructType() {
        return 206;
    }

    public GlobalVariable getCompiledVariable() {
        return this.compiledVariable;
    }

    public XSLGlobalVariable() {
        this.sourceBinding.setProperty(2, true);
    }

    protected int getPermittedAttributes() {
        return 6592;
    }

    @Override
    public Actor getActor() {
        GlobalVariable globalVariable = this.getCompiledVariable();
        if (globalVariable == null) {
            globalVariable = this instanceof XSLGlobalParam ? new GlobalParam() : new GlobalVariable();
            globalVariable.setPackageData(this.getCompilation().getPackageData());
            globalVariable.obtainDeclaringComponent(this);
            globalVariable.setRequiredType(this.sourceBinding.getDeclaredType());
            globalVariable.setDeclaredVisibility(this.getDeclaredVisibility());
            globalVariable.setVariableQName(this.sourceBinding.getVariableQName());
            globalVariable.setSystemId(((NodeImpl)this).getSystemId());
            globalVariable.setLineNumber(((NodeImpl)this).getLineNumber());
            RetainedStaticContext retainedStaticContext = this.makeRetainedStaticContext();
            globalVariable.setRetainedStaticContext(retainedStaticContext);
            if (globalVariable.getBody() != null) {
                globalVariable.getBody().setRetainedStaticContext(retainedStaticContext);
            }
            this.compiledVariable = globalVariable;
        }
        return globalVariable;
    }

    @Override
    public SymbolicName getSymbolicName() {
        return new SymbolicName(206, ((StyleElement)this).getObjectName());
    }

    @Override
    public void checkCompatibility(Component object) {
        SequenceType sequenceType = this.getSourceBinding().getDeclaredType();
        if (sequenceType == null) {
            sequenceType = SequenceType.ANY_SEQUENCE;
        }
        GlobalVariable globalVariable = (GlobalVariable)((Component)object).getActor();
        int n2 = ((TypeHierarchy)(object = ((Component)object).getDeclaringPackage().getConfiguration().getTypeHierarchy())).sequenceTypeRelationship(sequenceType, globalVariable.getRequiredType());
        if (n2 != 0) {
            this.compileError("The declared type of the overriding variable $" + this.getVariableQName().getDisplayName() + " is different from that of the overridden variable", "XTSE3070");
        }
    }

    @Override
    public SourceBinding getBindingInformation(StructuredQName structuredQName) {
        if (structuredQName.equals(this.sourceBinding.getVariableQName())) {
            return this.sourceBinding;
        }
        return null;
    }

    @Override
    public void prepareAttributes() {
        if (this.b == 2) {
            return;
        }
        if (this.b == 1) {
            this.compileError("Circular reference to variable", "XTDE0640");
        }
        this.b = 1;
        this.sourceBinding.prepareAttributes(this.getPermittedAttributes());
        this.b = 2;
    }

    @Override
    public void index(ComponentDeclaration componentDeclaration, PrincipalStylesheetModule principalStylesheetModule) {
        principalStylesheetModule.indexVariableDeclaration(componentDeclaration);
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        this.a = ((NodeImpl)this).getConfiguration().makeSlotManager();
        this.sourceBinding.validate();
    }

    public boolean isAssignable() {
        return this.sourceBinding.hasProperty(64);
    }

    @Override
    public boolean isDeclaration() {
        return true;
    }

    @Override
    public boolean isInstruction() {
        return false;
    }

    public SequenceType getRequiredType() {
        return this.sourceBinding.getInferredType(true);
    }

    @Override
    public void fixupReferences() {
        this.sourceBinding.fixupReferences(this.compiledVariable);
        super.fixupReferences();
    }

    @Override
    public void compileDeclaration(Compilation object, ComponentDeclaration object2) {
        if (!this.redundant) {
            this.sourceBinding.handleSequenceConstructor((Compilation)object, (ComponentDeclaration)object2);
            object2 = this.getCompiledVariable();
            if (object2 == null) {
                object2 = new GlobalVariable();
                ((Actor)object2).setPackageData(this.getCompilation().getPackageData());
                ((Actor)object2).obtainDeclaringComponent(this);
                ((GlobalVariable)object2).setVariableQName(this.sourceBinding.getVariableQName());
            }
            if (this.sourceBinding.isStatic()) {
                ((GlobalVariable)object2).setStatic(true);
                object = ((Compilation)object).getStaticVariable(this.sourceBinding.getVariableQName());
                if (object == null) {
                    throw new AssertionError();
                }
                object = Literal.makeLiteral(object);
                ((Expression)object).setRetainedStaticContext(this.makeRetainedStaticContext());
                ((GlobalVariable)object2).setSelectExpression((Expression)object);
            } else {
                object = this.sourceBinding.getSelectExpression();
                ((GlobalVariable)object2).setSelectExpression((Expression)object);
            }
            ((Actor)object2).setRetainedStaticContext(this.makeRetainedStaticContext());
            this.initializeBinding((GlobalVariable)object2);
            ((GlobalVariable)object2).setAssignable(this.isAssignable());
            ((GlobalVariable)object2).setRequiredType(this.getRequiredType());
            this.sourceBinding.fixupBinding((Binding)object2);
            this.compiledVariable = object2;
            object = this.getOverriddenComponent();
            if (object != null) {
                this.checkCompatibility((Component)object);
            }
        }
    }

    protected void initializeBinding(GlobalVariable globalVariable) {
        Expression expression;
        Expression expression2 = expression = globalVariable.getSelectExpression();
        if (expression != null) {
            try {
                ExpressionVisitor expressionVisitor = this.makeExpressionVisitor();
                expression2 = expression.simplify().typeCheck(expressionVisitor, ((NodeImpl)this).getConfiguration().makeContextItemStaticInfo(Type.ITEM_TYPE, true));
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
            expression2 = XSLGlobalVariable.makeTraceInstruction(this, expression2);
            this.allocateLocalSlots(expression2);
        }
        if (this.a != null && this.a.getNumberOfVariables() > 0) {
            globalVariable.setContainsLocals(this.a);
        }
        if (expression2 != expression) {
            globalVariable.setSelectExpression(expression2);
        }
    }

    @Override
    public SlotManager getSlotManager() {
        return this.a;
    }

    @Override
    public void optimize(ComponentDeclaration object) {
        if (!this.redundant && this.compiledVariable.getSelectExpression() != null) {
            object = this.compiledVariable.getSelectExpression();
            ExpressionVisitor expressionVisitor = this.makeExpressionVisitor();
            object = ExpressionTool.optimizeComponentBody((Expression)object, this.getCompilation(), expressionVisitor, ((NodeImpl)this).getConfiguration().makeContextItemStaticInfo(AnyItemType.getInstance(), true), false);
            this.allocateLocalSlots((Expression)object);
            if (this.a != null && this.a.getNumberOfVariables() > 0) {
                this.compiledVariable.setContainsLocals(this.a);
            }
            if (object != this.compiledVariable.getSelectExpression()) {
                this.compiledVariable.setSelectExpression((Expression)object);
            }
        }
    }

    public void setRedundant(boolean bl2) {
        this.redundant = bl2;
    }

    @Override
    public void generateByteCode(Optimizer optimizer) {
    }
}

