/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.Whitespace;

public class XSLImportSchema
extends StyleElement {
    @Override
    public boolean isDeclaration() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string2 = attributeCollection.getQName(i2);
            if (string2.equals("schema-location")) continue;
            if (string2.equals("namespace")) {
                string = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if ("".equals(string)) {
            this.compileError("The zero-length string is not a valid namespace URI. For a schema with no namespace, omit the namespace attribute");
        }
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        this.checkTopLevel("XTSE0010", false);
    }

    @Override
    public void index(ComponentDeclaration componentDeclaration, PrincipalStylesheetModule principalStylesheetModule) {
    }

    public void readSchema() {
        try {
            NodeInfo nodeInfo;
            String string = Whitespace.trim(((NodeImpl)this).getAttributeValue("", "schema-location"));
            String string2 = Whitespace.trim(((NodeImpl)this).getAttributeValue("", "namespace"));
            string2 = string2 == null ? "" : string2.trim();
            Configuration configuration = ((NodeImpl)this).getConfiguration();
            try {
                configuration.checkLicensedFeature(2, "xsl:import-schema", this.getPackageData().getLocalLicenseId());
            }
            catch (LicenseException licenseException) {
                XPathException xPathException = new XPathException(licenseException);
                xPathException.setErrorCode("XTSE1650");
                xPathException.setLocator(this);
                throw xPathException;
            }
            AxisIterator axisIterator = this.iterateAxis((byte)3);
            NodeImpl nodeImpl = null;
            while ((nodeInfo = axisIterator.next()) != null) {
                if (nodeImpl != null) {
                    this.compileError(this.getDisplayName() + " must not have more than one child element");
                }
                if ((nodeImpl = (NodeImpl)nodeInfo).getFingerprint() != 617) {
                    this.compileError("The only child element permitted for " + this.getDisplayName() + " is xs:schema");
                }
                if (string != null) {
                    this.compileError("The schema-location attribute must be absent if an inline schema is present", "XTSE0215");
                }
                if (string2.isEmpty() && (string2 = nodeImpl.getAttributeValue("", "targetNamespace")) == null) {
                    string2 = "";
                }
                string2 = configuration.readInlineSchema(nodeImpl, string2, this.getCompilation().getCompilerInfo().getErrorListener());
                this.getPrincipalStylesheetModule().addImportedSchema(string2);
            }
            if (nodeImpl != null) {
                return;
            }
            if (string2.equals("http://www.w3.org/XML/1998/namespace") || string2.equals("http://www.w3.org/2005/xpath-functions") || string2.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                configuration.addSchemaForBuiltInNamespace(string2);
                this.getPrincipalStylesheetModule().addImportedSchema(string2);
                return;
            }
            boolean bl2 = configuration.isSchemaAvailable(string2);
            if (string == null && !bl2) {
                this.compileWarning("No schema for this namespace is known, and no schema-location was supplied, so no schema has been imported", "SXWN9006");
                return;
            }
            if (bl2 && !configuration.getBooleanProperty(Feature.MULTIPLE_SCHEMA_IMPORTS) && string != null) {
                this.compileWarning("The schema document at " + string + " is ignored because a schema for this namespace is already loaded", "SXWN9006");
            }
            if (!bl2) {
                PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
                pipelineConfiguration.setSchemaURIResolver(configuration.makeSchemaURIResolver(this.getCompilation().getCompilerInfo().getURIResolver()));
                pipelineConfiguration.setErrorListener(this.getCompilation().getCompilerInfo().getErrorListener());
                string2 = configuration.readSchema(pipelineConfiguration, ((NodeImpl)this).getBaseURI(), string, string2);
            }
            this.getPrincipalStylesheetModule().addImportedSchema(string2);
            return;
        }
        catch (SchemaException schemaException) {
            SchemaException schemaException2 = schemaException;
            String string = schemaException.getErrorCodeLocalPart() == null ? "XTSE0220" : schemaException2.getErrorCodeLocalPart();
            this.compileError(schemaException2.getMessage(), string);
            return;
        }
    }

    @Override
    public void compileDeclaration(Compilation compilation, ComponentDeclaration componentDeclaration) {
    }
}

