/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.IterateInstr;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.LocalParamBlock;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.style.XSLOnCompletion;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.linked.NodeImpl;

public class XSLIterate
extends StyleElement {
    private Expression a = null;
    private boolean b;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected boolean isPermittedChild(StyleElement styleElement) {
        return styleElement instanceof XSLLocalParam || styleElement instanceof XSLOnCompletion;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    protected boolean mayContainParam() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string2 = attributeCollection.getQName(i2);
            if (string2.equals("select")) {
                string = attributeCollection.getValue(i2);
                this.a = this.makeExpression(string, i2);
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (string == null) {
            this.reportAbsence("select");
        }
    }

    public void setCompilable(boolean bl2) {
        this.b = bl2;
    }

    public boolean isCompilable() {
        return this.b;
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        this.a = this.typeCheck("select", this.a);
        if (!((NodeImpl)this).hasChildNodes()) {
            this.compileWarning("An empty xsl:iterate instruction has no effect", "SXWN9009");
        }
    }

    @Override
    public Expression compile(Compilation object, ComponentDeclaration componentDeclaration) {
        LocalParam[] localParamArray;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        ArrayList<LocalParam[]> arrayList = new ArrayList<LocalParam[]>();
        Expression expression = null;
        ArrayList<XSLLocalParam> arrayList2 = new ArrayList<XSLLocalParam>();
        while ((localParamArray = (LocalParam[])axisIterator.next()) != null) {
            if (localParamArray instanceof XSLLocalParam) {
                arrayList2.add((XSLLocalParam)localParamArray);
                continue;
            }
            if (localParamArray instanceof XSLOnCompletion) {
                expression = ((StyleElement)((XSLOnCompletion)localParamArray)).compile((Compilation)object, componentDeclaration);
                continue;
            }
            arrayList.add(localParamArray);
        }
        localParamArray = new LocalParam[arrayList2.size()];
        for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
            localParamArray[i2] = (LocalParam)((StyleElement)((XSLLocalParam)arrayList2.get(i2))).compile((Compilation)object, componentDeclaration);
            if (!localParamArray[i2].isImplicitlyRequiredParam()) continue;
            this.compileError("The parameter must be given an initial value because () is not valid, given the declared type", "XTSE3520");
        }
        LocalParamBlock localParamBlock = new LocalParamBlock(localParamArray);
        if ((object = this.compileSequenceConstructor((Compilation)object, componentDeclaration, new ListIterator(arrayList), false)) == null) {
            return Literal.makeEmptySequence();
        }
        try {
            object = ((Expression)object).simplify();
            return new IterateInstr(this.a, localParamBlock, (Expression)object, expression);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return null;
        }
    }
}

