/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Predicate;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLKey
extends StyleElement
implements StylesheetComponent {
    private Pattern a;
    private Expression b;
    private String c;
    private StructuredQName d;
    private SlotManager e;
    private boolean f;
    private boolean g = false;
    private KeyDefinition h;
    private static a i = new a(0);

    @Override
    public Actor getActor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SymbolicName getSymbolicName() {
        return null;
    }

    @Override
    public void checkCompatibility(Component component) {
    }

    @Override
    public boolean isDeclaration() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public SlotManager getSlotManager() {
        return this.e;
    }

    @Override
    public void prepareAttributes() {
        String string = null;
        String string2 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string3 = attributeCollection.getURI(i2);
            String string4 = attributeCollection.getLocalName(i2);
            if ("".equals(string3)) {
                switch (string4) {
                    case "name": {
                        string = Whitespace.trim(attributeCollection.getValue(i2));
                        break;
                    }
                    case "use": {
                        string3 = attributeCollection.getValue(i2);
                        this.b = this.makeExpression(string3, i2);
                        break;
                    }
                    case "match": {
                        string2 = attributeCollection.getValue(i2);
                        break;
                    }
                    case "collation": {
                        this.c = Whitespace.trim(attributeCollection.getValue(i2));
                        break;
                    }
                    case "composite": {
                        this.g = this.processBooleanAttribute("composite", attributeCollection.getValue(i2));
                        break;
                    }
                    default: {
                        this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
                        break;
                    }
                }
                continue;
            }
            if (string4.equals("range-key") && string3.equals("http://saxon.sf.net/")) {
                this.f = this.processBooleanAttribute("range-key", attributeCollection.getValue(i2));
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (string == null) {
            this.reportAbsence("name");
            string = "_dummy_key_name";
        }
        try {
            this.d = this.makeQName(string);
            XSLKey xSLKey = this;
            xSLKey.setObjectName(xSLKey.d);
        }
        catch (XPathException xPathException) {
            this.compileErrorInAttribute(xPathException.getMessage(), xPathException.getErrorCodeLocalPart(), "name");
        }
        if (string2 == null) {
            this.reportAbsence("match");
            string2 = "*";
        }
        this.a = this.makePattern(string2, "match");
        if (this.a == null) {
            this.a = new NodeTestPattern(ErrorType.getInstance());
        }
    }

    public StructuredQName getKeyName() {
        try {
            String string;
            if (this.getObjectName() == null && (string = ((NodeImpl)this).getAttributeValue("", "name")) != null) {
                XSLKey xSLKey = this;
                xSLKey.setObjectName(xSLKey.makeQName(string));
            }
            return this.getObjectName();
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    @Override
    public void validate(ComponentDeclaration object) {
        Object object2;
        object = ((NodeImpl)this).getConfiguration();
        this.e = ((Configuration)object).makeSlotManager();
        this.checkTopLevel("XTSE0010", false);
        if (this.b != null) {
            if (((NodeImpl)this).hasChildNodes()) {
                this.compileError("An xsl:key element with a @use attribute must be empty", "XTSE1205");
            }
            try {
                object2 = new RoleDiagnostic(4, "xsl:key/use", 0);
                this.b = ((Configuration)object).getTypeChecker(false).staticTypeCheck(this.b, SequenceType.ATOMIC_SEQUENCE, (RoleDiagnostic)object2, this.makeExpressionVisitor());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        } else if (!((NodeImpl)this).hasChildNodes()) {
            this.compileError("An xsl:key element must either have a @use attribute or have content", "XTSE1205");
        }
        this.b = this.typeCheck("use", this.b);
        this.a = this.typeCheck("match", this.a);
        if (this.b != null) {
            this.b = this.b.typeCheck(this.makeExpressionVisitor(), ((Configuration)object).makeContextItemStaticInfo(((Expression)this.a).getItemType(), false));
        }
        if (this.c != null) {
            try {
                object2 = new URI(this.c);
                if (!((URI)object2).isAbsolute()) {
                    object = new URI(((NodeImpl)this).getBaseURI());
                    object2 = ((URI)object).resolve((URI)object2);
                    this.c = ((URI)object2).toString();
                }
                return;
            }
            catch (URISyntaxException uRISyntaxException) {
                this.compileError("Collation name '" + this.c + "' is not a valid URI");
                return;
            }
        }
        this.c = this.getDefaultCollationName();
    }

    @Override
    public void index(ComponentDeclaration object, PrincipalStylesheetModule principalStylesheetModule) {
        object = this.getKeyName();
        if (object != null) {
            principalStylesheetModule.getKeyManager().preRegisterKeyDefinition((StructuredQName)object);
        }
    }

    @Override
    public void compileDeclaration(Compilation compilation, ComponentDeclaration object) {
        Object object2 = this.getStaticContext();
        object2 = object2.getConfiguration();
        Object object3 = null;
        if (this.c != null) {
            XSLKey xSLKey = this;
            object3 = xSLKey.findCollation(xSLKey.c, ((NodeImpl)this).getBaseURI());
            if (object3 == null) {
                this.compileError("The collation name " + Err.wrap(this.c, 7) + " is not recognized", "XTSE1210");
                object3 = CodepointCollator.getInstance();
            }
            if (object3 instanceof CodepointCollator) {
                object3 = null;
                this.c = null;
            } else if (!Version.platform.canReturnCollationKeys((StringCollator)object3)) {
                this.compileError("The collation used for xsl:key must be capable of generating collation keys", "XTSE1210");
            }
        }
        if (this.b == null) {
            object = this.compileSequenceConstructor(compilation, (ComponentDeclaration)object, true);
            try {
                this.b = Atomizer.makeAtomizer((Expression)object, null);
                this.b = this.b.simplify();
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
            try {
                object = new RoleDiagnostic(4, "xsl:key/use", 0);
                this.b = ((Configuration)object2).getTypeChecker(false).staticTypeCheck(this.b, SequenceType.ATOMIC_SEQUENCE, (RoleDiagnostic)object, this.makeExpressionVisitor());
                assert (this.a != null);
                this.b = this.b.typeCheck(this.makeExpressionVisitor(), ((Configuration)object2).makeContextItemStaticInfo(((Expression)this.a).getItemType(), false));
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        if ((object = this.b.getItemType()) == ErrorType.getInstance()) {
            object = BuiltInAtomicType.STRING;
        }
        object = (BuiltInAtomicType)object.getPrimitiveItemType();
        if (this.xPath10ModeIsEnabled() && !((BuiltInAtomicType)object).equals(BuiltInAtomicType.STRING) && !((BuiltInAtomicType)object).equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            this.b = new AtomicSequenceConverter(this.b, BuiltInAtomicType.STRING);
            ((AtomicSequenceConverter)this.b).allocateConverter((Configuration)object2, false);
            object = BuiltInAtomicType.STRING;
        }
        int n2 = 0;
        if ((((Expression)this.a).getDependencies() & 1) != 0) {
            n2 = 1;
        }
        this.a.allocateSlots(this.e, n2);
        n2 = ExpressionTool.contains(this.b, false, i) || ExpressionTool.contains(this.a, false, i) ? 1 : 0;
        KeyManager keyManager = this.getCompilation().getPrincipalStylesheetModule().getKeyManager();
        SymbolicName symbolicName = new SymbolicName(165, this.d);
        object3 = new KeyDefinition(symbolicName, this.a, this.b, this.c, (StringCollator)object3);
        ((Actor)object3).setPackageData(this.getCompilation().getPackageData());
        ((KeyDefinition)object3).setRangeKey(this.f);
        ((KeyDefinition)object3).setIndexedItemType((BuiltInAtomicType)object);
        ((Actor)object3).setStackFrameMap(this.e);
        ((KeyDefinition)object3).setLocation(((NodeImpl)this).getSystemId(), ((NodeImpl)this).getLineNumber());
        ((KeyDefinition)object3).setBackwardsCompatible(this.xPath10ModeIsEnabled());
        ((KeyDefinition)object3).setComposite(this.g);
        ((Actor)object3).obtainDeclaringComponent(this);
        try {
            keyManager.addKeyDefinition(this.d, (KeyDefinition)object3, n2 == 0, compilation.getConfiguration());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        this.h = object3;
    }

    @Override
    public void optimize(ComponentDeclaration object) {
        object = this.makeExpressionVisitor();
        ContextItemStaticInfo contextItemStaticInfo = ((NodeImpl)this).getConfiguration().makeContextItemStaticInfo(((Expression)this.a).getItemType(), false);
        Expression expression = this.h.getUse();
        expression = expression.optimize((ExpressionVisitor)object, contextItemStaticInfo);
        this.allocateLocalSlots(expression);
        this.h.setBody(expression);
    }

    @Override
    public void generateByteCode(Optimizer optimizer) {
    }

    private static final class a
    implements Predicate<Expression> {
        private a() {
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

