/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.AdjacentTextNodeMerger;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public abstract class XSLLeafNodeConstructor
extends StyleElement {
    protected Expression select = null;

    protected Expression prepareAttributesNameAndSelect() {
        Expression expression = null;
        String string = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string2 = attributeCollection.getQName(i2);
            if (string2.equals("name")) {
                string = Whitespace.trim(attributeCollection.getValue(i2));
                expression = this.makeAttributeValueTemplate(string, i2);
                continue;
            }
            if (string2.equals("select")) {
                string2 = attributeCollection.getValue(i2);
                this.select = this.makeExpression(string2, i2);
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (string == null) {
            this.reportAbsence("name");
        }
        return expression;
    }

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void validate(ComponentDeclaration object) {
        if (this.select != null && ((NodeImpl)this).hasChildNodes()) {
            object = this.getErrorCodeForSelectPlusContent();
            this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty", (String)object);
        }
        object = this.iterateAxis((byte)3);
        NodeInfo nodeInfo = object.next();
        if (this.select == null) {
            if (nodeInfo == null) {
                this.select = new StringLiteral(StringValue.EMPTY_STRING);
                this.select.setRetainedStaticContext(this.makeRetainedStaticContext());
                return;
            }
            if (object.next() == null && !this.isExpandingText() && nodeInfo.getNodeKind() == 3) {
                this.select = new StringLiteral(nodeInfo.getStringValue());
                this.select.setRetainedStaticContext(this.makeRetainedStaticContext());
            }
        }
    }

    protected abstract String getErrorCodeForSelectPlusContent();

    protected void compileContent(Compilation compilation, ComponentDeclaration componentDeclaration, SimpleNodeConstructor simpleNodeConstructor, Expression expression) {
        if (expression == null) {
            expression = new StringLiteral(StringValue.SINGLE_SPACE);
        }
        try {
            if (this.select == null) {
                this.select = this.compileSequenceConstructor(compilation, componentDeclaration, true);
            }
            this.select = XSLLeafNodeConstructor.makeSimpleContentConstructor(this.select, expression, this.getStaticContext());
            simpleNodeConstructor.setSelect(this.select);
            return;
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return;
        }
    }

    public static Expression makeSimpleContentConstructor(Expression expression, Expression expression2, StaticContext staticContext) {
        RetainedStaticContext retainedStaticContext = expression.getLocalRetainedStaticContext();
        if (retainedStaticContext == null) {
            retainedStaticContext = staticContext.makeRetainedStaticContext();
        }
        expression = AdjacentTextNodeMerger.makeAdjacentTextNodeMerger(expression);
        expression = Atomizer.makeAtomizer(expression, null);
        expression = new AtomicSequenceConverter(expression, BuiltInAtomicType.STRING);
        expression.setRetainedStaticContext(retainedStaticContext);
        ((AtomicSequenceConverter)expression).allocateConverterStatically(staticContext.getConfiguration(), false);
        if (expression.getCardinality() != 16384) {
            expression = SystemFunction.makeCall("string-join", retainedStaticContext, expression, expression2);
        }
        return expression;
    }
}

