/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLLocalParam
extends XSLGeneralVariable {
    private int a = 408;
    private Expression b = null;
    private int c = -9876;
    private LocalParam d;
    private boolean e = false;

    @Override
    public SourceBinding getBindingInformation(StructuredQName structuredQName) {
        if (structuredQName.equals(this.sourceBinding.getVariableQName())) {
            return this.sourceBinding;
        }
        return null;
    }

    public int getSlotNumber() {
        return this.c;
    }

    @Override
    public void prepareAttributes() {
        if (!this.e) {
            this.e = true;
            this.sourceBinding.setProperty(4, true);
            if (this.getParent() instanceof XSLFunction) {
                this.a &= 0xFFFFFF7F;
                this.sourceBinding.setProperty(512, true);
            }
            this.sourceBinding.prepareAttributes(this.a);
            if (this.sourceBinding.hasProperty(8) && !(this.getParent() instanceof XSLTemplate)) {
                this.compileError("For attribute 'tunnel' within an " + this.getParent().getDisplayName() + " parameter, the only permitted value is 'no'", "XTSE0020");
            }
            if (this.getParent() instanceof XSLFunction && ((NodeImpl)this).getAttributeValue("", "required") != null && !this.sourceBinding.hasProperty(16)) {
                this.compileError("For attribute 'required' within an " + this.getParent().getDisplayName() + " parameter, the only permitted value is 'yes'", "XTSE0020");
            }
        }
    }

    public void prepareTemplateSignatureAttributes() {
        if (!this.e) {
            this.sourceBinding.setProperty(4, true);
            this.sourceBinding.prepareTemplateSignatureAttributes();
        }
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        StructuredQName structuredQName = this.sourceBinding.getVariableQName();
        Object object = this.getParent();
        if (!(object instanceof StyleElement) || !((StyleElement)object).mayContainParam()) {
            this.compileError("xsl:param must be immediately within a template, function or stylesheet", "XTSE0010");
        }
        if (((NodeImpl)this).hasChildNodes() && this.getParent() instanceof XSLFunction) {
            this.compileError("Function parameters cannot have a default value", "XTSE0760");
        }
        this.iterateAxis((byte)11).forEachOrFail(nodeInfo -> {
            if (nodeInfo instanceof XSLLocalParam) {
                if (structuredQName.equals(((XSLLocalParam)nodeInfo).sourceBinding.getVariableQName())) {
                    this.compileError("The name of the parameter is not unique", "XTSE0580");
                    return;
                }
            } else {
                if (nodeInfo instanceof StyleElement && nodeInfo.getFingerprint() != 144) {
                    this.compileError("xsl:param must not be preceded by other instructions", "XTSE0010");
                    return;
                }
                if (!Whitespace.isWhite(nodeInfo.getStringValueCS())) {
                    this.compileError("xsl:param must not be preceded by text", "XTSE0010");
                }
            }
        });
        object = this.getContainingSlotManager();
        if (object == null) {
            this.compileError("Local variable must be declared within a template or function", "XTSE0010");
        } else {
            this.c = ((SlotManager)object).allocateSlotNumber(structuredQName);
        }
        if (this.sourceBinding.hasProperty(16)) {
            if (this.sourceBinding.getSelectExpression() != null) {
                this.compileError("The select attribute must be omitted when required='yes'", "XTSE0010");
            }
            if (((NodeImpl)this).hasChildNodes()) {
                this.compileError("A parameter specifying required='yes' must have empty content", "XTSE0010");
            }
        }
        super.validate(componentDeclaration);
    }

    public boolean isTunnelParam() {
        return this.sourceBinding.hasProperty(8);
    }

    public boolean isRequiredParam() {
        return this.sourceBinding.hasProperty(16);
    }

    @Override
    public void fixupReferences() {
        this.sourceBinding.fixupReferences(null);
        super.fixupReferences();
    }

    @Override
    public Expression compile(Compilation compilation, ComponentDeclaration componentDeclaration) {
        Expression expression;
        if (this.getParent() instanceof XSLFunction) {
            return null;
        }
        SequenceType sequenceType = this.getRequiredType();
        StructuredQName structuredQName = this.sourceBinding.getVariableQName();
        int n2 = this.getSlotNumber();
        if (sequenceType != null) {
            expression = new SuppliedParameterReference(n2);
            expression.setRetainedStaticContext(this.makeRetainedStaticContext());
            expression.setLocation(this.allocateLocation());
            RoleDiagnostic roleDiagnostic = new RoleDiagnostic(8, structuredQName.getDisplayName(), 0);
            roleDiagnostic.setErrorCode("XTTE0590");
            this.b = compilation.getConfiguration().getTypeChecker(false).staticTypeCheck(expression, sequenceType, roleDiagnostic, this.makeExpressionVisitor());
        }
        this.sourceBinding.handleSequenceConstructor(compilation, componentDeclaration);
        expression = new LocalParam();
        ((LocalParam)expression).setSelectExpression(this.sourceBinding.getSelectExpression());
        ((LocalParam)expression).setConversion(this.b);
        ((LocalParam)expression).setVariableQName(structuredQName);
        ((LocalParam)expression).setSlotNumber(n2);
        ((LocalParam)expression).setRequiredType(this.getRequiredType());
        ((LocalParam)expression).setRequiredParam(this.sourceBinding.hasProperty(16));
        ((LocalParam)expression).setImplicitlyRequiredParam(this.sourceBinding.hasProperty(32));
        ((LocalParam)expression).setTunnel(this.sourceBinding.hasProperty(8));
        this.sourceBinding.fixupBinding((Binding)((Object)expression));
        this.d = expression;
        return this.d;
    }

    public LocalParam getCompiledParam() {
        return this.d;
    }

    public SequenceType getRequiredType() {
        SequenceType sequenceType = this.sourceBinding.getDeclaredType();
        if (sequenceType != null) {
            return sequenceType;
        }
        return SequenceType.ANY_SEQUENCE;
    }
}

