/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.SequenceInstr;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.ItemType;

public class XSLMapEntry
extends StyleElement {
    private Expression a = null;
    private Expression b = null;

    @Override
    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return MapType.ANY_MAP_TYPE;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string2 = attributeCollection.getQName(i2);
            if (string2.equals("key")) {
                string = attributeCollection.getValue(i2);
                this.a = this.makeExpression(string, i2);
                continue;
            }
            if (string2.equals("select")) {
                string2 = attributeCollection.getValue(i2);
                this.b = this.makeExpression(string2, i2);
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (string == null) {
            this.reportAbsence("key");
        }
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        this.a = this.typeCheck("key", this.a);
        this.b = this.typeCheck("select", this.b);
        if (this.b != null) {
            NodeInfo nodeInfo;
            boolean bl2 = false;
            AxisIterator axisIterator = this.iterateAxis((byte)3);
            while ((nodeInfo = axisIterator.next()) != null) {
                if (nodeInfo instanceof XSLFallback) continue;
                bl2 = true;
            }
            if (bl2) {
                String string = "XTSE3280";
                this.compileError("An xsl:map-entry element with a select attribute must be empty", string);
            }
        }
    }

    @Override
    public Expression compile(Compilation object, ComponentDeclaration componentDeclaration) {
        if (this.b == null) {
            this.b = this.compileSequenceConstructor((Compilation)object, componentDeclaration, false);
            this.b = this.b.simplify();
        }
        object = MapFunctionSet.getInstance().makeFunction("entry", 2).makeFunctionCall(this.a, this.b);
        if (((NodeImpl)this).getConfiguration().getBooleanProperty(Feature.STRICT_STREAMABILITY)) {
            object = new SequenceInstr((Expression)object);
        }
        return object;
    }
}

