/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PseudoExpression;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.sort.MergeInstr;
import net.sf.saxon.expr.sort.SortExpression;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLMergeAction;
import net.sf.saxon.style.XSLMergeSource;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.Whitespace;

public class XSLMerge
extends StyleElement {
    private int a = 0;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    protected void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        Object object;
        int n2 = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        HashSet<Object> hashSet = new HashSet<Object>();
        while ((object = axisIterator.next()) != null) {
            if (object instanceof XSLMergeSource) {
                if (hashSet.contains(object = ((XSLMergeSource)object).getSourceName())) {
                    this.compileError("Duplicate xsl:merge-source/@name", "XTSE3190");
                }
                hashSet.add(object);
                n2 |= 1;
                ++this.a;
                continue;
            }
            if (object instanceof XSLMergeAction) {
                if ((n2 & 2) == 2) {
                    this.compileError("xsl:merge must have only one xsl:merge-action child element", "XTSE0010");
                }
                n2 |= 2;
                continue;
            }
            if (object.getNodeKind() == 3) {
                if (Whitespace.isWhite(object.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:merge", "XXXX");
                continue;
            }
            if (object instanceof XSLFallback) {
                if ((n2 & 2) != 0) continue;
                this.compileError("xsl:fallback child of xsl:merge can appear only after xsl:merge-action", "XTSE0010");
                continue;
            }
            this.compileError("Child element " + Err.wrap(object.getDisplayName(), 1) + " is not allowed as a child of xsl:merge", "XTSE0010");
        }
        if (n2 == 1) {
            this.compileError("xsl:merge element requires an xsl:merge-action", "XTSE0010");
            return;
        }
        if (n2 == 2) {
            this.compileError("xsl:merge element requires at least one xsl:merge-source child element", "XTSE0010");
        }
    }

    private static boolean a(Expression expression, Expression expression2) {
        return expression == null && expression2 == null || expression != null && expression.equals(expression2);
    }

    @Override
    public Expression compile(Compilation object, ComponentDeclaration mergeSourceArray) {
        PseudoExpression pseudoExpression;
        Object object2;
        MergeInstr mergeInstr = new MergeInstr();
        int n2 = this.a;
        MergeInstr.MergeSource[] mergeSourceArray2 = new MergeInstr.MergeSource[n2];
        Expression expression = Literal.makeEmptySequence();
        int n3 = 0;
        int n4 = 0;
        Object object3 = this.iterateAxis((byte)3);
        while ((object2 = object3.next()) != null) {
            if (object2 instanceof XSLMergeSource) {
                object2 = (XSLMergeSource)object2;
                pseudoExpression = ((StyleElement)object2).makeSortKeys((Compilation)object, (ComponentDeclaration)mergeSourceArray);
                if (n4 == 0) {
                    n4 = ((SortKeyDefinitionList)pseudoExpression).size();
                } else if (n4 != ((SortKeyDefinitionList)pseudoExpression).size()) {
                    this.compileError("Each xsl:merge-source must have the same number of xsl:merge-key children", "XTSE2200");
                }
                Expression expression2 = ((XSLMergeSource)object2).getSelect();
                if (((XSLMergeSource)object2).isSortBeforeMerge()) {
                    expression2 = new SortExpression(expression2, ((SortKeyDefinitionList)pseudoExpression).copy(new RebindingMap()));
                }
                object2 = ((XSLMergeSource)object2).makeMergeSource(mergeInstr, expression2);
                v0.mergeKeyDefinitions = pseudoExpression;
                mergeSourceArray2[n3++] = object2;
                continue;
            }
            if (!(object2 instanceof XSLMergeAction)) continue;
            expression = ((XSLMergeAction)object2).compileSequenceConstructor((Compilation)object, (ComponentDeclaration)mergeSourceArray, true);
            if (expression == null) {
                expression = Literal.makeEmptySequence();
            }
            try {
                expression = expression.simplify();
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        mergeSourceArray = mergeSourceArray2;
        object = this;
        for (n3 = 0; n3 < mergeSourceArray[0].mergeKeyDefinitions.size() && mergeSourceArray[0].mergeKeyDefinitions.getSortKeyDefinition(n3).isFixed(); ++n3) {
            for (n4 = 1; n4 < mergeSourceArray.length && mergeSourceArray[n4].mergeKeyDefinitions.getSortKeyDefinition(n3).isFixed(); ++n4) {
                pseudoExpression = mergeSourceArray[0].mergeKeyDefinitions.getSortKeyDefinition(n3);
                object2 = mergeSourceArray[n4].mergeKeyDefinitions.getSortKeyDefinition(n3);
                object3 = object;
                if (XSLMerge.a(((SortKeyDefinition)object2).getLanguage(), ((SortKeyDefinition)pseudoExpression).getLanguage()) && XSLMerge.a(((SortKeyDefinition)object2).getOrder(), ((SortKeyDefinition)pseudoExpression).getOrder()) && XSLMerge.a(((SortKeyDefinition)object2).getCollationNameExpression(), ((SortKeyDefinition)pseudoExpression).getCollationNameExpression()) && XSLMerge.a(((SortKeyDefinition)object2).getCaseOrder(), ((SortKeyDefinition)pseudoExpression).getCaseOrder()) && XSLMerge.a(((SortKeyDefinition)object2).getDataTypeExpression(), ((SortKeyDefinition)pseudoExpression).getDataTypeExpression())) continue;
                ((StyleElement)object).compileError("The " + RoleDiagnostic.ordinal(n3 + 1) + " merge key definition of the " + RoleDiagnostic.ordinal(n4 + 1) + " merge source is incompatible with the " + RoleDiagnostic.ordinal(n3 + 1) + " merge key definition of the first merge source", "XTDE2210");
            }
        }
        mergeInstr.init(mergeSourceArray2, expression);
        return mergeInstr;
    }
}

