/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashSet;
import java.util.Set;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.expr.sort.MergeInstr;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLMergeKey;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public class XSLMergeSource
extends StyleElement {
    private Expression a;
    private Expression b;
    private Expression c;
    private boolean d = false;
    private int e = 0;
    private String f;
    private int g = 4;
    private SchemaType h = null;
    private boolean i = false;
    private Set<Accumulator> j = new HashSet<Accumulator>();

    @Override
    public boolean isInstruction() {
        return false;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public Expression getForEachItem() {
        return this.a;
    }

    public Expression getForEachSource() {
        return this.b;
    }

    public Expression getSelect() {
        return this.c;
    }

    public boolean isSortBeforeMerge() {
        return this.d;
    }

    public String getSourceName() {
        return this.f;
    }

    public int getValidationAction() {
        return this.g;
    }

    public SchemaType getSchemaTypeAttribute() {
        return this.h;
    }

    public MergeInstr.MergeSource makeMergeSource(MergeInstr mergeInstr, Expression expression) {
        MergeInstr.MergeSource mergeSource = new MergeInstr.MergeSource(mergeInstr);
        if (this.a != null) {
            mergeSource.initForEachItem(mergeInstr, this.a);
        }
        if (this.b != null) {
            mergeSource.initForEachStream(mergeInstr, this.b);
        }
        if (expression != null) {
            this.c = expression;
            mergeSource.initRowSelect(mergeInstr, expression);
        }
        mergeSource.baseURI = ((NodeImpl)this).getBaseURI();
        mergeSource.sourceName = this.f;
        mergeSource.validation = this.g;
        mergeSource.schemaType = this.h;
        mergeSource.setStreamable(this.i);
        mergeSource.accumulators = this.j;
        return mergeSource;
    }

    @Override
    public Expression compile(Compilation compilation, ComponentDeclaration componentDeclaration) {
        return null;
    }

    @Override
    protected void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        block22: for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            switch (attributeCollection.getQName(i2)) {
                case "for-each-item": {
                    string2 = attributeCollection.getValue(i2);
                    this.a = this.makeExpression(string2, i2);
                    continue block22;
                }
                case "for-each-source": {
                    string3 = attributeCollection.getValue(i2);
                    this.b = this.makeExpression(string3, i2);
                    continue block22;
                }
                case "select": {
                    string = attributeCollection.getValue(i2);
                    this.c = this.makeExpression(string, i2);
                    continue block22;
                }
                case "sort-before-merge": {
                    this.d = this.processBooleanAttribute("sort-before-merge", attributeCollection.getValue(i2));
                    continue block22;
                }
                case "name": {
                    String string8 = Whitespace.trim(attributeCollection.getValue(i2));
                    if (NameChecker.isValidNCName(string8)) {
                        this.f = string8;
                        continue block22;
                    }
                    this.compileError("xsl:merge-source/@name (" + string8 + ") is not a valid NCName", "XTSE0020");
                    continue block22;
                }
                case "validation": {
                    string4 = Whitespace.trim(attributeCollection.getValue(i2));
                    continue block22;
                }
                case "type": {
                    string5 = Whitespace.trim(attributeCollection.getValue(i2));
                    continue block22;
                }
                case "streamable": {
                    string6 = attributeCollection.getValue(i2);
                    continue block22;
                }
                case "use-accumulators": {
                    string7 = Whitespace.trim(attributeCollection.getValue(i2));
                    continue block22;
                }
                default: {
                    this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
                }
            }
        }
        if (this.f == null) {
            this.f = "saxon-merge-source-" + this.hashCode();
        }
        if (string2 != null && string3 != null) {
            this.compileError("The for-each-item and for-each-source attributes must not both be present", "XTSE3195");
        }
        if (string == null) {
            this.reportAbsence("select");
        }
        this.g = string4 == null ? this.getDefaultValidation() : this.validateValidationAttribute(string4);
        if (string5 != null) {
            if (!this.isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.h = this.getSchemaType(string5);
            this.g = 8;
        }
        if (string5 != null && string4 != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
        if ((string5 != null || string4 != null) && string3 == null) {
            this.compileError("The @type and @validation attributes can be used only when @for-each-stream is specified", "XTSE0020");
        }
        if (string6 != null) {
            this.i = this.b(string6);
            if (this.i && this.b == null) {
                this.compileError("Streaming on xsl:merge-source is possible only when @for-each-source is used", "XTSE3195");
            }
        } else if (this.b != null) {
            this.i = false;
        }
        if (string7 == null) {
            string7 = "";
        }
        AccumulatorRegistry accumulatorRegistry = this.getPrincipalStylesheetModule().getStylesheetPackage().getAccumulatorRegistry();
        this.j = accumulatorRegistry.getUsedAccumulators(string7, this);
    }

    @Override
    public void validate(ComponentDeclaration object) {
        NodeInfo nodeInfo;
        this.a = this.typeCheck("for-each-item", this.a);
        this.b = this.typeCheck("for-each-source", this.b);
        this.c = this.typeCheck("select", this.c);
        object = this.iterateAxis((byte)3);
        while ((nodeInfo = object.next()) != null) {
            if (nodeInfo instanceof XSLMergeKey) {
                ++this.e;
                continue;
            }
            if (nodeInfo.getNodeKind() == 3) {
                if (Whitespace.isWhite(nodeInfo.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:merge-source", "XTSE0010");
                continue;
            }
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).compileError("No children other than xsl:merge-key are allowed within xsl:merge-source", "XTSE0010");
        }
        if (this.e == 0) {
            this.compileError("xsl:merge-source must have exactly at least one xsl:merge-key child element", "XTSE0010");
        }
    }
}

