/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.VisibilityProvenance;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.BuiltInRuleSet;
import net.sf.saxon.trans.rules.DeepCopyRuleSet;
import net.sf.saxon.trans.rules.DeepSkipRuleSet;
import net.sf.saxon.trans.rules.FailRuleSet;
import net.sf.saxon.trans.rules.RuleManager;
import net.sf.saxon.trans.rules.RuleSetWithWarnings;
import net.sf.saxon.trans.rules.ShallowCopyRuleSet;
import net.sf.saxon.trans.rules.ShallowSkipRuleSet;
import net.sf.saxon.trans.rules.TextOnlyCopyRuleSet;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.value.Whitespace;

public class XSLMode
extends StyleElement {
    private SimpleMode a;
    private Set<? extends Accumulator> b;
    private boolean c = false;
    private boolean d = false;
    private boolean e = false;
    private boolean f = false;
    private boolean g = true;
    private boolean h = false;
    private BuiltInRuleSet i = TextOnlyCopyRuleSet.getInstance();

    @Override
    public boolean isDeclaration() {
        return true;
    }

    @Override
    public boolean isInstruction() {
        return false;
    }

    @Override
    public StructuredQName getObjectName() {
        Object object = super.getObjectName();
        if (object == null) {
            object = Whitespace.trim(((NodeImpl)this).getAttributeValue("", "name"));
            if (object == null) {
                return Mode.UNNAMED_MODE_NAME;
            }
            try {
                object = this.makeQName((String)object);
                this.setObjectName((StructuredQName)object);
            }
            catch (XPathException xPathException) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-mode-" + this.generateId());
            }
        }
        return object;
    }

    @Override
    public void index(ComponentDeclaration object, PrincipalStylesheetModule object2) {
        StructuredQName structuredQName = ((StyleElement)this).getObjectName();
        Object object3 = new SymbolicName(174, structuredQName);
        HashMap<SymbolicName, Component> hashMap = object2.getStylesheetPackage().getComponentIndex();
        if (!structuredQName.equals(Mode.UNNAMED_MODE_NAME) && (object3 = hashMap.get(object3)) != null && ((Component)object3).getDeclaringPackage() != object2.getStylesheetPackage()) {
            this.compileError("Mode " + structuredQName.getDisplayName() + " conflicts with a public named mode in package " + ((Component)object3).getDeclaringPackage().getPackageName(), "XTSE3050");
        }
        this.a = (SimpleMode)object2.getRuleManager().obtainMode(structuredQName, true);
        if (structuredQName.equals(Mode.UNNAMED_MODE_NAME)) {
            object2.getRuleManager().setUnnamedModeExplicit(true);
            return;
        }
        if (this.a.getDeclaringComponent().getDeclaringPackage() != this.getContainingPackage()) {
            this.compileError("Mode name conflicts with a mode in a used package", "XTSE3050");
            return;
        }
        object2.indexMode((ComponentDeclaration)object);
        object3 = this.getDeclaredVisibility();
        object = object3 == null ? Visibility.PRIVATE : object3;
        object2 = object3 == null ? VisibilityProvenance.DEFAULTED : VisibilityProvenance.EXPLICIT;
        this.a.getDeclaringComponent().setVisibility((Visibility)((Object)object), (VisibilityProvenance)((Object)object2));
    }

    @Override
    public void prepareAttributes() {
        Object object;
        String string = null;
        String string2 = null;
        if (this.c) {
            return;
        }
        this.c = true;
        AttributeCollection attributeCollection = this.getAttributeList();
        block48: for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            switch (object = attributeCollection.getQName(i2)) {
                case "streamable": {
                    this.d = this.b(attributeCollection.getValue(i2));
                    continue block48;
                }
                case "name": {
                    string = Whitespace.trim(attributeCollection.getValue(i2));
                    if (string.equals("#default")) continue block48;
                    try {
                        XSLMode xSLMode = this;
                        xSLMode.setObjectName(xSLMode.makeQName(string));
                    }
                    catch (XPathException xPathException) {
                        this.compileError(xPathException);
                    }
                    continue block48;
                }
                case "use-accumulators": {
                    Object object2 = attributeCollection.getValue(i2);
                    this.b = this.getPrincipalStylesheetModule().getStylesheetPackage().getAccumulatorRegistry().getUsedAccumulators((String)object2, this);
                    continue block48;
                }
                case "on-multiple-match": {
                    switch (Whitespace.trim(attributeCollection.getValue(i2))) {
                        case "fail": {
                            this.e = true;
                            continue block48;
                        }
                        case "use-last": {
                            this.e = false;
                            continue block48;
                        }
                    }
                    this.invalidAttribute((String)object, "fail|use-last");
                    continue block48;
                }
                case "on-no-match": {
                    Object object2 = Whitespace.trim(attributeCollection.getValue(i2));
                    assert (object2 != null);
                    int n2 = -1;
                    switch (((String)object2).hashCode()) {
                        case -2068713386: {
                            if (!((String)object2).equals("text-only-copy")) break;
                            n2 = 0;
                            break;
                        }
                        case -1628128370: {
                            if (!((String)object2).equals("shallow-copy")) break;
                            n2 = 1;
                            break;
                        }
                        case -2026960970: {
                            if (!((String)object2).equals("deep-copy")) break;
                            n2 = 2;
                            break;
                        }
                        case -1627655784: {
                            if (!((String)object2).equals("shallow-skip")) break;
                            n2 = 3;
                            break;
                        }
                        case -2026488384: {
                            if (!((String)object2).equals("deep-skip")) break;
                            n2 = 4;
                            break;
                        }
                        case 3135262: {
                            if (!((String)object2).equals("fail")) break;
                            n2 = 5;
                        }
                    }
                    switch (n2) {
                        case 0: {
                            continue block48;
                        }
                        case 1: {
                            this.i = ShallowCopyRuleSet.getInstance();
                            continue block48;
                        }
                        case 2: {
                            this.i = DeepCopyRuleSet.getInstance();
                            continue block48;
                        }
                        case 3: {
                            this.i = ShallowSkipRuleSet.getInstance();
                            continue block48;
                        }
                        case 4: {
                            this.i = DeepSkipRuleSet.getInstance();
                            continue block48;
                        }
                        case 5: {
                            this.i = FailRuleSet.getInstance();
                            continue block48;
                        }
                    }
                    this.invalidAttribute((String)object, "text-only-copy|shallow-copy|deep-copy|shallow-skip|deep-skip|fail");
                    continue block48;
                }
                case "warning-on-multiple-match": {
                    Object object2 = Whitespace.trim(attributeCollection.getValue(i2));
                    this.g = this.processBooleanAttribute("warning-on-multiple-match", (String)object2);
                    continue block48;
                }
                case "warning-on-no-match": {
                    Object object2 = Whitespace.trim(attributeCollection.getValue(i2));
                    this.f = this.processBooleanAttribute("warning-on-no-match", (String)object2);
                    continue block48;
                }
                case "typed": {
                    Object object2 = Whitespace.trim(attributeCollection.getValue(i2));
                    this.checkAttributeValue("typed", (String)object2, false, new String[]{"0", "1", "false", "lax", "no", "strict", "true", "unspecified", "yes"});
                    continue block48;
                }
                case "visibility": {
                    string2 = Whitespace.trim(attributeCollection.getValue(i2));
                    Object object2 = this.interpretVisibilityValue(string2, "");
                    if (object2 == Visibility.ABSTRACT) {
                        this.invalidAttribute((String)object, "public|private|final");
                    }
                    this.a.setDeclaredVisibility((Visibility)((Object)object2));
                    continue block48;
                }
                default: {
                    Object object2;
                    if (attributeCollection.getURI(i2).equals("http://saxon.sf.net/") && attributeCollection.getLocalName(i2).equals("trace")) {
                        object2 = Whitespace.trim(attributeCollection.getValue(i2));
                        this.h = this.processBooleanAttribute("saxon:trace", (String)object2);
                        continue block48;
                    }
                    this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
                }
            }
        }
        if (string == null && string2 != null && this.a.getDeclaredVisibility() != Visibility.PRIVATE) {
            this.compileError("The unnamed mode must be private", "XTSE0020");
        }
        RuleManager ruleManager = this.getCompilation().getPrincipalStylesheetModule().getRuleManager();
        if (((StyleElement)this).getObjectName() == null) {
            this.a = ruleManager.getUnnamedMode();
        } else {
            object = ruleManager.obtainMode(((StyleElement)this).getObjectName(), true);
            if (object instanceof SimpleMode) {
                this.a = (SimpleMode)object;
            } else {
                this.compileError("Mode name refers to an overridden mode");
                this.a = ruleManager.getUnnamedMode();
            }
        }
        this.a.setStreamable(this.d);
        if (this.d) {
            object = ruleManager.obtainMode(Mode.OMNI_MODE, true);
            ((Mode)object).setStreamable(true);
        }
        if (this.f) {
            this.i = new RuleSetWithWarnings(this.i);
        }
        this.a.setBuiltInRuleSet(this.i);
        int n3 = this.e ? 2 : (this.g ? 1 : 0);
        this.a.setRecoveryPolicy(n3);
        this.a.obtainDeclaringComponent(this);
        this.a.setModeTracing(this.h);
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        this.checkTopLevel("XTSE0010", false);
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            Object[] objectArray;
            String string = attributeCollection.getQName(i2);
            if (string.equals("streamable") || string.equals("on-multiple-match") || string.equals("on-no-match") || string.equals("warning-on-multiple-match") || string.equals("warning-on-no-match") || string.equals("typed")) {
                objectArray = Whitespace.trim(attributeCollection.getValue(i2));
                Object object = "true".equals(objectArray) || "1".equals(objectArray) ? "yes" : ("false".equals(objectArray) || "0".equals(objectArray) ? "no" : objectArray);
                ((Mode)this.a).getActivePart().setExplicitProperty(string, (String)object, componentDeclaration.getPrecedence());
                if (!this.a.isMustBeTyped() || !this.getContainingPackage().getTargetEdition().matches("JS\\d?")) continue;
                this.compileWarning("In Saxon-JS, all data is untyped", "XTTE3110");
                continue;
            }
            if (!string.equals("use-accumulators") || this.b == null) continue;
            objectArray = new String[this.b.size()];
            int n2 = 0;
            for (Accumulator accumulator : this.b) {
                objectArray[n2++] = accumulator.getAccumulatorName().getEQName();
            }
            Arrays.sort(objectArray);
            String string2 = Arrays.toString(objectArray);
            ((Mode)this.a).getActivePart().setExplicitProperty(string, string2, componentDeclaration.getPrecedence());
        }
        this.checkEmpty();
        this.checkTopLevel("XTSE0010", false);
    }

    @Override
    public void compileDeclaration(Compilation object, ComponentDeclaration componentDeclaration) {
        object = this.getPrincipalStylesheetModule().getStylesheetPackage();
        if ((object = ((StylesheetPackage)object).getComponent(((Actor)this.a).getSymbolicName())) == null) {
            throw new AssertionError();
        }
        if (this.b != null) {
            this.a.setAccumulators(this.b);
        }
    }
}

