/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.value.Whitespace;

public class XSLNamespaceAlias
extends StyleElement {
    private String a;
    private NamespaceBinding b;

    @Override
    public boolean isDeclaration() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        String string = null;
        String string2 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string3 = attributeCollection.getQName(i2);
            if (string3.equals("stylesheet-prefix")) {
                string = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (string3.equals("result-prefix")) {
                string2 = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (string == null) {
            this.reportAbsence("stylesheet-prefix");
            string = "";
        }
        if (string.equals("#default")) {
            string = "";
        }
        if (string2 == null) {
            this.reportAbsence("result-prefix");
            string2 = "";
        }
        if (string2.equals("#default")) {
            string2 = "";
        }
        this.a = this.getURIForPrefix(string, true);
        if (this.a == null) {
            this.compileError("stylesheet-prefix " + string + " has not been declared", "XTSE0812");
            this.a = "";
            this.b = NamespaceBinding.DEFAULT_UNDECLARATION;
            return;
        }
        String string4 = this.getURIForPrefix(string2, true);
        if (string4 == null) {
            this.compileError("result-prefix " + string2 + " has not been declared", "XTSE0812");
            this.a = "";
            string4 = "";
        }
        this.b = new NamespaceBinding(string2, string4);
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        this.checkTopLevel("XTSE0010", false);
    }

    @Override
    public Expression compile(Compilation compilation, ComponentDeclaration componentDeclaration) {
        return null;
    }

    @Override
    public void index(ComponentDeclaration componentDeclaration, PrincipalStylesheetModule principalStylesheetModule) {
        principalStylesheetModule.addNamespaceAlias(componentDeclaration);
    }

    public String getStylesheetURI() {
        return this.a;
    }

    public NamespaceBinding getResultNamespaceBinding() {
        return this.b;
    }
}

