/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.NextIteration;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.XSLBreakOrContinue;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Err;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLNextIteration
extends XSLBreakOrContinue {
    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        this.validatePosition();
        if (this.xslIterate == null) {
            this.compileError("xsl:next-iteration must be a descendant of an xsl:iterate instruction");
        }
        this.iterateAxis((byte)3).forEachOrFail(nodeInfo -> {
            if (nodeInfo instanceof XSLWithParam) {
                if (((XSLWithParam)nodeInfo).isTunnelParam()) {
                    this.compileError("An xsl:with-param element within xsl:iterate must not specify tunnel='yes'", "XTSE0020");
                    return;
                }
            } else if (nodeInfo.getNodeKind() == 3) {
                if (!Whitespace.isWhite(nodeInfo.getStringValueCS())) {
                    this.compileError("No character data is allowed within xsl:next-iteration", "XTSE0010");
                    return;
                }
            } else {
                this.compileError("Child element " + Err.wrap(nodeInfo.getDisplayName(), 1) + " is not allowed as a child of xsl:next-iteration", "XTSE0010");
            }
        });
    }

    @Override
    public void postValidate() {
        NodeInfo nodeInfo;
        if (this.xslIterate == null) {
            return;
        }
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = axisIterator.next()) != null) {
            NodeInfo nodeInfo2;
            if (!(nodeInfo instanceof XSLWithParam)) continue;
            nodeInfo = (XSLWithParam)nodeInfo;
            Object object = this.xslIterate.iterateAxis((byte)3);
            boolean bl2 = false;
            while ((nodeInfo2 = object.next()) != null) {
                if (!(nodeInfo2 instanceof XSLLocalParam) || !((XSLLocalParam)nodeInfo2).getVariableQName().equals(((XSLGeneralVariable)nodeInfo).getVariableQName())) continue;
                bl2 = true;
                object = ((XSLLocalParam)nodeInfo2).getRequiredType();
                ((XSLWithParam)nodeInfo).checkAgainstRequiredType((SequenceType)object);
                break;
            }
            if (bl2) continue;
            this.compileError("Parameter " + ((XSLGeneralVariable)nodeInfo).getVariableQName().getDisplayName() + " is not declared in the containing xsl:iterate instruction", "XTSE3130");
        }
    }

    public SequenceType getDeclaredParamType(StructuredQName structuredQName) {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.xslIterate.iterateAxis((byte)3);
        while ((nodeInfo = axisIterator.next()) != null) {
            if (!(nodeInfo instanceof XSLLocalParam) || !((XSLLocalParam)nodeInfo).getVariableQName().equals(structuredQName)) continue;
            return ((XSLLocalParam)nodeInfo).getRequiredType();
        }
        return null;
    }

    @Override
    public Expression compile(Compilation withParamArray, ComponentDeclaration object) {
        NextIteration nextIteration = new NextIteration();
        nextIteration.setRetainedStaticContext(this.makeRetainedStaticContext());
        withParamArray = this.getWithParamInstructions(nextIteration, (Compilation)withParamArray, (ComponentDeclaration)object, false);
        nextIteration.setParameters(withParamArray);
        if (this.xslIterate != null) {
            NodeInfo nodeInfo;
            object = this.xslIterate.iterateAxis((byte)3);
            while ((nodeInfo = object.next()) != null) {
                if (!(nodeInfo instanceof XSLLocalParam)) continue;
                nodeInfo = (XSLLocalParam)nodeInfo;
                StructuredQName structuredQName = ((XSLGeneralVariable)nodeInfo).getVariableQName();
                LocalParam localParam = ((XSLLocalParam)nodeInfo).getCompiledParam();
                boolean bl2 = false;
                Object object2 = withParamArray;
                int n2 = withParamArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    WithParam withParam = object2[i2];
                    if (!structuredQName.equals(withParam.getVariableQName())) continue;
                    withParam.setSlotNumber(localParam.getSlotNumber());
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                object2 = new WithParam();
                ((WithParam)object2).setVariableQName(structuredQName);
                LocalVariableReference localVariableReference = new LocalVariableReference(localParam);
                ((WithParam)object2).setSelectExpression(nextIteration, localVariableReference);
                ((WithParam)object2).setSlotNumber(localParam.getSlotNumber());
                localVariableReference.setStaticType(((XSLLocalParam)nodeInfo).getRequiredType(), null, 0);
                WithParam[] withParamArray2 = new WithParam[withParamArray.length + 1];
                WithParam[] withParamArray3 = withParamArray2;
                withParamArray2[0] = object2;
                System.arraycopy(withParamArray, 0, withParamArray3, 1, withParamArray.length);
                withParamArray = withParamArray3;
            }
        }
        return nextIteration;
    }
}

