/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLIterate;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.tree.linked.NodeImpl;

public class XSLOnCompletion
extends StyleElement {
    private Expression a;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string = attributeCollection.getQName(i2);
            if (string.equals("select")) {
                string = attributeCollection.getValue(i2);
                this.a = this.makeExpression(string, i2);
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
    }

    @Override
    public void validate(ComponentDeclaration object) {
        object = (StyleElement)this.getParent();
        if (!(object instanceof XSLIterate)) {
            this.compileError("xsl:on-completion is not allowed as a child of " + ((NodeImpl)object).getDisplayName(), "XTSE0010");
        }
        this.iterateAxis((byte)11, NodeKindTest.ELEMENT).forEach((T nodeInfo) -> {
            if (!(nodeInfo instanceof XSLFallback) && !(nodeInfo instanceof XSLLocalParam)) {
                this.compileWarning("The rules for xsl:iterate have changed (see W3C bug 24179): xsl:on-completion must now be the first child of xsl:iterate after the xsl:param elements", "XTSE0010");
            }
        });
        if (this.a != null && this.iterateAxis((byte)3).next() != null) {
            this.compileError("An xsl:on-completion element with a select attribute must be empty", "XTSE3125");
        }
        this.a = this.typeCheck("select", this.a);
    }

    @Override
    public Expression compile(Compilation compilation, ComponentDeclaration componentDeclaration) {
        if (this.a == null) {
            return this.compileSequenceConstructor(compilation, componentDeclaration, true);
        }
        return this.a;
    }
}

