/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.saxon.functions.ResolveQName;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLResultDocument;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.value.Whitespace;

public class XSLOutput
extends StyleElement {
    private StructuredQName a;
    private String b = null;
    private String c = null;
    private String d = null;
    private Map<String, String> e = new HashMap<String, String>(10);
    private HashMap<String, String> f = null;

    @Override
    public boolean isDeclaration() {
        return true;
    }

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string2;
            String string3 = attributeCollection.getNodeName(i2).getStructuredQName().getClarkName();
            if (string3.equals("name")) {
                string = Whitespace.trim(attributeCollection.getValue(i2));
                continue;
            }
            if (string3.equals("version")) {
                string2 = Whitespace.trim(attributeCollection.getValue(i2));
                this.e.put(string3, string2);
                continue;
            }
            if (string3.equals("use-character-maps")) {
                this.d = attributeCollection.getValue(i2);
                continue;
            }
            if (string3.equals("parameter-document")) {
                string2 = Whitespace.trim(attributeCollection.getValue(i2));
                this.e.put(string3, string2);
                this.e.put("{http://saxon.sf.net/}parameter-document-base-uri", ((NodeImpl)this).getBaseURI());
                continue;
            }
            if (XSLResultDocument.fans.contains(string3) && !string3.equals("output-version")) {
                string2 = attributeCollection.getValue(i2);
                if (!string3.equals("item-separator") && !string3.equals("{http://saxon.sf.net/}newline")) {
                    string2 = Whitespace.trim(string2);
                }
                this.e.put(string3, string2);
                continue;
            }
            string2 = attributeCollection.getURI(i2);
            if ("".equals(string2) || "http://www.w3.org/1999/XSL/Transform".equals(string2) || "http://saxon.sf.net/".equals(string2)) {
                this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
                continue;
            }
            string3 = "{" + string2 + '}' + attributeCollection.getLocalName(i2);
            if (this.f == null) {
                this.f = new HashMap(5);
            }
            this.f.put(string3, attributeCollection.getValue(i2));
        }
        if (string != null) {
            try {
                this.a = this.makeQName(string);
                return;
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException.getMessage(), "XTSE1570");
            }
        }
    }

    public StructuredQName getFormatQName() {
        return this.a;
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        this.checkTopLevel("XTSE0010", false);
        this.checkEmpty();
    }

    @Override
    public void compileDeclaration(Compilation compilation, ComponentDeclaration componentDeclaration) {
    }

    @Override
    protected void processVersionAttribute(String string) {
        this.version = ((StyleElement)this.getParent()).getEffectiveVersion();
    }

    protected void gatherOutputProperties(Properties properties, HashMap<String, Integer> hashMap, int n2) {
        SerializerFactory serializerFactory = ((NodeImpl)this).getConfiguration().getSerializerFactory();
        for (Map.Entry<String, String> entry : this.e.entrySet()) {
            this.a(serializerFactory, entry.getKey(), entry.getValue(), properties, hashMap, n2);
        }
        if (this.e.containsKey("{http://saxon.sf.net/}next-in-chain")) {
            this.a(serializerFactory, "{http://saxon.sf.net/}next-in-chain-base-uri", ((NodeImpl)this).getSystemId(), properties, hashMap, n2);
        }
        if (this.d != null) {
            XSLOutput xSLOutput = this;
            Iterator<Map.Entry<String, String>> iterator = XSLOutput.prepareCharacterMaps(xSLOutput, xSLOutput.d, properties);
            properties.setProperty("use-character-maps", (String)((Object)iterator));
        }
        if (this.f != null) {
            for (Map.Entry<String, String> entry : this.f.entrySet()) {
                properties.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    private void a(SerializerFactory serializerFactory, String string, String string2, Properties properties, HashMap<String, Integer> hashMap, int n2) {
        try {
            if (XSLOutput.c(string)) {
                boolean bl2 = !string.equals("{http://saxon.sf.net/}attribute-order");
                boolean bl3 = string.equals("{http://saxon.sf.net/}attribute-order");
                string2 = SaxonOutputKeys.parseListOfNodeNames(string2, this, bl2, false, bl3, "XTSE0280");
            }
            if (XSLOutput.d(string) && string2.contains(":")) {
                string2 = ResolveQName.resolveQName(string2, this).getClarkName();
            }
            string2 = serializerFactory.checkOutputProperty(string, string2);
        }
        catch (XPathException xPathException) {
            String string3;
            String string4 = string3 = string.equals("method") ? "XTSE1570" : "XTSE0020";
            if (string.contains("{")) {
                this.compileError(xPathException.getMessage(), string3);
                return;
            }
            this.compileErrorInAttribute(xPathException.getMessage(), string3, string);
            return;
        }
        String string5 = properties.getProperty(string);
        if (string5 == null) {
            properties.setProperty(string, string2);
            hashMap.put(string, n2);
            return;
        }
        if (!string5.equals(string2)) {
            if (XSLOutput.c(string)) {
                properties.setProperty(string, string5 + " " + string2);
                hashMap.put(string, n2);
                return;
            }
            Integer n3 = hashMap.get(string);
            if (n3 == null) {
                return;
            }
            if (n3 <= n2) {
                if (n3 == n2) {
                    this.compileError("Conflicting values for output property " + string, "XTSE1560");
                    return;
                }
                throw new IllegalStateException("Output properties must be processed in decreasing precedence order");
            }
        }
    }

    private static boolean c(String string) {
        return string.equals("cdata-section-elements") || string.equals("suppress-indentation") || string.equals("{http://saxon.sf.net/}attribute-order") || string.equals("{http://saxon.sf.net/}double-space");
    }

    private static boolean d(String string) {
        return string.equals("method") || string.equals("json-node-output-method");
    }

    public static String prepareCharacterMaps(StyleElement styleElement, String object, Properties object2) {
        PrincipalStylesheetModule principalStylesheetModule = styleElement.getPrincipalStylesheetModule();
        if ((object2 = ((Properties)object2).getProperty("use-character-maps")) == null) {
            object2 = "";
        }
        String string = "";
        object = new StringTokenizer((String)object, " \t\n\r", false);
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string2 = ((StringTokenizer)object).nextToken();
            StructuredQName structuredQName = styleElement.makeQName(string2);
            ComponentDeclaration componentDeclaration = principalStylesheetModule.getCharacterMap(structuredQName);
            if (componentDeclaration == null) {
                styleElement.compileErrorInAttribute("No character-map named '" + string2 + "' has been defined", "XTSE1590", "use-character-maps");
            }
            string = string + " " + structuredQName.getClarkName();
        }
        object2 = string + (String)object2;
        return object2;
    }
}

