/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLCharacterMap;

public class XSLOutputCharacter
extends StyleElement {
    private int a = -1;
    private String b = null;

    @Override
    public void prepareAttributes() {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            String string = attributeCollection.getQName(i2);
            if (string.equals("character")) {
                string = attributeCollection.getValue(i2);
                switch (string.length()) {
                    case 0: {
                        this.compileError("character attribute must not be zero-length", "XTSE0020");
                        this.a = 256;
                        break;
                    }
                    case 1: {
                        this.a = string.charAt(0);
                        break;
                    }
                    case 2: {
                        if (UTF16CharacterSet.isHighSurrogate(string.charAt(0)) && UTF16CharacterSet.isLowSurrogate(string.charAt(1))) {
                            this.a = UTF16CharacterSet.combinePair(string.charAt(0), string.charAt(1));
                            break;
                        }
                        this.compileError("character attribute must be a single XML character", "XTSE0020");
                        this.a = 256;
                        break;
                    }
                    default: {
                        this.compileError("character attribute must be a single XML character", "XTSE0020");
                        this.a = 256;
                        break;
                    }
                }
                continue;
            }
            if (string.equals("string")) {
                this.b = attributeCollection.getValue(i2);
                continue;
            }
            this.checkUnknownAttribute(attributeCollection.getNodeName(i2));
        }
        if (this.a == -1) {
            this.reportAbsence("character");
            return;
        }
        if (this.b == null) {
            this.reportAbsence("string");
        }
    }

    @Override
    public void validate(ComponentDeclaration componentDeclaration) {
        if (!(this.getParent() instanceof XSLCharacterMap)) {
            this.compileError("xsl:output-character may appear only as a child of xsl:character-map", "XTSE0010");
        }
    }

    @Override
    public Expression compile(Compilation compilation, ComponentDeclaration componentDeclaration) {
        return null;
    }

    public int getCodePoint() {
        return this.a;
    }

    public String getReplacementString() {
        return this.b;
    }
}

